/*
 * Decompiled with CFR 0.152.
 */
package cn.mmf.energyblade.item;

import cn.mmf.energyblade.client.render.EnergyBladeBEWLR;
import cn.mmf.energyblade.energy.FEBladeStorage;
import cn.mmf.energyblade.energy.FECapabilityProvider;
import cn.sh1rocu.sfaddons.api.extension.IDamageable;
import cn.sh1rocu.sfaddons.util.ItemEnergyStorageHelper;
import java.util.List;
import java.util.function.Consumer;
import mods.flammpfeil.slashblade.capability.concentrationrank.CapabilityConcentrationRank;
import mods.flammpfeil.slashblade.capability.slashblade.SlashBladeState;
import mods.flammpfeil.slashblade.event.SlashBladeEvent;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_3675;
import net.minecraft.class_5250;
import net.minecraft.class_756;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;
import team.reborn.energy.api.EnergyStorage;

public class ItemFEBlade
extends ItemSlashBlade
implements IDamageable {
    public ItemFEBlade(class_1832 tier, int attackDamageIn, float attackSpeedIn, class_1792.class_1793 builder) {
        super(tier, attackDamageIn, attackSpeedIn, builder);
        EnergyStorage.ITEM.registerForItems((stack, context) -> {
            final class_2487 bladeState = stack.method_7911("bladeState");
            if (bladeState.method_10545("Energy")) {
                class_2487 tag = bladeState.method_10562("Energy");
                long energy = tag.method_10537("Energy");
                long capacity = tag.method_10537("Capacity");
                long maxReceive = tag.method_10537("MaxReceive");
                long maxExtract = tag.method_10537("MaxExtract");
                long powerupExtract = tag.method_10537("PowerupExtract");
                long standbyExtract = tag.method_10537("StandbyExtract");
                boolean energyDurability = tag.method_10577("EnergyDurability");
                boolean isPowered = tag.method_10577("isPowered");
                FEBladeStorage storage = new FEBladeStorage(energy, capacity, powerupExtract, standbyExtract, energyDurability){

                    protected void onFinalCommit() {
                        super.onFinalCommit();
                        bladeState.method_10566("Energy", (class_2520)this.serializeNBT());
                    }
                };
                storage.setMaxReceive(maxReceive);
                storage.setMaxExtract(maxExtract);
                storage.setPowered(isPowered);
                return storage;
            }
            FEBladeStorage storage = new FEBladeStorage(0L, 2000000L, 1000L, 100L, false){

                protected void onFinalCommit() {
                    super.onFinalCommit();
                    bladeState.method_10566("Energy", (class_2520)this.serializeNBT());
                }
            };
            bladeState.method_10566("Energy", (class_2520)storage.serializeNBT());
            return storage;
        }, new class_1935[]{this});
    }

    @Override
    public boolean isDamageable(class_1799 stack) {
        return ItemEnergyStorageHelper.fromStack(stack).filter(FEBladeStorage.class::isInstance).map(FEBladeStorage.class::cast).filter(FEBladeStorage::isEnergyDurability).map(energy -> false).orElseGet(() -> IDamageable.super.isDamageable(stack));
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, @Nullable class_1937 worldIn, List<class_2561> tooltip, class_1836 flagIn) {
        super.method_7851(stack, worldIn, tooltip, flagIn);
        this.appendForgeEnergyInfo(stack, tooltip);
    }

    @Environment(value=EnvType.CLIENT)
    public void appendForgeEnergyInfo(class_1799 stack, List<class_2561> tooltip) {
        ItemEnergyStorageHelper.fromStack(stack).ifPresent(energy -> {
            class_310 mc = class_310.method_1551();
            class_304 shift = mc.field_1690.field_1832;
            if (!this.isShiftKeyDown()) {
                class_5250 shiftKey = class_2561.method_43470((String)"[").method_10852((class_2561)shift.method_16007().method_27661()).method_27693("]").method_27692(class_124.field_1065);
                tooltip.add((class_2561)class_2561.method_43469((String)"tip.slashblade_fabric_addons.energyblade.energy_info", (Object[])new Object[]{shiftKey}).method_27692(class_124.field_1080));
            } else {
                class_5250 energyTip = class_2561.method_43470((String)(energy.getAmount() + " / " + energy.getCapacity())).method_27692(class_124.field_1065);
                tooltip.add((class_2561)class_2561.method_43469((String)"tip.slashblade_fabric_addons.energyblade.forge_energy_info", (Object[])new Object[]{energyTip}).method_27692(class_124.field_1080));
            }
        });
    }

    public boolean method_31567(class_1799 stack) {
        return ItemEnergyStorageHelper.fromStack(stack).filter(FEBladeStorage.class::isInstance).map(FEBladeStorage.class::cast).map(energy -> this.isShiftKeyDown() || energy.isPowered()).orElse(false);
    }

    public int method_31569(class_1799 stack) {
        return ItemEnergyStorageHelper.fromStack(stack).filter(FEBladeStorage.class::isInstance).map(FEBladeStorage.class::cast).filter(energy -> energy.getCapacity() > 0L).map(energy -> {
            double ratio = (double)energy.getAmount() / (double)energy.getCapacity();
            return (int)(ratio * 13.0);
        }).orElse(0);
    }

    public int method_31571(class_1799 stack) {
        return 0xFFAA00;
    }

    @Environment(value=EnvType.CLIENT)
    public class_756 getCustomRenderer() {
        return EnergyBladeBEWLR.INSTANCE;
    }

    public SlashBladeState initCapability(class_1799 stack) {
        return new FECapabilityProvider(stack, ItemEnergyStorageHelper.fromStack(stack).orElse(null));
    }

    public <T extends class_1309> int damageItem(class_1799 arg0, int arg1, T arg2, Consumer<T> arg3) {
        return super.damageItem(arg0, arg1, arg2, arg3);
    }

    @Environment(value=EnvType.CLIENT)
    private boolean isShiftKeyDown() {
        class_310 mc = class_310.method_1551();
        class_304 shift = mc.field_1690.field_1832;
        class_3675.class_306 key = KeyBindingHelper.getBoundKeyOf((class_304)shift);
        long window = mc.method_22683().method_4490();
        if (key.method_1442() == class_3675.class_307.field_1668) {
            return GLFW.glfwGetKey((long)window, (int)key.method_1444()) == 1;
        }
        if (key.method_1442() == class_3675.class_307.field_1672) {
            return GLFW.glfwGetMouseButton((long)window, (int)key.method_1444()) == 1;
        }
        return false;
    }

    public static void onSlashBladeUpdate(SlashBladeEvent.UpdateEvent event) {
        if (!(event.getEntity() instanceof class_1309)) {
            return;
        }
        class_1309 living = (class_1309)event.getEntity();
        if (!event.isSelected()) {
            return;
        }
        ItemEnergyStorageHelper.fromStack(event.getBlade()).ifPresent(energy -> {
            FEBladeStorage bladeFE;
            if (energy instanceof FEBladeStorage && (bladeFE = (FEBladeStorage)((Object)energy)).isPowered()) {
                try (Transaction tx = Transaction.openOuter();){
                    if (bladeFE.extract(bladeFE.getStandbyExtract(), (TransactionContext)tx) == bladeFE.getStandbyExtract()) {
                        CapabilityConcentrationRank.RANK_POINT.maybeGet((Object)living).ifPresent(cap -> cap.addRankPoint(living, cap.getMaxCapacity()));
                        tx.commit();
                    } else {
                        bladeFE.setPowered(false);
                        event.getBlade().method_7911("bladeState").method_10562("Energy").method_10556("isPowered", false);
                        event.getEntity().method_5783(class_3417.field_14627, 1.0f, 1.0f);
                    }
                }
            }
        });
    }

    public static void onSlashBladeHit(SlashBladeEvent.HitEvent event) {
        ItemEnergyStorageHelper.fromStack(event.getBlade()).ifPresent(energy -> {
            FEBladeStorage bladeFE;
            if (energy instanceof FEBladeStorage && (bladeFE = (FEBladeStorage)((Object)energy)).isPowered()) {
                try (Transaction tx = Transaction.openOuter();){
                    if (bladeFE.extract(bladeFE.getStandbyExtract(), (TransactionContext)tx) == bladeFE.getStandbyExtract()) {
                        tx.commit();
                    } else {
                        bladeFE.setPowered(false);
                        event.getBlade().method_7911("bladeState").method_10562("Energy").method_10556("isPowered", false);
                        event.getUser().method_5783(class_3417.field_14627, 1.0f, 1.0f);
                    }
                }
            }
        });
    }

    public static void onSlashBladePowered(SlashBladeEvent.PowerBladeEvent event) {
        ItemEnergyStorageHelper.fromStack(event.getBlade()).ifPresent(energy -> {
            FEBladeStorage bladeFE;
            if (energy instanceof FEBladeStorage && (bladeFE = (FEBladeStorage)((Object)energy)).isPowered()) {
                event.setPowered(true);
            }
        });
    }
}

