package cn.mmf.energyblade.compat;

import cn.mmf.energyblade.Energyblade;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.ingredients.subtypes.ISubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.registration.ISubtypeRegistration;
import mods.flammpfeil.slashblade.capability.slashblade.CapabilitySlashBlade;
import mods.flammpfeil.slashblade.capability.slashblade.ISlashBladeState;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

@JeiPlugin
public class JEICompat implements IModPlugin {

    @Override
    public class_2960 getPluginUid() {
        return class_2960.method_60655(Energyblade.MODID, Energyblade.MODID);
    }

    @Override
    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.registerSubtypeInterpreter(Energyblade.FORGE_ENERGY_BLADE, new ISubtypeInterpreter<class_1799>() {
            @Override
            public @Nullable Object getSubtypeData(class_1799 itemStack, UidContext uidContext) {
                return CapabilitySlashBlade.getBladeState(itemStack).map(ISlashBladeState::getTranslationKey).orElse("");
            }

            @Override
            public String getLegacyStringSubtypeInfo(class_1799 itemStack, UidContext uidContext) {
                return CapabilitySlashBlade.getBladeState(itemStack).map(ISlashBladeState::getTranslationKey).orElse("");
            }
        });
    }

}
