package cn.mmf.slashblade_addon.data;

import cn.mmf.energyblade.Energyblade;
import cn.mmf.slashblade_addon.SlashBladeAddon;
import cn.mmf.slashblade_addon.registry.SBASlashArtsRegistry;
import cn.mmf.slashblade_addon.registry.SBASpecialEffectsRegistry;
import mods.flammpfeil.slashblade.client.renderer.CarryType;
import mods.flammpfeil.slashblade.item.SwordType;
import mods.flammpfeil.slashblade.registry.SlashArtsRegistry;
import mods.flammpfeil.slashblade.registry.SpecialEffectsRegistry;
import mods.flammpfeil.slashblade.registry.slashblade.EnchantmentDefinition;
import mods.flammpfeil.slashblade.registry.slashblade.PropertiesDefinition;
import mods.flammpfeil.slashblade.registry.slashblade.RenderDefinition;
import mods.flammpfeil.slashblade.registry.slashblade.SlashBladeDefinition;
import net.fabricmc.fabric.api.resource.conditions.v1.ResourceCondition;
import net.fabricmc.fabric.api.resource.conditions.v1.ResourceConditions;
import net.minecraft.class_1834;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7891;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SlashBladeAddonBuiltInRegistry {

    //Nihil
    public static final class_5321<SlashBladeDefinition> NIHIL = register("nihil");
    public static final class_5321<SlashBladeDefinition> NIHILEX = register("nihilex");
    public static final class_5321<SlashBladeDefinition> NIHILBX = register("nihilbx");
    public static final class_5321<SlashBladeDefinition> NIHILUL = register("nihilul");
    public static final class_5321<SlashBladeDefinition> CRIMSONCHERRY = register("crimsoncherry");

    //WA
    public static final class_5321<SlashBladeDefinition> KATANA = register("katana");
    public static final class_5321<SlashBladeDefinition> TACHI = register("tachi");
    public static final class_5321<SlashBladeDefinition> BLUE = register("blue");

    //BladeMaster
    public static final class_5321<SlashBladeDefinition> GREEN_MIST = register("green_mist");
    public static final class_5321<SlashBladeDefinition> AQUABLAZE = register("aquablaze");
    public static final class_5321<SlashBladeDefinition> MOONLIGHT_CHERRY = register("moonlight_cherry");

    //Dark Raven
    public static final class_5321<SlashBladeDefinition> DARK_RAVEN = register("dark_raven");
    public static final class_5321<SlashBladeDefinition> SNOW_CROW = register("snow_crow");

    //Fluorescent Bar
    public static final class_5321<SlashBladeDefinition> FLUORESCENT_BAR = register("fluorescent_bar");

    //Frost Wolf
    public static final class_5321<SlashBladeDefinition> FROSTY_CHERRY = register("frosty_cherry");
    public static final class_5321<SlashBladeDefinition> FROST_WOLF = register("frost_wolf");

    //Toyako
    public static final class_5321<SlashBladeDefinition> TOYAKO = register("toyako");

    //Yukari
    public static final class_5321<SlashBladeDefinition> YUKARI = register("yukari");

    //Laemmle
    public static final class_5321<SlashBladeDefinition> LAEMMLE = register("laemmle");

    //Tboen
    public static final class_5321<SlashBladeDefinition> TBOEN = register("tboen");

    public static final class_5321<SlashBladeDefinition> KIRISAYA = register("kirisaya");

    public static final class_5321<SlashBladeDefinition> TERRA_BLADE = register("terra_blade");

    //Laemmle
    public static final class_5321<SlashBladeDefinition> KAMUY_NONE = register("kamuy_none");

    public static final class_5321<SlashBladeDefinition> KAMUY_WATER = register("kamuy_water");

    public static final class_5321<SlashBladeDefinition> KAMUY_FIRE = register("kamuy_fire");

    public static final class_5321<SlashBladeDefinition> KAMUY_LIGHTING = register("kamuy_lightning");

    public static final class_5321<SlashBladeDefinition> HF_MURASAMA = register("hf_murasama");

    //wanderer
    public static final class_5321<SlashBladeDefinition> WANDERER = register("wanderer");
    public static final class_5321<SlashBladeDefinition> WANDERER_HF = register("wanderer_hf");

    public static final class_5321<SlashBladeDefinition> MURAKUMO = register("murakumo");


    private static final Map<class_5321<SlashBladeDefinition>, List<ResourceCondition>> CONDITIONS = new HashMap<>();

    public static Map<class_5321<SlashBladeDefinition>, List<ResourceCondition>> getConditions() {
        return CONDITIONS;
    }

    public static void addConditions(class_5321<SlashBladeDefinition> key, ResourceCondition conditions) {
        CONDITIONS.computeIfAbsent(key, k -> List.of(conditions));
    }

    public static class SJAPDefinition extends SlashBladeDefinition {
        public SJAPDefinition(class_2960 name, RenderDefinition renderDefinition, PropertiesDefinition stateDefinition, List<EnchantmentDefinition> enchantments) {
            super(name, renderDefinition, stateDefinition, enchantments, class_7923.field_44687.method_10221(SlashBladeAddon.SJAP_TAB));
        }

        public SJAPDefinition(class_2960 item, class_2960 name, RenderDefinition renderDefinition, PropertiesDefinition stateDefinition, List<EnchantmentDefinition> enchantments) {
            super(item, name, renderDefinition, stateDefinition, enchantments, class_7923.field_44687.method_10221(SlashBladeAddon.SJAP_TAB));
        }
    }

    public static void registerAll(class_7891<SlashBladeDefinition> bootstrap) {
        //MURAKUMO
        bootstrap.method_46838(MURAKUMO,
                new SJAPDefinition(SlashBladeAddon.prefix("murakumo"),
                        RenderDefinition.Builder.newInstance()
                                .textureName(SlashBladeAddon.prefix("model/murakumo/texture.png"))
                                .modelName(SlashBladeAddon.prefix("model/murakumo/model.obj"))
                                .standbyRenderType(CarryType.PSO2)
                                .build(),
                        PropertiesDefinition.Builder.newInstance()
                                .baseAttackModifier(9.0F)
                                .slashArtsType(SlashArtsRegistry.SLASH_ARTS.method_10221(SlashArtsRegistry.SAKURA_END))
                                .defaultSwordType(List.of(SwordType.BEWITCHED))
                                .maxDamage(80).build(),
                        List.of(new EnchantmentDefinition(getEnchantmentID(class_1893.field_9123), 1))));

        bootstrap.method_46838(HF_MURASAMA, new SJAPDefinition(class_7923.field_41178.method_10221(Energyblade.FORGE_ENERGY_BLADE),
                SlashBladeAddon.prefix("hf_murasama"),
                RenderDefinition.Builder.newInstance()
                        .textureName(SlashBladeAddon.prefix("model/murasama/murasama.png"))
                        .modelName(SlashBladeAddon.prefix("model/murasama/murasama.obj"))
                        .effectColor(0xFFFF2600)
                        .standbyRenderType(CarryType.PSO2).build(),
                PropertiesDefinition.Builder.newInstance().baseAttackModifier(8.0F).maxDamage(250)
                        .defaultSwordType(List.of(SwordType.BEWITCHED))
                        .slashArtsType(SlashArtsRegistry.SLASH_ARTS.method_10221(SBASlashArtsRegistry.SPIRAL_EDGE)).build(),
                List.of()));
        bootstrap.method_46838(WANDERER_HF, new SJAPDefinition(class_7923.field_41178.method_10221(Energyblade.FORGE_ENERGY_BLADE),
                SlashBladeAddon.prefix("wanderer_hf"),
                RenderDefinition.Builder.newInstance()
                        .textureName(SlashBladeAddon.prefix("model/wanderer/wanderer.png"))
                        .modelName(SlashBladeAddon.prefix("model/wanderer/wanderer.obj"))
                        .standbyRenderType(CarryType.NINJA).build(),
                PropertiesDefinition.Builder.newInstance().baseAttackModifier(7.0F).maxDamage(70)
                        .defaultSwordType(List.of(SwordType.BEWITCHED))
                        .slashArtsType(SlashArtsRegistry.SLASH_ARTS.method_10221(SBASlashArtsRegistry.RAPID_BLISTERING_SWORDS)).build(),
                List.of()));
        addConditions(WANDERER_HF, ResourceConditions.registryContains(class_7924.field_41197, class_7923.field_41178.method_10221(Energyblade.FORGE_ENERGY_BLADE)));
        addConditions(HF_MURASAMA, ResourceConditions.registryContains(class_7924.field_41197, class_7923.field_41178.method_10221(Energyblade.FORGE_ENERGY_BLADE)));

        bootstrap.method_46838(WANDERER, new SJAPDefinition(
                SlashBladeAddon.prefix("wanderer"),
                RenderDefinition.Builder.newInstance()
                        .textureName(SlashBladeAddon.prefix("model/wanderer/wanderer.png"))
                        .modelName(SlashBladeAddon.prefix("model/wanderer/wanderer.obj"))
                        .standbyRenderType(CarryType.NINJA).build(),
                PropertiesDefinition.Builder.newInstance().baseAttackModifier(7.0F).maxDamage(60)
                        .defaultSwordType(List.of(SwordType.BEWITCHED))
                        .slashArtsType(SlashArtsRegistry.SLASH_ARTS.method_10221(SBASlashArtsRegistry.RAPID_BLISTERING_SWORDS)).build(),
                List.of()));

        bootstrap.method_46838(KAMUY_NONE,
                new SJAPDefinition(SlashBladeAddon.prefix("kamuy_none"),
                        RenderDefinition.Builder.newInstance()
                                .textureName(SlashBladeAddon.prefix("model/kamuy/kamuy.png"))
                                .modelName(SlashBladeAddon.prefix("model/kamuy/kamuy.obj"))
                                .standbyRenderType(CarryType.PSO2)
                                .build(),
                        PropertiesDefinition.Builder.newInstance()
                                .baseAttackModifier(7.0F)
                                .maxDamage(45)
                                .slashArtsType(SlashArtsRegistry.SLASH_ARTS.method_10221(SlashArtsRegistry.CIRCLE_SLASH))
                                .defaultSwordType(List.of(SwordType.BEWITCHED)).build(),
                        List.of(new EnchantmentDefinition(getEnchantmentID(class_1893.field_9110), 1)))
        );

        bootstrap.method_46838(KAMUY_WATER,
                new SJAPDefinition(SlashBladeAddon.prefix("kamuy_water"),
                        RenderDefinition.Builder.newInstance()
                                .textureName(SlashBladeAddon.prefix("model/kamuy/water.png"))
                                .modelName(SlashBladeAddon.prefix("model/kamuy/kamuy.obj"))
                                .standbyRenderType(CarryType.PSO2)
                                .build(),
                        PropertiesDefinition.Builder.newInstance()
                                .baseAttackModifier(7.0F)
                                .maxDamage(50)
                                .slashArtsType(SlashArtsRegistry.SLASH_ARTS.method_10221(SBASlashArtsRegistry.WATER_DRIVE))
                                .defaultSwordType(List.of(SwordType.BEWITCHED)).build(),
                        List.of(new EnchantmentDefinition(getEnchantmentID(class_1893.field_9119), 3),
                                new EnchantmentDefinition(getEnchantmentID(class_1893.field_9121), 2),
                                new EnchantmentDefinition(getEnchantmentID(class_1893.field_9110), 3),
                                new EnchantmentDefinition(getEnchantmentID(class_1893.field_9095), 1)))
        );

        bootstrap.method_46838(KAMUY_LIGHTING,
                new SJAPDefinition(SlashBladeAddon.prefix("kamuy_lightning"),
                        RenderDefinition.Builder.newInstance()
                                .textureName(SlashBladeAddon.prefix("model/kamuy/lightning.png"))
                                .modelName(SlashBladeAddon.prefix("model/kamuy/kamuy.obj"))
                                .effectColor(0xFFFAE900)
                                .standbyRenderType(CarryType.PSO2)
                                .build(),
                        PropertiesDefinition.Builder.newInstance()
                                .baseAttackModifier(7.0F)
                                .maxDamage(50)
                                .slashArtsType(SlashArtsRegistry.SLASH_ARTS.method_10221(SBASlashArtsRegistry.LIGHTING_SWORDS))
                                .defaultSwordType(List.of(SwordType.BEWITCHED)).build(),
                        List.of(new EnchantmentDefinition(getEnchantmentID(class_1893.field_9119), 3),
                                new EnchantmentDefinition(getEnchantmentID(class_1893.field_9123), 3),
                                new EnchantmentDefinition(getEnchantmentID(class_1893.field_9129), 1)))
        );

        bootstrap.method_46838(KAMUY_FIRE,
                new SJAPDefinition(SlashBladeAddon.prefix("kamuy_fire"),
                        RenderDefinition.Builder.newInstance()
                                .textureName(SlashBladeAddon.prefix("model/kamuy/fire.png"))
                                .modelName(SlashBladeAddon.prefix("model/kamuy/kamuy.obj"))
                                .standbyRenderType(CarryType.PSO2)
                                .effectColor(0xFFEE2600)
                                .build(),
                        PropertiesDefinition.Builder.newInstance()
                                .baseAttackModifier(7.0F)
                                .maxDamage(40)
                                .slashArtsType(SlashArtsRegistry.SLASH_ARTS.method_10221(SBASlashArtsRegistry.FIRE_SPIRAL))
                                .defaultSwordType(List.of(SwordType.BEWITCHED)).build(),
                        List.of(new EnchantmentDefinition(getEnchantmentID(class_1893.field_9119), 3),
                                new EnchantmentDefinition(getEnchantmentID(class_1893.field_9112), 2),
                                new EnchantmentDefinition(getEnchantmentID(class_1893.field_9095), 1),
                                new EnchantmentDefinition(getEnchantmentID(class_1893.field_9124), 1)))
        );

        bootstrap.method_46838(TERRA_BLADE,
                new SJAPDefinition(SlashBladeAddon.prefix("terra_blade"),
                        RenderDefinition.Builder.newInstance()
                                .textureName(SlashBladeAddon.prefix("model/terra/terra.png"))
                                .modelName(SlashBladeAddon.prefix("model/terra/terra.obj"))
                                .standbyRenderType(CarryType.RNINJA)
                                .effectColor(3524113)
                                .build(),
                        PropertiesDefinition.Builder.newInstance()
                                .baseAttackModifier(6.0F)
                                .maxDamage(60)
                                .slashArtsType(SlashBladeAddon.prefix("blistering_terra_swords")/*SlashArtsRegistry.SLASH_ARTS.getKey(SBABotaniaCompat.BLISTERING_TERRA_SWORDS_SA)*/)
                                .addSpecialEffect(SlashBladeAddon.prefix("mana_burst")/*SpecialEffectsRegistry.SPECIAL_EFFECT.getKey(SBABotaniaCompat.MANA_BURST)*/)
                                .addSpecialEffect(SlashBladeAddon.prefix("mana_repair")/*SpecialEffectsRegistry.SPECIAL_EFFECT.getKey(SBABotaniaCompat.MANA_REPAIR)*/)
                                .defaultSwordType(List.of(SwordType.BEWITCHED)).build(),
                        List.of(new EnchantmentDefinition(getEnchantmentID(class_1893.field_9103), 1))));

        addConditions(TERRA_BLADE, ResourceConditions.allModsLoaded("botania"));

        //Kirisaya
        bootstrap.method_46838(KIRISAYA,
                new SJAPDefinition(SlashBladeAddon.prefix("kirisaya"),
                        RenderDefinition.Builder.newInstance()
                                .textureName(SlashBladeAddon.prefix("model/kirisaya/kirisaya.png"))
                                .modelName(SlashBladeAddon.prefix("model/kirisaya/kirisaya.obj"))
                                .standbyRenderType(CarryType.KATANA)
                                .build(),
                        PropertiesDefinition.Builder.newInstance()
                                .baseAttackModifier(3.0F)
                                .maxDamage(11)
                                .slashArtsType(SlashArtsRegistry.SLASH_ARTS.method_10221(SlashArtsRegistry.DRIVE_HORIZONTAL))
                                .addSpecialEffect(SpecialEffectsRegistry.SPECIAL_EFFECT.method_10221(SBASpecialEffectsRegistry.BURST_DRIVE))
                                .defaultSwordType(List.of(SwordType.BEWITCHED)).build(),
                        List.of(new EnchantmentDefinition(getEnchantmentID(class_1893.field_9119), 3),
                                new EnchantmentDefinition(getEnchantmentID(class_1893.field_9103), 5)
                        )));

        //Laemmle
        bootstrap.method_46838(LAEMMLE,
                new SJAPDefinition(SlashBladeAddon.prefix("laemmle"),
                        RenderDefinition.Builder.newInstance()
                                .textureName(SlashBladeAddon.prefix("model/laemmle/lem.png"))
                                .modelName(SlashBladeAddon.prefix("model/laemmle/blade.obj"))
                                .standbyRenderType(CarryType.PSO2)
                                .build(),
                        PropertiesDefinition.Builder.newInstance()
                                .baseAttackModifier(7.0F)
                                .maxDamage(80).build(),
                        List.of(new EnchantmentDefinition(getEnchantmentID(class_1893.field_9118), 3))));

        //Yukari
        bootstrap.method_46838(YUKARI,
                new SJAPDefinition(SlashBladeAddon.prefix("yukari"),
                        RenderDefinition.Builder.newInstance()
                                .textureName(SlashBladeAddon.prefix("model/yukari/texture.png"))
                                .modelName(SlashBladeAddon.prefix("model/yukari/model.obj"))
                                .standbyRenderType(CarryType.PSO2)
                                .build(),
                        PropertiesDefinition.Builder.newInstance()
                                .baseAttackModifier(8.0F)
                                .maxDamage(50)
                                .slashArtsType(SlashArtsRegistry.SLASH_ARTS.method_10221(SlashArtsRegistry.DRIVE_HORIZONTAL))
                                .defaultSwordType(List.of(SwordType.NONE)).build(), List.of()));

        //Tboen
        bootstrap.method_46838(TBOEN,
                new SJAPDefinition(SlashBladeAddon.prefix("tboen"),
                        RenderDefinition.Builder.newInstance()
                                .textureName(SlashBladeAddon.prefix("model/tboen/texture.png"))
                                .modelName(SlashBladeAddon.prefix("model/tboen/model.obj"))
                                .standbyRenderType(CarryType.KATANA)
                                .build(),
                        PropertiesDefinition.Builder.newInstance()
                                .baseAttackModifier(6.0F)
                                .slashArtsType(SlashArtsRegistry.SLASH_ARTS.method_10221(SlashArtsRegistry.SAKURA_END))
                                .maxDamage(70)
                                .defaultSwordType(List.of(SwordType.NONE)).build(), List.of()));

        //Toyako
        bootstrap.method_46838(TOYAKO,
                new SJAPDefinition(SlashBladeAddon.prefix("toyako"),
                        RenderDefinition.Builder.newInstance()
                                .textureName(SlashBladeAddon.prefix("model/toyako/toyako.png"))
                                .modelName(SlashBladeAddon.prefix("model/toyako/toyako.obj"))
                                .standbyRenderType(CarryType.KATANA)
                                .build(),
                        PropertiesDefinition.Builder.newInstance()
                                .baseAttackModifier(6.0F)
                                .maxDamage(70)
                                .defaultSwordType(List.of(SwordType.NONE)).build(), List.of()));

        //nihil
        bootstrap.method_46838(NIHIL,
                new SJAPDefinition(SlashBladeAddon.prefix("nihil"),
                        RenderDefinition.Builder.newInstance()
                                .textureName(SlashBladeAddon.prefix("model/nihil/nihil.png"))
                                .modelName(SlashBladeAddon.prefix("model/nihil/nihil.obj"))
                                .standbyRenderType(CarryType.KATANA)
                                .build(),
                        PropertiesDefinition.Builder.newInstance()
                                .baseAttackModifier(8.0F)
                                .maxDamage(45)
                                .slashArtsType(SlashArtsRegistry.SLASH_ARTS.method_10221(SlashArtsRegistry.DRIVE_HORIZONTAL))
                                .defaultSwordType(List.of(SwordType.BEWITCHED)).build(),
                        List.of(new EnchantmentDefinition(getEnchantmentID(class_1893.field_9119), 3),
                                new EnchantmentDefinition(getEnchantmentID(class_1893.field_9118), 2),
                                new EnchantmentDefinition(getEnchantmentID(class_1893.field_9123), 1),
                                new EnchantmentDefinition(getEnchantmentID(class_1893.field_9124), 1))));

        bootstrap.method_46838(NIHILEX,
                new SJAPDefinition(SlashBladeAddon.prefix("nihilex"),
                        RenderDefinition.Builder.newInstance()
                                .textureName(SlashBladeAddon.prefix("model/nihil/nihilex.png"))
                                .modelName(SlashBladeAddon.prefix("model/nihil/nihil.obj"))
                                .standbyRenderType(CarryType.KATANA)
                                .build(),
                        PropertiesDefinition.Builder.newInstance()
                                .baseAttackModifier(10.0F)
                                .maxDamage(60)
                                .slashArtsType(SlashArtsRegistry.SLASH_ARTS.method_10221(SlashArtsRegistry.WAVE_EDGE))
                                .defaultSwordType(List.of(SwordType.BEWITCHED)).build(),
                        List.of(new EnchantmentDefinition(getEnchantmentID(class_1893.field_9119), 2),
                                new EnchantmentDefinition(getEnchantmentID(class_1893.field_9118), 3),
                                new EnchantmentDefinition(getEnchantmentID(class_1893.field_9123), 2),
                                new EnchantmentDefinition(getEnchantmentID(class_1893.field_9112), 1),
                                new EnchantmentDefinition(getEnchantmentID(class_1893.field_9124), 2),
                                new EnchantmentDefinition(getEnchantmentID(class_1893.field_9110), 1))));

        bootstrap.method_46838(NIHILUL,
                new SJAPDefinition(SlashBladeAddon.prefix("nihilul"),
                        RenderDefinition.Builder.newInstance()
                                .textureName(SlashBladeAddon.prefix("model/nihil/nihilul.png"))
                                .modelName(SlashBladeAddon.prefix("model/nihil/nihil.obj"))
                                .standbyRenderType(CarryType.KATANA)
                                .build(),
                        PropertiesDefinition.Builder.newInstance()
                                .baseAttackModifier(12.0F)
                                .maxDamage(70)
                                .slashArtsType(SlashArtsRegistry.SLASH_ARTS.method_10221(SlashArtsRegistry.WAVE_EDGE))
                                .defaultSwordType(List.of(SwordType.BEWITCHED)).build(),
                        List.of(new EnchantmentDefinition(getEnchantmentID(class_1893.field_9119), 3),
                                new EnchantmentDefinition(getEnchantmentID(class_1893.field_9118), 5),
                                new EnchantmentDefinition(getEnchantmentID(class_1893.field_9123), 3),
                                new EnchantmentDefinition(getEnchantmentID(class_1893.field_9112), 2),
                                new EnchantmentDefinition(getEnchantmentID(class_1893.field_9124), 2),
                                new EnchantmentDefinition(getEnchantmentID(class_1893.field_9110), 3))));

        bootstrap.method_46838(CRIMSONCHERRY,
                new SJAPDefinition(SlashBladeAddon.prefix("crimsoncherry"),
                        RenderDefinition.Builder.newInstance()
                                .textureName(SlashBladeAddon.prefix("model/nihil/crimsoncherry.png"))
                                .modelName(SlashBladeAddon.prefix("model/nihil/nihil.obj"))
                                .standbyRenderType(CarryType.KATANA)
                                .build(),
                        PropertiesDefinition.Builder.newInstance()
                                .baseAttackModifier(11.0F)
                                .maxDamage(65)
                                .slashArtsType(SlashArtsRegistry.SLASH_ARTS.method_10221(SlashArtsRegistry.SAKURA_END))
                                .defaultSwordType(List.of(SwordType.BEWITCHED)).build(),
                        List.of(new EnchantmentDefinition(getEnchantmentID(class_1893.field_9118), 5),
                                new EnchantmentDefinition(getEnchantmentID(class_1893.field_9123), 3),
                                new EnchantmentDefinition(getEnchantmentID(class_1893.field_9112), 3),
                                new EnchantmentDefinition(getEnchantmentID(class_1893.field_9124), 2))));

        bootstrap.method_46838(NIHILBX,
                new SJAPDefinition(SlashBladeAddon.prefix("nihilbx"),
                        RenderDefinition.Builder.newInstance()
                                .textureName(SlashBladeAddon.prefix("model/nihil/nihil_bx.png"))
                                .modelName(SlashBladeAddon.prefix("model/nihil/nihil.obj"))
                                .standbyRenderType(CarryType.KATANA)
                                .build(),
                        PropertiesDefinition.Builder.newInstance()
                                .baseAttackModifier(13.0F)
                                .maxDamage(240)
                                .slashArtsType(SlashArtsRegistry.SLASH_ARTS.method_10221(SlashArtsRegistry.SAKURA_END))
                                .defaultSwordType(List.of(SwordType.BEWITCHED)).build(),
                        List.of(new EnchantmentDefinition(getEnchantmentID(class_1893.field_9119), 3),
                                new EnchantmentDefinition(getEnchantmentID(class_1893.field_9118), 5),
                                new EnchantmentDefinition(getEnchantmentID(class_1893.field_9123), 5),
                                new EnchantmentDefinition(getEnchantmentID(class_1893.field_9112), 5),
                                new EnchantmentDefinition(getEnchantmentID(class_1893.field_9124), 2))));

        //WA
        bootstrap.method_46838(KATANA,
                new SJAPDefinition(SlashBladeAddon.prefix("katana"),
                        RenderDefinition.Builder.newInstance()
                                .textureName(SlashBladeAddon.prefix("model/wa/katana.png"))
                                .modelName(SlashBladeAddon.prefix("model/wa/wa.obj"))
                                .standbyRenderType(CarryType.KATANA)
                                .build(),
                        PropertiesDefinition.Builder.newInstance()
                                .baseAttackModifier(3.0F)
                                .maxDamage(457)
                                .defaultSwordType(List.of(SwordType.NONE)).build(), List.of()));

        bootstrap.method_46838(TACHI,
                new SJAPDefinition(SlashBladeAddon.prefix("tachi"),
                        RenderDefinition.Builder.newInstance()
                                .textureName(SlashBladeAddon.prefix("model/wa/tachi.png"))
                                .modelName(SlashBladeAddon.prefix("model/wa/wa.obj"))
                                .standbyRenderType(CarryType.DEFAULT)
                                .build(),
                        PropertiesDefinition.Builder.newInstance()
                                .baseAttackModifier(3.0F)
                                .maxDamage(457)
                                .defaultSwordType(List.of(SwordType.NONE)).build(), List.of()));

        bootstrap.method_46838(BLUE,
                new SJAPDefinition(SlashBladeAddon.prefix("blue"),
                        RenderDefinition.Builder.newInstance()
                                .textureName(SlashBladeAddon.prefix("model/wa/blue.png"))
                                .modelName(SlashBladeAddon.prefix("model/wa/wa.obj"))
                                .standbyRenderType(CarryType.KATANA)
                                .build(),
                        PropertiesDefinition.Builder.newInstance()
                                .baseAttackModifier(7.0F)
                                .maxDamage(75)
                                .defaultSwordType(List.of(SwordType.NONE)).build(), List.of()));

        //BladeMaster
        bootstrap.method_46838(GREEN_MIST,
                new SJAPDefinition(SlashBladeAddon.prefix("green_mist"),
                        RenderDefinition.Builder.newInstance()
                                .textureName(SlashBladeAddon.prefix("model/blademaster/green_mist.png"))
                                .modelName(SlashBladeAddon.prefix("model/blademaster/blademaster.obj"))
                                .standbyRenderType(CarryType.PSO2)
                                .build(),
                        PropertiesDefinition.Builder.newInstance()
                                .baseAttackModifier(4.0F + class_1834.field_8930.method_8028())
                                .maxDamage(60)
                                .slashArtsType(SlashArtsRegistry.SLASH_ARTS.method_10221(SBASlashArtsRegistry.RAPID_BLISTERING_SWORDS))
                                .defaultSwordType(List.of(SwordType.BEWITCHED)).build(),
                        List.of(new EnchantmentDefinition(getEnchantmentID(class_1893.field_9103), 3),
                                new EnchantmentDefinition(getEnchantmentID(class_1893.field_9130), 3))));

        bootstrap.method_46838
                (
                        AQUABLAZE,
                        new SJAPDefinition
                                (
                                        SlashBladeAddon.prefix("aquablaze"),
                                        RenderDefinition.Builder.newInstance()
                                                .textureName(SlashBladeAddon.prefix("model/blademaster/aquablaze.png"))
                                                .modelName(SlashBladeAddon.prefix("model/blademaster/blademaster.obj"))
                                                .standbyRenderType(CarryType.PSO2)
                                                .build(),
                                        PropertiesDefinition.Builder.newInstance()
                                                .baseAttackModifier(4.0F + class_1834.field_8930.method_8028())
                                                .maxDamage(60)
                                                .slashArtsType(SlashArtsRegistry.SLASH_ARTS.method_10221(SBASlashArtsRegistry.SPIRAL_EDGE))
                                                .defaultSwordType(List.of(SwordType.BEWITCHED)).build(),
                                        List.of
                                                (
                                                        new EnchantmentDefinition(getEnchantmentID(class_1893.field_9124), 2),
                                                        new EnchantmentDefinition(getEnchantmentID(class_1893.field_9095), 1)
                                                )
                                )
                );

        bootstrap.method_46838
                (
                        MOONLIGHT_CHERRY,
                        new SJAPDefinition
                                (
                                        SlashBladeAddon.prefix("moonlight_cherry"),
                                        RenderDefinition.Builder.newInstance()
                                                .textureName(SlashBladeAddon.prefix("model/blademaster/moonlightcherry.png"))
                                                .modelName(SlashBladeAddon.prefix("model/blademaster/blademaster.obj"))
                                                .standbyRenderType(CarryType.PSO2)
                                                .build(),
                                        PropertiesDefinition.Builder.newInstance()
                                                .baseAttackModifier(4.0F + class_1834.field_8930.method_8028())
                                                .maxDamage(60)
                                                .slashArtsType(SlashArtsRegistry.SLASH_ARTS.method_10221(SBASlashArtsRegistry.GALE_SWORDS))
                                                .defaultSwordType(List.of(SwordType.BEWITCHED)).build(),
                                        List.of
                                                (
                                                        new EnchantmentDefinition(getEnchantmentID(class_1893.field_9097), 1),
                                                        new EnchantmentDefinition(getEnchantmentID(class_1893.field_9123), 5)
                                                )
                                )
                );

        //Dark Raven
        bootstrap.method_46838
                (
                        DARK_RAVEN,
                        new SJAPDefinition
                                (
                                        SlashBladeAddon.prefix("dark_raven"),
                                        RenderDefinition.Builder.newInstance()
                                                .textureName(SlashBladeAddon.prefix("model/darkraven/dark_raven.png"))
                                                .modelName(SlashBladeAddon.prefix("model/darkraven/dark_raven.obj"))
                                                .standbyRenderType(CarryType.PSO2)
                                                .build(),
                                        PropertiesDefinition.Builder.newInstance()
                                                .baseAttackModifier(4.0F + class_1834.field_8930.method_8028())
                                                .maxDamage(80)
                                                .slashArtsType(SlashArtsRegistry.SLASH_ARTS.method_10221(SlashArtsRegistry.WAVE_EDGE))
                                                .defaultSwordType(List.of(SwordType.NONE)).build(),
                                        List.of()
                                )
                );

        bootstrap.method_46838
                (
                        SNOW_CROW,
                        new SJAPDefinition
                                (
                                        SlashBladeAddon.prefix("snow_crow"),
                                        RenderDefinition.Builder.newInstance()
                                                .textureName(SlashBladeAddon.prefix("model/darkraven/snow_crow.png"))
                                                .modelName(SlashBladeAddon.prefix("model/darkraven/snow_crow.obj"))
                                                .standbyRenderType(CarryType.PSO2)
                                                .build(),
                                        PropertiesDefinition.Builder.newInstance()
                                                .baseAttackModifier(4.0F + class_1834.field_8923.method_8028())
                                                .maxDamage(60)
                                                .defaultSwordType(List.of(SwordType.NONE)).build(),
                                        List.of()
                                )
                );

        //Fluorescent Bar
        bootstrap.method_46838
                (
                        FLUORESCENT_BAR,
                        new SJAPDefinition
                                (
                                        SlashBladeAddon.prefix("fluorescent_bar"),
                                        RenderDefinition.Builder.newInstance()
                                                .textureName(SlashBladeAddon.prefix("model/fluorescentbar/fluorescent_bar.png"))
                                                .modelName(SlashBladeAddon.prefix("model/fluorescentbar/fluorescent_bar.obj"))
                                                .standbyRenderType(CarryType.PSO2)
                                                .build(),
                                        PropertiesDefinition.Builder.newInstance()
                                                .baseAttackModifier(2.0F)
                                                .maxDamage(class_1834.field_8930.method_8025())
                                                .defaultSwordType(List.of(SwordType.NONE)).build(),
                                        List.of
                                                (
                                                        new EnchantmentDefinition(getEnchantmentID(class_1893.field_9119), 3)
                                                )
                                )
                );

        //Frost Wolf
        bootstrap.method_46838
                (
                        FROSTY_CHERRY,
                        new SJAPDefinition
                                (
                                        SlashBladeAddon.prefix("frosty_cherry"),
                                        RenderDefinition.Builder.newInstance()
                                                .textureName(SlashBladeAddon.prefix("model/frostwolf/frosty_cherry.png"))
                                                .modelName(SlashBladeAddon.prefix("model/frostwolf/frosty_cherry.obj"))
                                                .standbyRenderType(CarryType.PSO2)
                                                .build(),
                                        PropertiesDefinition.Builder.newInstance()
                                                .baseAttackModifier(4.0F + class_1834.field_8930.method_8028())
                                                .maxDamage(150)
                                                .slashArtsType(SlashArtsRegistry.SLASH_ARTS.method_10221(SBASlashArtsRegistry.RAPID_BLISTERING_SWORDS))
                                                .defaultSwordType(List.of(SwordType.BEWITCHED)).build(),
                                        List.of()
                                )
                );

        bootstrap.method_46838
                (
                        FROST_WOLF,
                        new SJAPDefinition
                                (
                                        SlashBladeAddon.prefix("frost_wolf"),
                                        RenderDefinition.Builder.newInstance()
                                                .textureName(SlashBladeAddon.prefix("model/frostwolf/frost_wolf.png"))
                                                .modelName(SlashBladeAddon.prefix("model/frostwolf/frost_wolf.obj"))
                                                .standbyRenderType(CarryType.PSO2)
                                                .build(),
                                        PropertiesDefinition.Builder.newInstance()
                                                .baseAttackModifier(4.0F + class_1834.field_8930.method_8028())
                                                .maxDamage(150)
                                                .slashArtsType(SlashArtsRegistry.SLASH_ARTS.method_10221(SBASlashArtsRegistry.GALE_SWORDS))
                                                .defaultSwordType(List.of(SwordType.BEWITCHED)).build(),
                                        List.of()
                                )
                );

    }

    private static class_5321<SlashBladeDefinition> register(String id) {

        return class_5321.method_29179(SlashBladeDefinition.REGISTRY_KEY, SlashBladeAddon.prefix(id));
    }

    private static class_2960 getEnchantmentID(class_5321<class_1887> key) {
        return key.method_29177();
    }
}
