package cn.mmf.slashblade_addon.data;

import cn.mmf.slashblade_addon.SlashBladeAddon;
import mods.flammpfeil.slashblade.data.builtin.SlashBladeBuiltInRegistry;
import mods.flammpfeil.slashblade.init.SBItems;
import mods.flammpfeil.slashblade.item.SwordType;
import mods.flammpfeil.slashblade.recipe.RequestDefinition;
import mods.flammpfeil.slashblade.recipe.SlashBladeIngredient;
import mods.flammpfeil.slashblade.recipe.SlashBladeShapedRecipeBuilder;
import mods.flammpfeil.slashblade.registry.slashblade.EnchantmentDefinition;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricRecipeProvider;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalItemTags;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1856;
import net.minecraft.class_1893;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_8790;
import java.util.concurrent.CompletableFuture;

public class SlashBladeAddonRecipeProvider extends FabricRecipeProvider {
    public SlashBladeAddonRecipeProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
        super(output, registriesFuture);
    }

    public void method_10419(class_8790 consumer) {
        SlashBladeShapedRecipeBuilder
                .shaped(SlashBladeAddonBuiltInRegistry.HF_MURASAMA.method_29177()).pattern(" RI").pattern("RBG")
                .pattern("SL ").define('S', SBItems.proudsoul_trapezohedron).define('I', ConventionalItemTags.IRON_INGOTS)
                .define('G', class_1802.field_8054).define('R', ConventionalItemTags.STORAGE_BLOCKS_REDSTONE)
                .define('L', class_1802.field_8865)
                .define('B',
                        SlashBladeIngredient.of(RequestDefinition.Builder.newInstance()
                                .name(SlashBladeBuiltInRegistry.MURAMASA.method_29177()).build()).toVanilla())
                .method_33530(method_32807(SBItems.slashblade), method_10426(SBItems.slashblade))
                .method_17972(consumer, SlashBladeAddon.prefix("murasama_blade"));

        SlashBladeShapedRecipeBuilder
                .shaped(SlashBladeAddonBuiltInRegistry.WANDERER_HF.method_29177())
                .pattern("  I")
                .pattern("QI ")
                .pattern("BC ")
                .define('C', SBItems.proudsoul_trapezohedron)
                .define('I', ConventionalItemTags.REDSTONE_DUSTS)
                .define('Q', ConventionalItemTags.QUARTZ_GEMS)
                .define('B',
                        SlashBladeIngredient.of(RequestDefinition.Builder.newInstance()
                                .name(SlashBladeAddonBuiltInRegistry.WANDERER.method_29177()).build()).toVanilla())
                .method_33530(method_32807(SBItems.slashblade), method_10426(SBItems.slashblade))
                .method_17972(consumer, SlashBladeAddon.prefix("wanderer_hf"));

        SlashBladeShapedRecipeBuilder.shaped(SlashBladeAddonBuiltInRegistry.WANDERER.method_29177())
                .pattern("  I")
                .pattern("QI ")
                .pattern("BC ")
                .define('C', class_1802.field_8557)
                .define('I', SBItems.proudsoul_ingot)
                .define('Q', ConventionalItemTags.QUARTZ_GEMS)
                .define('B',
                        SlashBladeIngredient.of(RequestDefinition.Builder.newInstance()
                                .name(SlashBladeBuiltInRegistry.DOUTANUKI.method_29177()).build()).toVanilla())
                .method_33530(method_32807(SBItems.slashblade), method_10426(SBItems.slashblade)).method_10431(consumer);

        // TODO: TofuCraft Fabric移植
//        SmithingTransformRecipeBuilder
//                .smithing(Ingredient.of(TofuItems.TOFU_UPGRADE_SMITHING_TEMPLATE.get()),
//                        Ingredient.of(getItem(SBATofuCraftItems.TOFUMETAL_SLASHBLADE)),
//                        Ingredient.of(TofuBlocks.DIAMONDTOFU.get()), RecipeCategory.COMBAT,
//                        getItem(SBATofuCraftItems.TOFUDIAMOND_SLASHBLADE))
//                .unlocks("has_item", has(getItem(SBATofuCraftItems.TOFUMETAL_SLASHBLADE)))
//                .save(withConditions(consumer, DefaultResourceConditions.allModsLoaded("tofucraft")), SlashBladeAddon.prefix("tofu_diamond_blade"));
//        SlashBladeShapedRecipeBuilder.shaped(SBATofuCraftItems.TOFUMETAL_SLASHBLADE).pattern(" ST")
//                .pattern("ST ").pattern("WR ").define('S', TofuItems.TOFUISHI.get())
//                .define('R',SlashBladeRecipeProvider.STRING).define('W', Items.STICK)
//                .define('T', TofuItems.TOFUMETAL.get())
//                .unlockedBy(getHasName(SBItems.slashblade_wood), has(SBItems.slashblade_wood))
//                .save(withConditions(consumer, DefaultResourceConditions.allModsLoaded("tofucraft"), SBATofuCraftItems.TOFUMETAL_SLASHBLADE));
//        SlashBladeShapedRecipeBuilder.shaped(SBATofuCraftItems.TOFUISHI_SLASHBLADE).pattern(" SS")
//                .pattern("SS ").pattern("WR ").define('S', TofuItems.TOFUISHI.get())
//                .define('R', SlashBladeRecipeProvider.STRING).define('W', SlashBladeRecipeProvider.RODS_WOODEN)
//                .unlockedBy(getHasName(SBItems.slashblade_wood), has(SBItems.slashblade_wood))
//                .save(withConditions(consumer, DefaultResourceConditions.allModsLoaded("tofucraft"), SBATofuCraftItems.TOFUISHI_SLASHBLADE));

        // TODO: wait Botania 1.21
//        SlashBladeShapedRecipeBuilder
//                .shaped(SlashBladeAddonBuiltInRegistry.TERRA_BLADE.location()).pattern("ZCO").pattern(" BG")
//                .pattern("Q X").define('G', SBItems.proudsoul).define('X', SBItems.proudsoul_sphere)
//                .define('Q', BotaniaItems.terraSword).define('Z', BotaniaItems.vineBall)
//                .define('C', BotaniaItems.thornChakram).define('O', BotaniaItems.gaiaIngot)
//                .define('B', SBItems.slashblade).unlockedBy(getHasName(SBItems.slashblade), has(SBItems.slashblade))
//                .save(withConditions(consumer, ResourceConditions.allModsLoaded("botania")), SlashBladeAddonBuiltInRegistry.TERRA_BLADE.location());

        SlashBladeShapedRecipeBuilder.shaped(SlashBladeAddonBuiltInRegistry.KAMUY_NONE.method_29177()).pattern("SNS")
                .pattern("IBI").pattern("SDS").define('S', SBItems.proudsoul_sphere)
                .define('I', SBItems.proudsoul_ingot).define('N', ConventionalItemTags.QUARTZ_ORES).define('D', class_1802.field_8529)
                .define('B',
                        SlashBladeIngredient
                                .of(RequestDefinition.Builder.newInstance().killCount(100).refineCount(1).build()).toVanilla())
                .method_33530(method_32807(SBItems.slashblade), method_10426(SBItems.slashblade)).method_10431(consumer);

        SlashBladeShapedRecipeBuilder.shaped(SlashBladeAddonBuiltInRegistry.KAMUY_WATER.method_29177()).pattern("SNS")
                .pattern("ABQ").pattern("SDS").define('S', SBItems.proudsoul_sphere).define('A', class_1802.field_8081)
                .define('Q', class_1802.field_8246).define('N', ConventionalItemTags.STORAGE_BLOCKS_LAPIS)
                .define('D', class_1802.field_8705)
                .define('B',
                        SlashBladeIngredient.of(RequestDefinition.Builder.newInstance()
                                .name(SlashBladeAddonBuiltInRegistry.KAMUY_NONE.method_29177()).killCount(500)
                                .proudSoul(5000).refineCount(20).build()).toVanilla())
                .method_33530(method_32807(SBItems.slashblade), method_10426(SBItems.slashblade)).method_10431(consumer);

        SlashBladeShapedRecipeBuilder.shaped(SlashBladeAddonBuiltInRegistry.KAMUY_LIGHTING.method_29177()).pattern("SNS")
                .pattern("ABQ").pattern("SDS").define('S', SBItems.proudsoul_sphere)
                .define('A', ConventionalItemTags.STORAGE_BLOCKS_GOLD).define('Q', ConventionalItemTags.STORAGE_BLOCKS_DIAMOND)
                .define('N', ConventionalItemTags.STORAGE_BLOCKS_IRON).define('D', ConventionalItemTags.STORAGE_BLOCKS_EMERALD)
                .define('B',
                        SlashBladeIngredient.of(RequestDefinition.Builder.newInstance()
                                .name(SlashBladeAddonBuiltInRegistry.KAMUY_NONE.method_29177()).killCount(500)
                                .proudSoul(5000).refineCount(20).build()).toVanilla())
                .method_33530(method_32807(SBItems.slashblade), method_10426(SBItems.slashblade)).method_10431(consumer);

        SlashBladeShapedRecipeBuilder.shaped(SlashBladeAddonBuiltInRegistry.KAMUY_FIRE.method_29177()).pattern("SNS")
                .pattern("ABQ").pattern("SDS").define('S', SBItems.proudsoul_sphere).define('A', class_1802.field_8814)
                .define('Q', ConventionalItemTags.BLAZE_RODS).define('N', ConventionalItemTags.STORAGE_BLOCKS_REDSTONE)
                .define('D', class_1802.field_8187)
                .define('B',
                        SlashBladeIngredient.of(RequestDefinition.Builder.newInstance()
                                .name(SlashBladeAddonBuiltInRegistry.KAMUY_NONE.method_29177()).killCount(500)
                                .proudSoul(5000).refineCount(20).build()).toVanilla())
                .method_33530(method_32807(SBItems.slashblade), method_10426(SBItems.slashblade)).method_10431(consumer);

        // nihil
        SlashBladeShapedRecipeBuilder.shaped(SlashBladeAddonBuiltInRegistry.NIHIL.method_29177()).pattern("SIS")
                .pattern("IBI").pattern("SIS").define('S', SBItems.proudsoul_sphere)
                .define('I', SBItems.proudsoul_ingot).define('B', SlashBladeIngredient.of(RequestDefinition.Builder.newInstance().build()).toVanilla())
                .method_33530(method_32807(SBItems.slashblade), method_10426(SBItems.slashblade)).method_10431(consumer);

        SlashBladeShapedRecipeBuilder.shaped(SlashBladeAddonBuiltInRegistry.NIHILEX.method_29177()).pattern("SNS")
                .pattern("IBI").pattern("SDS").define('S', SBItems.proudsoul_sphere)
                .define('I', SBItems.proudsoul_ingot).define('N', class_1802.field_8137).define('D', class_1802.field_8603)
                .define('B',
                        SlashBladeIngredient.of(RequestDefinition.Builder.newInstance()
                                .name(SlashBladeAddonBuiltInRegistry.NIHIL.method_29177()).killCount(1000).proudSoul(100)
                                .refineCount(1).build()).toVanilla())
                .method_33530(method_32807(SBItems.slashblade), method_10426(SBItems.slashblade)).method_10431(consumer);

        SlashBladeShapedRecipeBuilder.shaped(SlashBladeAddonBuiltInRegistry.NIHILUL.method_29177()).pattern("SNS")
                .pattern("DBD").pattern("SYS").define('S', SlashBladeIngredient.of(RequestDefinition.Builder.newInstance().build()).toVanilla())
                .define('Y',
                        SlashBladeIngredient.of(RequestDefinition.Builder.newInstance()
                                .name(SlashBladeBuiltInRegistry.YAMATO.method_29177()).build()).toVanilla())
                .define('N', class_1802.field_8137).define('D', class_1802.field_8603)
                .define('B',
                        SlashBladeIngredient.of(RequestDefinition.Builder.newInstance()
                                .name(SlashBladeAddonBuiltInRegistry.NIHILEX.method_29177()).killCount(3000).proudSoul(6500)
                                .refineCount(3).build()).toVanilla())
                .method_33530(method_32807(SBItems.slashblade), method_10426(SBItems.slashblade)).method_10431(consumer);

        SlashBladeShapedRecipeBuilder.shaped(SlashBladeAddonBuiltInRegistry.CRIMSONCHERRY.method_29177()).pattern("DUD")
                .pattern("DED").pattern("DDD")
                .define('E',
                        SlashBladeIngredient.of(RequestDefinition.Builder.newInstance()
                                .name(SlashBladeAddonBuiltInRegistry.NIHIL.method_29177()).build()).toVanilla())
                .define('D', class_1802.field_8603)
                .define('U',
                        SlashBladeIngredient.of(RequestDefinition.Builder.newInstance()
                                .name(SlashBladeAddonBuiltInRegistry.NIHILEX.method_29177()).killCount(3000).proudSoul(6500)
                                .refineCount(3).build()).toVanilla())
                .method_33530(method_32807(SBItems.slashblade), method_10426(SBItems.slashblade)).method_10431(consumer);

        SlashBladeShapedRecipeBuilder.shaped(SlashBladeAddonBuiltInRegistry.NIHILBX.method_29177()).pattern("DDD")
                .pattern("CSU").pattern("DDD").define('S', SlashBladeIngredient.of(RequestDefinition.Builder.newInstance().build()).toVanilla()).define('D', class_1802.field_8603)
                .define('C',
                        SlashBladeIngredient.of(RequestDefinition.Builder.newInstance()
                                .name(SlashBladeAddonBuiltInRegistry.CRIMSONCHERRY.method_29177()).killCount(3000)
                                .proudSoul(6500).refineCount(3).build()).toVanilla())
                .define('U',
                        SlashBladeIngredient.of(RequestDefinition.Builder.newInstance()
                                .name(SlashBladeAddonBuiltInRegistry.NIHILUL.method_29177()).killCount(3000).proudSoul(6500)
                                .refineCount(3).build()).toVanilla())
                .method_33530(method_32807(SBItems.slashblade), method_10426(SBItems.slashblade)).method_10431(consumer);

        // WA
        SlashBladeShapedRecipeBuilder.shaped(SlashBladeAddonBuiltInRegistry.KATANA.method_29177()).pattern("  P")
                .pattern(" B ").pattern("S  ").define('P', SBItems.proudsoul_ingot).define('S', class_1802.field_8371)
                .define('B',
                        SlashBladeIngredient.of(SBItems.slashblade_silverbamboo,
                                RequestDefinition.Builder.newInstance().addSwordType(SwordType.BROKEN).build()).toVanilla())
                .method_33530(method_32807(SBItems.slashblade_silverbamboo), method_10426(SBItems.slashblade_silverbamboo))
                .method_10431(consumer);

        SlashBladeShapedRecipeBuilder.shaped(SlashBladeAddonBuiltInRegistry.TACHI.method_29177()).pattern("  P")
                .pattern(" B ").pattern("S  ").define('P', SBItems.proudsoul_sphere).define('S', class_1802.field_8371)
                .define('B',
                        SlashBladeIngredient.of(SBItems.slashblade_silverbamboo,
                                RequestDefinition.Builder.newInstance().addSwordType(SwordType.BROKEN).build()).toVanilla())
                .method_33530(method_32807(SBItems.slashblade_silverbamboo), method_10426(SBItems.slashblade_silverbamboo))
                .method_10431(consumer);

        SlashBladeShapedRecipeBuilder.shaped(SlashBladeAddonBuiltInRegistry.BLUE.method_29177()).pattern("BCI")
                .pattern("CI ").pattern("SL ").define('B', class_1802.field_8345).define('C', class_1802.field_8797)
                .define('I', SBItems.proudsoul_ingot).define('S', class_1802.field_8600).define('L', class_1802.field_8276)
                .method_33530(method_32807(SBItems.proudsoul_ingot), method_10426(SBItems.proudsoul_ingot)).method_10431(consumer);

        // BladeMaster
        SlashBladeShapedRecipeBuilder.shaped(SlashBladeAddonBuiltInRegistry.GREEN_MIST.method_29177()).pattern("PRE")
                .pattern("RE ").pattern("BGC").define('P', SBItems.proudsoul_sphere).define('R', class_1802.field_8793)
                .define('E', class_1802.field_8733).define('G', class_1802.field_8494).define('C', class_1802.field_42694)
                .define('B',
                        SlashBladeIngredient.of(RequestDefinition.Builder.newInstance()
                                .name(SlashBladeBuiltInRegistry.MURAMASA.method_29177()).killCount(1000).proudSoul(10000)
                                .refineCount(25)
                                .addEnchantment(new EnchantmentDefinition(class_1893.field_9103.method_29177(), 3))
                                .build()).toVanilla())
                .method_33530(method_32807(SBItems.slashblade), method_10426(SBItems.slashblade)).method_10431(consumer);

        SlashBladeShapedRecipeBuilder.shaped(SlashBladeAddonBuiltInRegistry.AQUABLAZE.method_29177()).pattern("PRW")
                .pattern("RL ").pattern("BGC").define('P', SBItems.proudsoul_sphere).define('R', class_1802.field_8793)
                .define('W', class_1802.field_8705).define('L', class_1802.field_8187).define('G', class_1802.field_8494)
                .define('C', class_1802.field_42694)
                .define('B',
                        SlashBladeIngredient.of(RequestDefinition.Builder.newInstance()
                                .name(SlashBladeBuiltInRegistry.MURAMASA.method_29177()).killCount(1000).proudSoul(10000)
                                .refineCount(25)
                                .addEnchantment(new EnchantmentDefinition(class_1893.field_9095.method_29177(), 1))
                                .build()).toVanilla())
                .method_33530(method_32807(SBItems.slashblade), method_10426(SBItems.slashblade)).method_10431(consumer);

        SlashBladeShapedRecipeBuilder.shaped(SlashBladeAddonBuiltInRegistry.MOONLIGHT_CHERRY.method_29177()).pattern("PRQ")
                .pattern("RL ").pattern("BGC").define('P', SBItems.proudsoul_sphere).define('R', class_1802.field_8793)
                .define('Q', class_1802.field_20402).define('L', class_1802.field_8801).define('G', class_1802.field_8494)
                .define('C', class_1802.field_42694)
                .define('B',
                        SlashBladeIngredient.of(RequestDefinition.Builder.newInstance()
                                .name(SlashBladeBuiltInRegistry.MURAMASA.method_29177()).killCount(1000).proudSoul(10000)
                                .refineCount(25)
                                .addEnchantment(new EnchantmentDefinition(class_1893.field_9097.method_29177(), 1))
                                .build()).toVanilla())
                .method_33530(method_32807(SBItems.slashblade), method_10426(SBItems.slashblade)).method_10431(consumer);

        // Dark Raven:Snow Crow
        SlashBladeShapedRecipeBuilder.shaped(SlashBladeAddonBuiltInRegistry.SNOW_CROW.method_29177()).pattern(" FQ")
                .pattern("SQ ").pattern("B  ").define('F', class_1802.field_8153).define('S', class_1802.field_8543)
                .define('Q', class_1802.field_20402)
                .define('B',
                        SlashBladeIngredient.of(RequestDefinition.Builder.newInstance()
                                .name(SlashBladeBuiltInRegistry.DOUTANUKI.method_29177()).build()).toVanilla())
                .method_33530(method_32807(SBItems.slashblade), method_10426(SBItems.slashblade)).method_10431(consumer);

        // Fluorescent Bar
        SlashBladeShapedRecipeBuilder.shaped(SlashBladeAddonBuiltInRegistry.FLUORESCENT_BAR.method_29177()).pattern(" PS")
                .pattern("PGP").pattern("SP ").define('P', class_1802.field_8407).define('G', class_1802.field_8280)
                .define('S', SBItems.proudsoul).method_33530(method_32807(SBItems.proudsoul), method_10426(SBItems.proudsoul))
                .method_10431(consumer);

        // Frost Wolf
        SlashBladeShapedRecipeBuilder.shaped(SlashBladeAddonBuiltInRegistry.FROSTY_CHERRY.method_29177()).pattern(" ID")
                .pattern("SP ").pattern("BQ ").define('I', class_1802.field_8426).define('D', class_1802.field_8345)
                .define('S', class_1802.field_8246).define('P', SBItems.proudsoul_sphere).define('Q', class_1802.field_8155)
                .define('B',
                        SlashBladeIngredient.of(RequestDefinition.Builder.newInstance()
                                .name(SlashBladeBuiltInRegistry.DOUTANUKI.method_29177()).refineCount(10)
                                .addEnchantment(new EnchantmentDefinition(class_1893.field_9095.method_29177(), 1))
                                .build()).toVanilla())
                .method_33530(method_32807(SBItems.slashblade), method_10426(SBItems.slashblade)).method_10431(consumer);

        SlashBladeShapedRecipeBuilder.shaped(SlashBladeAddonBuiltInRegistry.FROST_WOLF.method_29177()).pattern(" ID")
                .pattern("SP ").pattern("BQ ").define('I', class_1802.field_8426).define('D', class_1802.field_8345)
                .define('S', class_1802.field_8246).define('P', SBItems.proudsoul_sphere).define('Q', class_1802.field_8155)
                .define('B',
                        SlashBladeIngredient.of(RequestDefinition.Builder.newInstance()
                                .name(SlashBladeBuiltInRegistry.MURAMASA.method_29177()).refineCount(25)
                                .addEnchantment(new EnchantmentDefinition(class_1893.field_9095.method_29177(), 1))
                                .build()).toVanilla())
                .method_33530(method_32807(SBItems.slashblade), method_10426(SBItems.slashblade)).method_10431(consumer);

        SlashBladeShapedRecipeBuilder.shaped(SlashBladeAddonBuiltInRegistry.YUKARI.method_29177()).pattern("ISI")
                .pattern("SBS").pattern("ISI").define('I', SBItems.proudsoul_ingot)
                .define('S', SBItems.proudsoul_sphere)
                .define('B',
                        SlashBladeIngredient.of(RequestDefinition.Builder.newInstance()
                                .name(SlashBladeBuiltInRegistry.TUKUMO.method_29177()).killCount(1000)
                                .addEnchantment(new EnchantmentDefinition(class_1893.field_9124.method_29177(), 1))
                                .build()).toVanilla())
                .method_33530(method_32807(SBItems.slashblade), method_10426(SBItems.slashblade)).method_10431(consumer);

        SlashBladeShapedRecipeBuilder.shaped(SlashBladeAddonBuiltInRegistry.KIRISAYA.method_29177()).pattern("DID")
                .pattern("SBS").pattern("IDI").define('D', class_1802.field_8144).define('I', class_1802.field_8463)
                .define('S', SBItems.proudsoul_sphere)
                .define('B',
                        SlashBladeIngredient.of(SBItems.slashblade_silverbamboo, RequestDefinition.Builder.newInstance()
                                .proudSoul(10000).killCount(1000).refineCount(1).addSwordType(SwordType.BROKEN)
                                .addEnchantment(new EnchantmentDefinition(class_1893.field_9118.method_29177(), 3))
                                .build()).toVanilla())
                .method_33530(method_32807(SBItems.slashblade_silverbamboo), method_10426(SBItems.slashblade_silverbamboo))
                .method_10431(consumer);

        SlashBladeShapedRecipeBuilder.shaped(SlashBladeAddonBuiltInRegistry.LAEMMLE.method_29177()).pattern("XGO")
                .pattern("GBG").pattern("QGX").define('G', ConventionalItemTags.GOLD_INGOTS)
                .define('X', class_1856.method_8101(class_1844.method_57400(class_1802.field_8574, class_1847.field_8993)))
                .define('Q', class_1802.field_20402).define('O', ConventionalItemTags.OBSIDIANS)
                .define('B',
                        SlashBladeIngredient.of(RequestDefinition.Builder.newInstance()
                                .name(SlashBladeBuiltInRegistry.MURAMASA.method_29177()).build()).toVanilla())
                .method_33530(method_32807(SBItems.slashblade), method_10426(SBItems.slashblade)).method_10431(consumer);

        SlashBladeShapedRecipeBuilder.shaped(SlashBladeAddonBuiltInRegistry.TBOEN.method_29177()).pattern("SSS")
                .pattern("SBS").pattern("SSS").define('S', SBItems.proudsoul).define('B', SBItems.slashblade_white)
                .method_33530(method_32807(SBItems.slashblade_white), method_10426(SBItems.slashblade_white)).method_10431(consumer);

    }

    public class_1792 getItem(class_2960 item) {
        return class_7923.field_41178.method_10223(item);
    }

}
