package cn.sh1rocu.sfaddons.util;

import mods.flammpfeil.slashblade.capability.slashblade.CapabilitySlashBlade;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.item.base.SingleStackStorage;
import net.minecraft.class_1799;
import team.reborn.energy.api.EnergyStorage;

import java.util.Optional;

public class ItemEnergyStorageHelper {
    public static Optional<EnergyStorage> fromStack(class_1799 stack) {
        ContainerItemContext context = ContainerItemContext.ofSingleSlot(new SingleStackStorage() {
            private class_1799 itemStack = stack;

            @Override
            protected class_1799 getStack() {
                return itemStack;
            }

            @Override
            protected void setStack(final class_1799 stack) {
                itemStack = stack;
            }

            @Override
            protected void onFinalCommit() {
                stack.method_57379(CapabilitySlashBlade.BLADESTATE_COMPONENT, itemStack.method_57824(CapabilitySlashBlade.BLADESTATE_COMPONENT));
            }
        });

        return Optional.ofNullable(EnergyStorage.ITEM.find(stack, context));
    }
}