/*
 * Decompiled with CFR 0.152.
 */
package com.github.spacemex.client;

import com.github.spacemex.client.EntryRegistry;
import com.github.spacemex.config.ConfigReader;
import com.github.spacemex.yml.YamlConfigUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_368;
import net.minecraft.class_374;
import net.minecraft.class_5481;

@Environment(value=EnvType.CLIENT)
public class XpToast
implements class_368 {
    private static final class_2960 BG = new class_2960("toast/advancement");
    private final class_2960 categoryId;
    private int gained;
    private long lastUpdateTime;
    private final int bgW;
    private final int bgH;
    private final boolean bgEnabled;
    private final boolean bgTranslucent;
    private final float bgAlpha;
    private final boolean iconEnabled;
    private final float iconScale;
    private final int iconX;
    private final int iconY;
    private final class_1799 iconStack;
    private final boolean inline;
    private final long stackTimerMs;
    private final boolean titleShadow;
    private final int titleShadowARGB;
    private final boolean titleTranslucent;
    private final int titleARGB;
    private final float titleScale;
    private final boolean titleBold;
    private final String titlePattern;
    private final boolean expShadow;
    private final int expShadowARGB;
    private final boolean expTranslucent;
    private final int expARGB;
    private final float expScale;
    private final boolean expBold;
    private final String expPattern;
    private class_5481 preTitleLine;
    private class_5481 preExpLine;
    private class_5481 preCombinedLine;
    private int combinedBaselineY;

    private static YamlConfigUtil readConfigOnce() {
        return new ConfigReader().getConfig();
    }

    public XpToast(class_2960 categoryId, int gained) {
        this.categoryId = categoryId;
        this.gained = gained;
        this.lastUpdateTime = System.currentTimeMillis();
        YamlConfigUtil cfg = XpToast.readConfigOnce();
        this.bgH = cfg.getInt("Toast-Rendering.Height", 16);
        this.bgW = cfg.getInt("Toast-Rendering.Width", 160);
        this.bgEnabled = !cfg.getBoolean("Toast-Rendering.Disable-Background", true);
        this.bgTranslucent = cfg.getBoolean("Toast-Rendering.Background-Translucent", false);
        this.bgAlpha = cfg.getFloat("Toast-Rendering.Background-alpha", 127.0f) / 255.0f;
        this.iconEnabled = cfg.getBoolean("Icon-Settings.Enabled", true);
        this.iconScale = cfg.getFloat("Icon-Settings.Size", 12.0f) / 16.0f;
        this.iconX = cfg.getInt("Icon-Settings.X-Offset", 14);
        this.iconY = cfg.getInt("Icon-Settings.Y-Offset", 2);
        this.inline = cfg.getBoolean("Toast-Animation.Inline", true);
        this.stackTimerMs = cfg.getLong("Toast-Animation.Stack-XP-Timer", 5000L);
        this.titleBold = cfg.getBoolean("Title-Settings.Bold", false);
        this.titleScale = cfg.getFloat("Title-Settings.Size", 6.0f) / 9.0f;
        this.titleShadow = cfg.getBoolean("Title-Settings.Shadow", false);
        int titleShadowRGB = cfg.getInt("Title-Settings.Shadow-Color", 0) & 0xFFFFFF;
        int titleShadowA = cfg.getBoolean("Title-Settings.Translucent", false) ? cfg.getInt("Title-Settings.Alpha", 127) : 255;
        this.titleShadowARGB = titleShadowA << 24 | titleShadowRGB;
        this.titleTranslucent = cfg.getBoolean("Title-Settings.Translucent", false);
        int titleRGB = cfg.getInt("Title-Settings.Color", 0xFFAA00) & 0xFFFFFF;
        int titleA = this.titleTranslucent ? cfg.getInt("Title-Settings.Alpha", 127) : 255;
        this.titleARGB = titleA << 24 | titleRGB;
        this.titlePattern = cfg.getString("Title-Settings.Title", "%title%");
        this.expBold = cfg.getBoolean("Experience-Settings.Bold", false);
        this.expScale = cfg.getFloat("Experience-Settings.Size", 6.0f) / 9.0f;
        this.expShadow = cfg.getBoolean("Experience-Settings.Shadow", false);
        int expShadowRGB = cfg.getInt("Experience-Settings.Shadow-Color", 0) & 0xFFFFFF;
        int expShadowA = cfg.getBoolean("Experience-Settings.Translucent", false) ? cfg.getInt("Experience-Settings.Alpha", 0) : 255;
        this.expShadowARGB = expShadowA << 24 | expShadowRGB;
        this.expTranslucent = cfg.getBoolean("Experience-Settings.Translucent", false);
        int expRGB = cfg.getInt("Experience-Settings.Color", 0xFFAA00) & 0xFFFFFF;
        int expA = this.expTranslucent ? cfg.getInt("Experience-Settings.Alpha", 127) : 255;
        this.expARGB = expA << 24 | expRGB;
        this.expPattern = cfg.getString("Experience-Settings.Exp", " +%exp% xp");
        class_1799 stack = class_1799.field_8037;
        String path = this.categoryId.method_12832();
        if (this.iconEnabled) {
            stack = EntryRegistry.getIconFor(path);
        }
        this.iconStack = stack;
        this.rebuildTextLayouts();
    }

    private void rebuildTextLayouts() {
        class_310 mc = class_310.method_1551();
        String path = this.categoryId.method_12832();
        String titleRaw = XpToast.formatCategoryName(path);
        Object titleStr = this.titlePattern.replace("%title%", titleRaw);
        if (this.titleBold) {
            titleStr = "\u00a7l" + (String)titleStr;
        }
        Object expStr = this.expPattern.replace("%exp%", String.valueOf(this.gained));
        if (this.expBold) {
            expStr = "\u00a7l" + (String)expStr;
        }
        if (this.inline) {
            String combined = (String)titleStr + (String)expStr;
            this.preCombinedLine = class_2561.method_43470((String)combined).method_30937();
            this.combinedBaselineY = this.bgH / 2 - 3;
        } else {
            this.preTitleLine = class_2561.method_43470((String)titleStr).method_30937();
            this.preExpLine = class_2561.method_43470((String)expStr).method_30937();
        }
    }

    public void addGained(int delta) {
        this.gained += delta;
        this.lastUpdateTime = System.currentTimeMillis();
        this.rebuildTextLayouts();
    }

    int getGained() {
        return this.gained;
    }

    public class_368.class_369 method_1986(class_332 ctx, class_374 manager, long startTime) {
        class_310 mc = class_310.method_1551();
        if (this.bgEnabled) {
            if (this.bgTranslucent) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.bgAlpha);
            }
            ctx.method_25293(BG, 0, 0, this.bgW, this.bgH, 0.0f, 0.0f, 160, 32, 256, 256);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        if (this.iconEnabled && !this.iconStack.method_7960()) {
            ctx.method_51448().method_22903();
            ctx.method_51448().method_22905(this.iconScale, this.iconScale, 1.0f);
            int x0 = (int)((float)this.iconX / this.iconScale);
            int y0 = (int)((float)this.iconY / this.iconScale);
            ctx.method_51427(this.iconStack, x0, y0);
            ctx.method_51448().method_22909();
        }
        if (this.inline) {
            ctx.method_51448().method_22903();
            ctx.method_51448().method_22905(this.titleScale, this.titleScale, 1.0f);
            int x = (int)(30.0f / this.titleScale);
            int y = (int)((float)this.combinedBaselineY / this.titleScale);
            if (this.titleShadow) {
                ctx.method_51430(mc.field_1772, this.preCombinedLine, x + 1, y + 1, this.titleShadowARGB, false);
            }
            ctx.method_51430(mc.field_1772, this.preCombinedLine, x, y, this.titleARGB, false);
            ctx.method_51448().method_22909();
        } else {
            ctx.method_51448().method_22903();
            ctx.method_51448().method_22905(this.titleScale, this.titleScale, 1.0f);
            int tx = (int)(30.0f / this.titleScale);
            int ty = (int)(8.0f / this.titleScale);
            if (this.titleShadow) {
                ctx.method_51430(mc.field_1772, this.preTitleLine, tx + 1, ty + 1, this.titleShadowARGB, false);
            }
            ctx.method_51430(mc.field_1772, this.preTitleLine, tx, ty, this.titleARGB, false);
            ctx.method_51448().method_22909();
            ctx.method_51448().method_22903();
            ctx.method_51448().method_22905(this.expScale, this.expScale, 1.0f);
            int ex = (int)(30.0f / this.expScale);
            int ey = (int)(18.0f / this.expScale);
            if (this.expShadow) {
                ctx.method_51430(mc.field_1772, this.preExpLine, ex + 1, ey + 1, this.expShadowARGB, false);
            }
            ctx.method_51430(mc.field_1772, this.preExpLine, ex, ey, this.expARGB, false);
            ctx.method_51448().method_22909();
        }
        long now = System.currentTimeMillis();
        return now - this.lastUpdateTime < this.stackTimerMs ? class_368.class_369.field_2210 : class_368.class_369.field_2209;
    }

    public Object method_1987() {
        return this.categoryId;
    }

    public int method_29050() {
        return this.bgH;
    }

    public int method_29049() {
        return this.bgW;
    }

    public long getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public static String formatCategoryName(String rawPath) {
        String[] parts = rawPath.split("_");
        StringBuilder sb = new StringBuilder(rawPath.length() + parts.length);
        for (int i = 0; i < parts.length; ++i) {
            String w = parts[i];
            if (!w.isEmpty()) {
                sb.append(Character.toUpperCase(w.charAt(0))).append(w.substring(1));
            }
            if (i + 1 >= parts.length) continue;
            sb.append(' ');
        }
        return sb.toString();
    }
}

