/*
 * Decompiled with CFR 0.152.
 */
package com.github.spacemex.client;

import com.github.spacemex.Helper;
import com.github.spacemex.client.SearchForSkills;
import com.github.spacemex.config.ConfigReader;
import com.github.spacemex.yml.YamlConfigUtil;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class EntryRegistry {
    private static final List<Entry> ENTRIES = new ArrayList<Entry>();

    private static YamlConfigUtil config() {
        return new ConfigReader().getConfig();
    }

    public static void loadFromFile(Path configFile, Path gameDir) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        try {
            List<SearchForSkills.CategoryData> auto;
            Files.createDirectories(configFile.getParent(), new FileAttribute[0]);
            JsonArray jsonArray = new JsonArray();
            boolean shouldWriteFile = false;
            if (EntryRegistry.config().getBoolean("Client-Settings.Auto-Register-Data", true) && !(auto = SearchForSkills.scan(gameDir)).isEmpty()) {
                for (SearchForSkills.CategoryData cd : auto) {
                    JsonObject o = new JsonObject();
                    o.addProperty("regex", "^" + Pattern.quote(cd.idPath()) + "$");
                    o.addProperty("icon", cd.iconId());
                    jsonArray.add((JsonElement)o);
                }
                shouldWriteFile = true;
            }
            if (!Files.exists(configFile, new LinkOption[0]) || EntryRegistry.config().getBoolean("Client-Settings.Auto-Register-Data", true) && jsonArray.isEmpty()) {
                jsonArray.add((JsonElement)EntryRegistry.makeEntry(".*mining.*", "minecraft:iron_pickaxe", gson));
                jsonArray.add((JsonElement)EntryRegistry.makeEntry(".*farming.*", "minecraft:iron_hoe", gson));
                jsonArray.add((JsonElement)EntryRegistry.makeEntry(".*husbandry.*", "minecraft:wheat", gson));
                jsonArray.add((JsonElement)EntryRegistry.makeEntry(".*fishing.*", "minecraft:fishing_rod", gson));
                jsonArray.add((JsonElement)EntryRegistry.makeEntry(".*adventuring.*", "minecraft:iron_sword", gson));
                shouldWriteFile = true;
            }
            if (shouldWriteFile) {
                Files.writeString(configFile, (CharSequence)gson.toJson((JsonElement)jsonArray), new OpenOption[0]);
            }
            try (BufferedReader reader = Files.newBufferedReader(configFile);){
                JsonElement root = JsonParser.parseReader((Reader)reader);
                if (!root.isJsonArray()) {
                    Helper.getPlatformsLogger().warn("IconMappings.json isn't an array, skipping.");
                    return;
                }
                ENTRIES.clear();
                for (JsonElement el : root.getAsJsonArray()) {
                    JsonObject obj = el.getAsJsonObject();
                    String regex = obj.get("regex").getAsString();
                    String iconId = obj.get("icon").getAsString();
                    Pattern p = Pattern.compile(regex, 2);
                    Item item = (Item)BuiltInRegistries.ITEM.getValue(ResourceLocation.tryParse((String)iconId));
                    ItemStack stack = item == null ? ItemStack.EMPTY : new ItemStack((ItemLike)item);
                    ENTRIES.add(new Entry(p, stack));
                }
            }
        }
        catch (IOException e) {
            Helper.getPlatformsLogger().error("Failed loading IconMappings.json", (Throwable)e);
        }
    }

    private static JsonObject makeEntry(String regex, String icon, Gson g) {
        JsonObject o = new JsonObject();
        o.addProperty("regex", regex);
        o.addProperty("icon", icon);
        return o;
    }

    public static ItemStack getIconFor(String categoryPath) {
        for (Entry e : ENTRIES) {
            if (!e.pattern.matcher(categoryPath).matches()) continue;
            return e.icon.copy();
        }
        return ItemStack.EMPTY;
    }

    private record Entry(Pattern pattern, ItemStack icon) {
    }
}

