/*
 * Decompiled with CFR 0.152.
 */
package com.github.spacemex.client;

import com.github.spacemex.Helper;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.architectury.platform.Platform;
import java.io.BufferedReader;
import java.io.File;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SearchForSkills {
    public static List<CategoryData> scan(Path gameDir) {
        ArrayList<File> found = new ArrayList<File>();
        Path datapacks = gameDir.resolve("datapacks");
        SearchForSkills.scanDir(datapacks, found);
        if (Platform.isModLoaded((String)"kubejs")) {
            Path jsData = gameDir.resolve("kubejs/data");
            SearchForSkills.scanDir(jsData, found);
        }
        ArrayList<CategoryData> results = new ArrayList<CategoryData>();
        for (File file : found) {
            try {
                BufferedReader reader = Files.newBufferedReader(file.toPath());
                try {
                    JsonObject obj = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                    String idPath = file.getParentFile().getName();
                    String itemId = obj.getAsJsonObject("icon").getAsJsonObject("data").get("item").getAsString();
                    results.add(new CategoryData(idPath, itemId));
                }
                finally {
                    if (reader == null) continue;
                    ((Reader)reader).close();
                }
            }
            catch (Exception e) {
                Helper.getPlatformsLogger().error("Failed to read category file {}", (Object)file.toPath(), (Object)e);
            }
        }
        return results;
    }

    private static void scanDir(Path dir, List<File> out) {
        File d = dir.toFile();
        if (!d.exists() || !d.isDirectory()) {
            return;
        }
        for (File f : Objects.requireNonNull(d.listFiles())) {
            if (f.isDirectory()) {
                SearchForSkills.scanDir(f.toPath(), out);
                continue;
            }
            if (!"category.json".equals(f.getName())) continue;
            out.add(f);
        }
    }

    public record CategoryData(String idPath, String iconId) {
    }
}

