/*
 * Decompiled with CFR 0.152.
 */
package com.github.spacemex.yml;

import com.github.spacemex.shadow.snakeyaml.Yaml;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class YamlConfigTemplateWriter {
    private final File file;
    private final Map<String, String> comments = new HashMap<String, String>();
    private final Map<String, Object> root = new LinkedHashMap<String, Object>();
    private final List<String> headerComments = new ArrayList<String>();

    public YamlConfigTemplateWriter(File file) {
        this.file = file;
    }

    public YamlConfigTemplateWriter header(String comment) {
        if (comment != null) {
            Collections.addAll(this.headerComments, comment.split("\n"));
        }
        return this;
    }

    public YamlConfigTemplateWriter add(String path, Object value, String comment) {
        this.insertNested(this.root, path.split("\\."), value);
        this.comments.put(path, comment);
        return this;
    }

    private void insertNested(Map<String, Object> current, String[] path, Object value) {
        for (int i = 0; i < path.length; ++i) {
            String key = path[i];
            if (i == path.length - 1) {
                current.put((String)key, (Object)value);
                continue;
            }
            LinkedHashMap nested = current.get(key);
            if (!(nested instanceof Map)) {
                nested = new LinkedHashMap();
                current.put(key, nested);
            }
            current = nested;
        }
    }

    public void write() {
        Map<String, Object> existingData = new LinkedHashMap<String, Object>();
        if (this.file.exists()) {
            try (FileReader reader = new FileReader(this.file);){
                Object loaded = new Yaml().load(reader);
                if (loaded instanceof Map) {
                    Map map = (Map)loaded;
                    existingData = map;
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to read existing config", e);
            }
        }
        this.mergeMissing(existingData, this.root);
        try (FileWriter writer = new FileWriter(this.file);){
            for (String line : this.headerComments) {
                writer.write("# " + line + System.lineSeparator());
            }
            if (!this.headerComments.isEmpty()) {
                writer.write(System.lineSeparator());
            }
            this.writeMap(writer, existingData, "", new LinkedList<String>());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write merged config", e);
        }
    }

    private void mergeMissing(Map<String, Object> target, Map<String, Object> source) {
        for (Map.Entry<String, Object> entry : source.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (!target.containsKey(key)) {
                target.put(key, value);
                continue;
            }
            if (!(value instanceof Map)) continue;
            Map sourceMap = (Map)value;
            Object object = target.get(key);
            if (!(object instanceof Map)) continue;
            Map targetMap = (Map)object;
            this.mergeMissing(targetMap, sourceMap);
        }
    }

    private void writeMap(FileWriter writer, Map<String, Object> map, String indent, LinkedList<String> pathParts) throws IOException {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            pathParts.addLast(key);
            String fullPath = String.join((CharSequence)".", pathParts);
            String comment = this.comments.get(fullPath);
            if (comment != null && !comment.isBlank()) {
                writer.write(indent + "# " + comment + System.lineSeparator());
            }
            if (value instanceof Map) {
                Map nested = (Map)value;
                writer.write(indent + key + ":" + System.lineSeparator());
                this.writeMap(writer, nested, indent + "  ", pathParts);
            } else {
                writer.write(indent + key + ": " + this.format(value) + System.lineSeparator());
            }
            pathParts.removeLast();
        }
    }

    private String format(Object value) {
        if (value instanceof String) {
            String s = (String)value;
            return "\"" + s.replace("\"", "\\\"") + "\"";
        }
        if (value instanceof List) {
            List list = (List)value;
            return list.toString();
        }
        if (value != null && value.getClass().isArray()) {
            return Arrays.toString(this.convertArray(value));
        }
        return String.valueOf(value);
    }

    private Object[] convertArray(Object array) {
        int length = Array.getLength(array);
        Object[] result = new Object[length];
        for (int i = 0; i < length; ++i) {
            result[i] = Array.get(array, i);
        }
        return result;
    }
}

