/*
 * Decompiled with CFR 0.152.
 */
package com.github.spacemex.config;

import com.github.spacemex.Helper;
import com.github.spacemex.skillexpnotifier.libs.snakeyaml.Yaml;
import com.github.spacemex.yml.YamlConfigUtil;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.platform.Platform;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;

public class ConfigWatcher {
    private static long lastModified = -1L;
    private static YamlConfigUtil config;

    public static void init() {
        ConfigWatcher.reloadConfig();
        ClientTickEvent.CLIENT_POST.register(client -> ConfigWatcher.tick());
    }

    private static void tick() {
        if (!ConfigWatcher.getBoolean("Client-Settings.File-Watcher", true)) {
            return;
        }
        try {
            Path configFile = Platform.getConfigFolder().resolve("SkillExpNotifier/config.yml");
            long currentModified = Files.getLastModifiedTime(configFile, new LinkOption[0]).toMillis();
            if (currentModified > lastModified) {
                lastModified = currentModified;
                ConfigWatcher.reloadConfig();
                Helper.getPlatformsLogger().info("[File Watcher] Config Reloaded");
            }
        }
        catch (IOException e) {
            Helper.getPlatformsLogger().error("[File Watcher] Failed to read file modified time", (Throwable)e);
        }
    }

    private static void reloadConfig() {
        Path configFile = Platform.getConfigFolder().resolve("SkillExpNotifier/config.yml");
        try (FileInputStream fis = new FileInputStream(configFile.toFile());){
            Yaml yaml = new Yaml();
            Map data = (Map)yaml.load(fis);
            config = new YamlConfigUtil(data);
            lastModified = Files.getLastModifiedTime(configFile, new LinkOption[0]).toMillis();
        }
        catch (IOException e) {
            Helper.getPlatformsLogger().error("[File Watcher] Failed to load config", (Throwable)e);
        }
    }

    private static boolean getBoolean(String key, boolean defaultValue) {
        return config != null ? config.getBoolean(key, defaultValue) : defaultValue;
    }
}

