/*
 * Decompiled with CFR 0.152.
 */
package com.github.spacemex.forge;

import com.github.spacemex.SkillExpNotifier;
import com.github.spacemex.forge.networking.client.ClientNotifier;
import com.github.spacemex.forge.networking.client.ToastPacketHandler;
import com.github.spacemex.networking.XpGainPacket;
import dev.architectury.platform.forge.EventBuses;
import java.io.Serializable;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="skillexpnotifier")
public final class SkillExpNotifierForge {
    public static Logger LOGGER = LoggerFactory.getLogger((String)"skillexpnotifier");
    public static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("skillexpnotifier", "network"), () -> "1", "1"::equals, "1"::equals);

    public SkillExpNotifierForge() {
        FMLJavaModLoadingContext ctx = FMLJavaModLoadingContext.get();
        IEventBus eventBus = ctx.getModEventBus();
        EventBuses.registerModEventBus((String)"skillexpnotifier", (IEventBus)eventBus);
        SkillExpNotifier.init();
        eventBus.addListener(this::onCommonSetup);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> eventBus.addListener(this::clientInit));
    }

    private void onCommonSetup(FMLCommonSetupEvent event) {
        CHANNEL.registerMessage(0, XpGainPacket.class, XpGainPacket::encode, XpGainPacket::decode, (msg, ctxSupplier) -> {
            NetworkEvent.Context ctx = (NetworkEvent.Context)ctxSupplier.get();
            ctx.setPacketHandled(true);
            ctx.enqueueWork(() -> DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> (DistExecutor.SafeRunnable & Serializable)() -> ToastPacketHandler.onXpGain(msg)));
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    private void clientInit(FMLClientSetupEvent event) {
        SkillExpNotifier.initClient();
        ClientNotifier.register();
    }
}

