/*
 * Decompiled with CFR 0.152.
 */
package com.github.spacemex.client;

import com.github.spacemex.client.EntryRegistry;
import com.github.spacemex.config.ConfigReader;
import com.github.spacemex.yml.YamlConfigUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastManager;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class XpToast
implements Toast {
    private static final ResourceLocation BG = ResourceLocation.tryParse((String)"minecraft:textures/gui/sprites/toast/advancement.png");
    private final ResourceLocation categoryId;
    private int gained;
    private long lastUpdateTime;

    private YamlConfigUtil config() {
        return new ConfigReader().getConfig();
    }

    int getGained() {
        return this.gained;
    }

    public XpToast(ResourceLocation categoryId, int gained) {
        this.categoryId = categoryId;
        this.gained = gained;
        this.lastUpdateTime = System.currentTimeMillis();
    }

    public void addGained(int delta) {
        this.gained += delta;
        this.lastUpdateTime = System.currentTimeMillis();
    }

    public Toast.Visibility getWantedVisibility() {
        long now = System.currentTimeMillis();
        return now - this.lastUpdateTime < this.config().getLong("Toast-Animation.Stack-XP-Timer", 5000L) ? Toast.Visibility.SHOW : Toast.Visibility.HIDE;
    }

    public void update(ToastManager manager, long time) {
    }

    public void render(GuiGraphics ctx, Font textRenderer, long startTime) {
        ItemStack iconStack;
        Minecraft mc = Minecraft.getInstance();
        long now = System.currentTimeMillis();
        int bgH = this.height();
        int bgW = this.width();
        if (!this.config().getBoolean("Toast-Rendering.Disable-Background", true)) {
            if (this.config().getBoolean("Toast-Rendering.Background-Translucent", false)) {
                float a = this.config().getFloat("Toast-Rendering.Background-alpha", 127.0f) / 255.0f;
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)a);
            }
            ctx.blitSprite(RenderType::guiTextured, BG, 0, 0, bgW, bgH);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        String path = this.categoryId.getPath();
        String title = XpToast.formatCategoryName(path);
        if (this.config().getBoolean("Icon-Settings.Enabled", true) && !(iconStack = EntryRegistry.getIconFor(path)).isEmpty()) {
            float iconScale = this.config().getFloat("Icon-Settings.Size", 12.0f) / 16.0f;
            ctx.pose().pushPose();
            ctx.pose().scale(iconScale, iconScale, 1.0f);
            int x0 = (int)((float)this.config().getInt("Icon-Settings.X-Offset", 14) / iconScale);
            int y0 = (int)((float)this.config().getInt("Icon-Settings.Y-Offset", 2) / iconScale);
            ctx.renderItem(iconStack, x0, y0);
            ctx.pose().popPose();
        }
        BiConsumer<String, Integer> drawTitle = (text, y) -> {
            ctx.pose().pushPose();
            float scale = this.config().getFloat("Title-Settings.Size", 6.0f) / 9.0f;
            ctx.pose().scale(scale, scale, 1.0f);
            int x = (int)(30.0f / scale);
            int yy = (int)((float)y.intValue() / scale);
            if (this.config().getBoolean("Title-Settings.Shadow", false)) {
                int sdRgb = this.config().getInt("Title-Settings.Shadow-Color", 0) & 0xFFFFFF;
                int sdAlpha = this.config().getBoolean("Title-Settings.Translucent", false) ? this.config().getInt("Title-Settings.Alpha", 127) : 255;
                int sdArgb = sdAlpha << 24 | sdRgb;
                ctx.drawString(textRenderer, text, x + 1, yy + 1, sdArgb, false);
            }
            int rgb = this.config().getInt("Title-Settings.Color", 0xFFAA00) & 0xFFFFFF;
            int alpha = this.config().getBoolean("Title-Settings.Translucent", false) ? this.config().getInt("Title-Settings.Alpha", 127) : 255;
            int argb = alpha << 24 | rgb;
            ctx.drawString(textRenderer, text, x, yy, argb, false);
            ctx.pose().popPose();
        };
        BiConsumer<String, Integer> drawExp = (text, y) -> {
            ctx.pose().pushPose();
            float scale = this.config().getFloat("Experience-Settings.Size", 6.0f) / 9.0f;
            ctx.pose().scale(scale, scale, 1.0f);
            int x = (int)(30.0f / scale);
            int yy = (int)((float)y.intValue() / scale);
            if (this.config().getBoolean("Experience-Settings.Shadow", false)) {
                int sdRgb = this.config().getInt("Experience-Settings.Shadow-Color", 0) & 0xFFFFFF;
                int sdAlpha = this.config().getBoolean("Experience-Settings.Translucent", false) ? this.config().getInt("Experience-Settings.Alpha", 0) : 255;
                int sdArgb = sdAlpha << 24 | sdRgb;
                ctx.drawString(textRenderer, text, x + 1, yy + 1, sdArgb, false);
            }
            int rgb = this.config().getInt("Experience-Settings.Color", 0xFFAA00) & 0xFFFFFF;
            int alpha = this.config().getBoolean("Experience-Settings.Translucent", false) ? this.config().getInt("Experience-Settings.Alpha", 127) : 255;
            int argb = alpha << 24 | rgb;
            ctx.drawString(textRenderer, text, x, yy, argb, false);
            ctx.pose().popPose();
        };
        if (this.config().getBoolean("Toast-Animation.Inline", true)) {
            String tOv = this.config().getString("Title-Settings.Title", "%title%").replace("%title%", title);
            String xOv = this.config().getString("Experience-Settings.Exp", " +%exp% xp").replace("%exp%", String.valueOf(this.gained));
            String combined = tOv + xOv;
            if (this.config().getBoolean("Title-Settings.Bold", false) || this.config().getBoolean("Experience-Settings.Bold", false)) {
                combined = "\u00a7l" + combined;
            }
            int midY = bgH / 2 - this.config().getInt("Title-Settings.Size", 6) / 2;
            drawTitle.accept(combined, midY);
        } else {
            String tt = (this.config().getBoolean("Title-Settings.Bold", false) ? "\u00a7l" : "") + title;
            drawTitle.accept(tt, 8);
            String xp = (this.config().getBoolean("Experience-Settings.Bold", false) ? "\u00a7l" : "") + this.config().getString("Experience-Settings.Exp", " +%exp% xp").replace("%exp%", String.valueOf(this.gained));
            drawExp.accept(xp, 18);
        }
    }

    public Object getToken() {
        return this.categoryId;
    }

    public static String formatCategoryName(String rawPath) {
        return Arrays.stream(rawPath.split("_")).map(w -> w.isEmpty() ? w : Character.toUpperCase(w.charAt(0)) + w.substring(1)).collect(Collectors.joining(" "));
    }

    public long getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public int height() {
        return this.config().getInt("Toast-Rendering.Height", 16);
    }

    public int width() {
        return this.config().getInt("Toast-Rendering.Width", 160);
    }
}

