/*
 * Decompiled with CFR 0.152.
 */
package com.github.spacemex.fabric.networking;

import com.github.spacemex.fabric.SkillExpNotifierFabric;
import com.github.spacemex.networking.XpGainPacket;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import net.puffish.skillsmod.api.SkillsAPI;

public class ServerNotifier {
    private static final Map<UUID, Map<class_2960, Integer>> lastTotals = new HashMap<UUID, Map<class_2960, Integer>>();

    public static void register() {
        ServerTickEvents.END_SERVER_TICK.register(ServerNotifier::tick);
    }

    private static void tick(MinecraftServer server) {
        for (class_3222 player : server.method_3760().method_14571()) {
            UUID uuid = player.method_5667();
            Map playerMap = lastTotals.computeIfAbsent(uuid, __ -> new HashMap());
            SkillsAPI.streamCategories().forEach(cat -> cat.getExperience().ifPresent(exp -> {
                int prev;
                class_2960 id = cat.getId();
                int total = exp.getTotal(player);
                if (total > (prev = playerMap.getOrDefault(id, total).intValue())) {
                    int delta = total - prev;
                    SkillExpNotifierFabric.sendXpGainPacket(player, new XpGainPacket(id, delta));
                }
                playerMap.put(id, total);
            }));
        }
    }
}

