/*
 * Decompiled with CFR 0.152.
 */
package com.github.spacemex.client;

import com.github.spacemex.client.EntryRegistry;
import com.github.spacemex.config.ConfigReader;
import com.github.spacemex.yml.YamlConfigUtil;
import java.util.Arrays;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_368;
import net.minecraft.class_374;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fStack;
import org.joml.Matrix3x2fc;

@Environment(value=EnvType.CLIENT)
public class XpToast
implements class_368 {
    private static final class_2960 BG = class_2960.method_60656((String)"toast/advancement");
    private final class_2960 categoryId;
    private int gained;
    private long lastUpdateTime;

    private YamlConfigUtil config() {
        return new ConfigReader().getConfig();
    }

    int getGained() {
        return this.gained;
    }

    public XpToast(class_2960 categoryId, int gained) {
        this.categoryId = categoryId;
        this.gained = gained;
        this.lastUpdateTime = System.currentTimeMillis();
    }

    public void addGained(int delta) {
        this.gained += delta;
        this.lastUpdateTime = System.currentTimeMillis();
    }

    public class_368.class_369 method_61988() {
        long now = System.currentTimeMillis();
        return now - this.lastUpdateTime < this.config().getLong("Toast-Animation.Stack-XP-Timer", 5000L) ? class_368.class_369.field_2210 : class_368.class_369.field_2209;
    }

    public void method_61989(class_374 manager, long time) {
    }

    public void method_1986(class_332 ctx, class_327 textRenderer, long startTime) {
        class_1799 iconStack;
        class_310 mc = class_310.method_1551();
        long now = System.currentTimeMillis();
        int bgH = this.method_29050();
        int bgW = this.method_29049();
        if (!this.config().getBoolean("Toast-Rendering.Disable-Background", true)) {
            if (this.config().getBoolean("Toast-Rendering.Background-Translucent", false)) {
                float a = this.config().getFloat("Toast-Rendering.Background-alpha", 127.0f) / 255.0f;
                int argb = (int)a << 24 | 0xFFFFFF;
                ctx.method_25291(class_10799.field_56883, BG, 0, 0, 0.0f, 0.0f, bgW, bgH, 256, 256, argb);
            }
            ctx.method_52706(class_10799.field_56883, BG, 0, 0, bgW, bgH);
        }
        Matrix3x2fStack matrices = ctx.method_51448();
        Matrix3x2f backup = new Matrix3x2f((Matrix3x2fc)matrices);
        String path = this.categoryId.method_12832();
        String title = XpToast.formatCategoryName(path);
        if (this.config().getBoolean("Icon-Settings.Enabled", true) && !(iconStack = EntryRegistry.getIconFor(path)).method_7960()) {
            float iconScale = this.config().getFloat("Icon-Settings.Size", 12.0f) / 16.0f;
            matrices.scale(iconScale, iconScale);
            int x0 = (int)((float)this.config().getInt("Icon-Settings.X-Offset", 14) / iconScale);
            int y0 = (int)((float)this.config().getInt("Icon-Settings.Y-Offset", 2) / iconScale);
            ctx.method_51427(iconStack, x0, y0);
            matrices.set((Matrix3x2fc)backup);
        }
        BiConsumer<String, Integer> drawTitle = (text, y) -> {
            float scale = this.config().getFloat("Title-Settings.Size", 6.0f) / 9.0f;
            matrices.scale(scale, scale);
            int x = (int)(30.0f / scale);
            int yy = (int)((float)y.intValue() / scale);
            if (this.config().getBoolean("Title-Settings.Shadow", false)) {
                int sdRgb = this.config().getInt("Title-Settings.Shadow-Color", 0) & 0xFFFFFF;
                int sdAlpha = this.config().getBoolean("Title-Settings.Translucent", false) ? this.config().getInt("Title-Settings.Alpha", 127) : 255;
                int sdArgb = sdAlpha << 24 | sdRgb;
                ctx.method_51433(textRenderer, text, x + 1, yy + 1, sdArgb, false);
            }
            int rgb = this.config().getInt("Title-Settings.Color", 0xFFAA00) & 0xFFFFFF;
            int alpha = this.config().getBoolean("Title-Settings.Translucent", false) ? this.config().getInt("Title-Settings.Alpha", 127) : 255;
            int argb = alpha << 24 | rgb;
            ctx.method_51433(textRenderer, text, x, yy, argb, false);
            matrices.set((Matrix3x2fc)backup);
        };
        BiConsumer<String, Integer> drawExp = (text, y) -> {
            float scale = this.config().getFloat("Experience-Settings.Size", 6.0f) / 9.0f;
            matrices.scale(scale, scale);
            int x = (int)(30.0f / scale);
            int yy = (int)((float)y.intValue() / scale);
            if (this.config().getBoolean("Experience-Settings.Shadow", false)) {
                int sdRgb = this.config().getInt("Experience-Settings.Shadow-Color", 0) & 0xFFFFFF;
                int sdAlpha = this.config().getBoolean("Experience-Settings.Translucent", false) ? this.config().getInt("Experience-Settings.Alpha", 0) : 255;
                int sdArgb = sdAlpha << 24 | sdRgb;
                ctx.method_51433(textRenderer, text, x + 1, yy + 1, sdArgb, false);
            }
            int rgb = this.config().getInt("Experience-Settings.Color", 0xFFAA00) & 0xFFFFFF;
            int alpha = this.config().getBoolean("Experience-Settings.Translucent", false) ? this.config().getInt("Experience-Settings.Alpha", 127) : 255;
            int argb = alpha << 24 | rgb;
            ctx.method_51433(textRenderer, text, x, yy, argb, false);
            matrices.set((Matrix3x2fc)backup);
        };
        if (this.config().getBoolean("Toast-Animation.Inline", true)) {
            String tOv = this.config().getString("Title-Settings.Title", "%title%").replace("%title%", title);
            String xOv = this.config().getString("Experience-Settings.Exp", " +%exp% xp").replace("%exp%", String.valueOf(this.gained));
            String combined = tOv + xOv;
            if (this.config().getBoolean("Title-Settings.Bold", false) || this.config().getBoolean("Experience-Settings.Bold", false)) {
                combined = "\u00a7l" + combined;
            }
            int midY = bgH / 2 - this.config().getInt("Title-Settings.Size", 6) / 2;
            drawTitle.accept(combined, midY);
        } else {
            String tt = (this.config().getBoolean("Title-Settings.Bold", false) ? "\u00a7l" : "") + title;
            drawTitle.accept(tt, 8);
            String xp = (this.config().getBoolean("Experience-Settings.Bold", false) ? "\u00a7l" : "") + this.config().getString("Experience-Settings.Exp", " +%exp% xp").replace("%exp%", String.valueOf(this.gained));
            drawExp.accept(xp, 18);
        }
    }

    public Object method_1987() {
        return this.categoryId;
    }

    public static String formatCategoryName(String rawPath) {
        return Arrays.stream(rawPath.split("_")).map(w -> w.isEmpty() ? w : Character.toUpperCase(w.charAt(0)) + w.substring(1)).collect(Collectors.joining(" "));
    }

    public long getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public int method_29050() {
        return this.config().getInt("Toast-Rendering.Height", 16);
    }

    public int method_29049() {
        return this.config().getInt("Toast-Rendering.Width", 160);
    }
}

