/*
 * Decompiled with CFR 0.152.
 */
package com.github.spacemex.forge.networking;

import com.github.spacemex.forge.SkillExpNotifierForge;
import com.github.spacemex.networking.XpGainPacket;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.server.ServerLifecycleHooks;
import net.puffish.skillsmod.api.SkillsAPI;

@Mod.EventBusSubscriber(modid="skillexpnotifier", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ServerNotifier {
    private static final Map<UUID, Map<ResourceLocation, Integer>> lastTotals = new HashMap<UUID, Map<ResourceLocation, Integer>>();

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        for (ServerPlayer player : server.m_6846_().m_11314_()) {
            UUID uuid = player.m_20148_();
            Map playerMap = lastTotals.computeIfAbsent(uuid, __ -> new HashMap());
            SkillsAPI.streamCategories().forEach(cat -> cat.getExperience().ifPresent(exp -> {
                int prev;
                ResourceLocation id = cat.getId();
                int total = exp.getTotal(player);
                if (total > (prev = playerMap.getOrDefault(id, total).intValue())) {
                    int delta = total - prev;
                    SkillExpNotifierForge.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new XpGainPacket(id, delta));
                }
                playerMap.put(id, total);
            }));
        }
    }
}

