/*
 * Decompiled with CFR 0.152.
 */
package com.github.spacemex.forge.networking;

import com.github.spacemex.forge.networking.XpGainPayload;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.event.TickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import net.puffish.skillsmod.api.SkillsAPI;

@Mod.EventBusSubscriber(modid="skillexpnotifier", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ServerNotifier {
    private static final Map<UUID, Map<ResourceLocation, Integer>> lastTotals = new HashMap<UUID, Map<ResourceLocation, Integer>>();

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        for (ServerPlayer player : server.getPlayerList().getPlayers()) {
            UUID uuid = player.getUUID();
            Map playerMap = lastTotals.computeIfAbsent(uuid, __ -> new HashMap());
            SkillsAPI.streamCategories().forEach(cat -> cat.getExperience().ifPresent(exp -> {
                int prev;
                ResourceLocation id = cat.getId();
                int total = exp.getTotal(player);
                if (total > (prev = playerMap.getOrDefault(id, total).intValue())) {
                    int delta = total - prev;
                    XpGainPayload payload = new XpGainPayload(id, delta);
                    PacketDistributor.PLAYER.with((Object)player).send(new CustomPacketPayload[]{payload});
                }
                playerMap.put(id, total);
            }));
        }
    }
}

