/*
 * Decompiled with CFR 0.152.
 */
package com.github.spacemex.client;

import com.github.spacemex.Helper;
import com.github.spacemex.client.XpToast;
import com.github.spacemex.config.ConfigReader;
import com.github.spacemex.yml.YamlConfigUtil;
import com.google.common.collect.Queues;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_368;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_7923;

@Environment(value=EnvType.CLIENT)
public class CustomToastComponent {
    private final class_310 minecraft;
    private final List<CustomToastInstance<?>> visable = new ArrayList();
    private final BitSet occupiedSlots = new BitSet();
    private final Deque<class_368> queued = Queues.newArrayDeque();

    private YamlConfigUtil config() {
        return new ConfigReader().getConfig();
    }

    public CustomToastComponent(class_310 minecraft) {
        this.minecraft = minecraft;
    }

    public void addToast(class_368 toast) {
        if (this.config().getBoolean("Client-Settings.Disable", false)) {
            return;
        }
        XpToast existingVisible = this.getToast(XpToast.class, toast.method_1987());
        if (existingVisible != null && toast instanceof XpToast) {
            XpToast incoming = (XpToast)toast;
            existingVisible.addGained(incoming.getGained());
            Helper.getPlatformsLogger().debug("Merged visible toast {} and {}", (Object)existingVisible, (Object)toast);
            return;
        }
        for (class_368 queuedToast : this.queued) {
            if (!(queuedToast instanceof XpToast)) continue;
            XpToast queuedXp = (XpToast)queuedToast;
            if (queuedToast.getClass() != toast.getClass() || !Objects.equals(queuedToast.method_1987(), toast.method_1987())) continue;
            queuedXp.addGained(((XpToast)toast).getGained());
            Helper.getPlatformsLogger().debug("Merged queued toast {} and {}", (Object)queuedXp, (Object)toast);
            return;
        }
        this.queued.add(toast);
        Helper.getPlatformsLogger().debug("Queued toast {}", (Object)toast);
    }

    public void render(class_332 ctx) {
        if (this.minecraft.field_1690.field_1842) {
            return;
        }
        int screenWidth = ctx.method_51421();
        Iterator<CustomToastInstance<?>> it = this.visable.iterator();
        while (it.hasNext()) {
            CustomToastInstance<?> instance = it.next();
            if (!instance.render(screenWidth, ctx)) continue;
            this.occupiedSlots.clear(instance.index, instance.index + instance.slotCount);
            it.remove();
        }
        if (!this.queued.isEmpty() && this.freeSlots() > 0) {
            Iterator<class_368> qi = this.queued.iterator();
            while (qi.hasNext() && this.freeSlots() > 0) {
                class_368 toast = qi.next();
                int slots = toast.method_45072();
                int idx = this.findFreeIndex(slots);
                if (idx == -1) continue;
                this.visable.add(new CustomToastInstance(this, toast, idx, slots));
                this.occupiedSlots.set(idx, idx + slots);
                qi.remove();
            }
        }
    }

    private int freeSlots() {
        return this.getSlotCount() - this.occupiedSlots.cardinality();
    }

    private int findFreeIndex(int slotCount) {
        if (this.freeSlots() < slotCount) {
            return -1;
        }
        int count = 0;
        for (int i = 0; i < this.getSlotCount(); ++i) {
            if (this.occupiedSlots.get(i)) {
                count = 0;
                continue;
            }
            if (++count != slotCount) continue;
            return i + 1 - slotCount;
        }
        return -1;
    }

    public <T extends class_368> T getToast(Class<? extends T> pToastClass, Object token) {
        for (CustomToastInstance<?> inst : this.visable) {
            Object t = inst.toast;
            if (!pToastClass.isAssignableFrom(t.getClass()) || !t.method_1987().equals(token)) continue;
            return t;
        }
        for (class_368 t : this.queued) {
            if (!pToastClass.isAssignableFrom(t.getClass()) || !t.method_1987().equals(token)) continue;
            return (T)t;
        }
        return null;
    }

    private int getBaseX() {
        return this.config().getInt("Toast-Rendering.Base-X", 0);
    }

    private int getBaseY() {
        return this.config().getInt("Toast-Rendering.Base-Y", 0);
    }

    private int getSlotCount() {
        return Math.max(1, this.config().getInt("Settings.Max-Toasts", 1));
    }

    private long getAnimationTime() {
        return this.config().getLong("Toast-Animation.Animation-Time", 1000L) <= 0L ? 1500L : this.config().getLong("Toast-Animation.Animation-Time", 1000L);
    }

    public static String getSoundInForDimension(String dimId) {
        YamlConfigUtil config = new ConfigReader().getConfig();
        List<String> mappings = config.getStringList("Sound-Settings.In-Sound", List.of("minecraft:overworld=minecraft:ui.toast.in", "minecraft:the_nether=minecraft:ui.toast.in", "minecraft:the_end=minecraft:ui.toast.in"));
        return CustomToastComponent.parseMappings(mappings).getOrDefault(dimId, "minecraft:ui.toast.in");
    }

    public static String getSoundOutForDimension(String dimId) {
        YamlConfigUtil config = new ConfigReader().getConfig();
        List<String> mappings = config.getStringList("Sound-Settings.Out-Sound", List.of("minecraft:overworld=minecraft:ui.toast.out", "minecraft:the_nether=minecraft:ui.toast.out", "minecraft:the_end=minecraft:ui.toast.out"));
        return CustomToastComponent.parseMappings(mappings).getOrDefault(dimId, "minecraft:ui.toast.out");
    }

    private static Map<String, String> parseMappings(List<String> raw) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String entry : raw) {
            String[] split = entry.split("=", 2);
            if (split.length != 2) continue;
            map.put(split[0].trim(), split[1].trim());
        }
        return map;
    }

    @Environment(value=EnvType.CLIENT)
    private class CustomToastInstance<T extends class_368> {
        private final T toast;
        private final int index;
        private final int slotCount;
        private long animationTime = -1L;
        private long visibleTime = -1L;
        private class_368.class_369 visibility = class_368.class_369.field_2210;
        final /* synthetic */ CustomToastComponent this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        CustomToastInstance(T toast, int index, int slotCount) {
            this.this$0 = (CustomToastComponent)n;
            this.toast = toast;
            this.index = index;
            this.slotCount = slotCount;
            if (toast instanceof XpToast) {
                XpToast xpToast = (XpToast)toast;
                xpToast.addGained(0);
            }
        }

        public boolean render(int screenWidth, class_332 ctx) {
            XpToast xpToast;
            T t;
            float anchorX;
            long now = System.currentTimeMillis();
            if (this.animationTime < 0L) {
                this.animationTime = now;
                if (this.this$0.config().getBoolean("Sound-Settings.Enabled", true)) {
                    class_3414 inSound;
                    String dimKey = this.this$0.minecraft.field_1687.method_27983().method_29177().toString();
                    if (dimKey.isEmpty()) {
                        class_638 cfr_ignored_0 = this.this$0.minecraft.field_1687;
                        class_5321 world = class_638.field_25179;
                        dimKey = world.method_29177().toString();
                    }
                    if ((inSound = (class_3414)class_7923.field_41172.method_63535(class_2960.method_12829((String)CustomToastComponent.getSoundInForDimension(dimKey)))) != null) {
                        Objects.requireNonNull(this.this$0.minecraft.field_1724).method_5783(inSound, 1.0f, 1.0f);
                    }
                }
            }
            if (this.visibility == class_368.class_369.field_2210 && now - this.animationTime <= this.this$0.getAnimationTime()) {
                this.visibleTime = now;
            }
            float t2 = (float)(now - this.animationTime) / (float)this.this$0.getAnimationTime();
            t2 = Math.min(1.0f, Math.max(0.0f, t2));
            float ease = t2 * t2;
            if (this.visibility == class_368.class_369.field_2209) {
                ease = 1.0f - ease;
            }
            ctx.method_51448().method_22903();
            String anchor = this.this$0.config().getString("Toast-Rendering.Anchor-Point", "bottom-left").toLowerCase();
            String dir = this.this$0.config().getString("Settings.Animation-Direction", "down").toLowerCase();
            boolean isLeft = dir.equals("left");
            boolean isRight = dir.equals("right");
            boolean isTop = dir.equals("top");
            boolean isDown = dir.equals("down") || !isLeft && !isRight && !isTop;
            boolean noSlide = this.this$0.config().getBoolean("Toast-Animation.No-Slide", false);
            int toastW = this.toast.method_29049();
            int toastH = this.toast.method_29050();
            int screenH = ctx.method_51443();
            float anchorY = switch (anchor) {
                case "top-left" -> {
                    anchorX = 0.0f;
                    yield 0.0f;
                }
                case "top-center" -> {
                    anchorX = (float)(screenWidth - toastW) / 2.0f;
                    yield 0.0f;
                }
                case "top-right" -> {
                    anchorX = screenWidth - toastW;
                    yield 0.0f;
                }
                case "middle-left" -> {
                    anchorX = 0.0f;
                    yield (float)(screenH - toastH) / 2.0f;
                }
                case "middle-center", "center" -> {
                    anchorX = (float)(screenWidth - toastW) / 2.0f;
                    yield (float)(screenH - toastH) / 2.0f;
                }
                case "middle-right" -> {
                    anchorX = screenWidth - toastW;
                    yield (float)(screenH - toastH) / 2.0f;
                }
                case "bottom-left" -> {
                    anchorX = 0.0f;
                    yield screenH - toastH;
                }
                case "bottom-center" -> {
                    anchorX = (float)(screenWidth - toastW) / 2.0f;
                    yield screenH - toastH;
                }
                default -> {
                    anchorX = screenWidth - toastW;
                    yield screenH - toastH;
                }
            };
            anchorX += (float)this.this$0.getBaseX();
            anchorY += (float)this.this$0.getBaseY();
            float offsetX = 0.0f;
            float offsetY = 0.0f;
            if (isTop) {
                offsetY = -this.index * toastH;
            } else if (isDown) {
                offsetY = this.index * toastH;
            } else if (isLeft) {
                offsetX = -this.index * toastW;
            } else if (isRight) {
                offsetX = this.index * toastW;
            }
            float slideX = 0.0f;
            float slideY = 0.0f;
            if (!noSlide) {
                if (isLeft) {
                    slideX = (1.0f - ease) * (float)toastW;
                } else if (isRight) {
                    slideX = -(1.0f - ease) * (float)toastW;
                } else if (isTop) {
                    slideY = (1.0f - ease) * (float)toastH;
                } else if (isDown) {
                    slideY = -(1.0f - ease) * (float)toastH;
                }
            }
            float x = anchorX + offsetX + slideX;
            float y = anchorY + offsetY + slideY;
            ctx.method_51448().method_46416(x, y, 800.0f);
            this.toast.method_61989(this.this$0.minecraft.method_1566(), now);
            this.toast.method_1986(ctx, this.this$0.minecraft.field_1772, now - this.visibleTime);
            class_368.class_369 newVis = this.toast.method_61988();
            ctx.method_51448().method_22909();
            if (newVis != this.visibility) {
                this.animationTime = now - (long)((1.0f - ease) * (float)this.this$0.getAnimationTime());
                this.visibility = newVis;
                if (this.this$0.config().getBoolean("Sound-Settings.Enabled", true)) {
                    class_3414 outSound;
                    String dimKey = this.this$0.minecraft.field_1687.method_27983().method_29177().toString();
                    if (dimKey.isEmpty()) {
                        class_638 cfr_ignored_1 = this.this$0.minecraft.field_1687;
                        class_5321 world = class_638.field_25179;
                        dimKey = world.method_29177().toString();
                    }
                    if ((outSound = (class_3414)class_7923.field_41172.method_63535(class_2960.method_12829((String)CustomToastComponent.getSoundOutForDimension(dimKey)))) != null) {
                        Objects.requireNonNull(this.this$0.minecraft.field_1724).method_5783(outSound, 1.0f, 1.0f);
                    }
                }
            }
            boolean finished = (t = this.toast) instanceof XpToast ? now - (xpToast = (XpToast)t).getLastUpdateTime() > this.this$0.config().getLong("Toast-Animation.Stack-XP-Timer", 5000L) : this.visibility == class_368.class_369.field_2209 && now - this.animationTime > this.this$0.getAnimationTime();
            return finished;
        }
    }
}

