/*
 * Decompiled with CFR 0.152.
 */
package com.github.spacemex.forge.networking;

import com.github.spacemex.networking.XpGainPayload;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import net.puffish.skillsmod.api.SkillsAPI;

public class ServerNotifier {
    private static final Map<UUID, Map<ResourceLocation, Integer>> lastTotals = new HashMap<UUID, Map<ResourceLocation, Integer>>();

    @SubscribeEvent
    public static void onServerTick(ServerTickEvent.Post event) {
        if (event == null) {
            return;
        }
        MinecraftServer sserver = event.getServer();
        int ticks = sserver.getTickCount();
        if (ticks % 20 != 0) {
            return;
        }
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        for (ServerPlayer player : server.getPlayerList().getPlayers()) {
            UUID uuid = player.getUUID();
            Map playerMap = lastTotals.computeIfAbsent(uuid, __ -> new HashMap());
            SkillsAPI.streamCategories().forEach(cat -> cat.getExperience().ifPresent(exp -> {
                int prev;
                ResourceLocation id = cat.getId();
                int total = exp.getTotal(player);
                if (total > (prev = playerMap.getOrDefault(id, total).intValue())) {
                    int delta = total - prev;
                    XpGainPayload payload = new XpGainPayload(id, delta);
                    PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                playerMap.put(id, total);
            }));
        }
    }

    public static void register() {
        NeoForge.EVENT_BUS.register(ServerNotifier.class);
    }
}

