/*
 * Decompiled with CFR 0.152.
 */
package com.example.chatmoderator.libs.foliascheduler;

import com.example.chatmoderator.libs.foliascheduler.TaskImplementation;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface AsyncSchedulerImplementation {
    @NotNull
    public <T> TaskImplementation<T> runNow(@NotNull Function<TaskImplementation<T>, T> var1);

    @NotNull
    default public TaskImplementation<Void> runNow(@NotNull Consumer<TaskImplementation<Void>> consumer) {
        Function<TaskImplementation, Void> wrapperFunction = task -> {
            consumer.accept((TaskImplementation<Void>)task);
            return null;
        };
        return this.runNow(wrapperFunction);
    }

    @NotNull
    default public TaskImplementation<Void> runNow(@NotNull Runnable runnable2) {
        Function<TaskImplementation, Void> wrapperFunction = task -> {
            runnable2.run();
            return null;
        };
        return this.runNow(wrapperFunction);
    }

    @NotNull
    public <T> TaskImplementation<T> runDelayed(@NotNull Function<TaskImplementation<T>, T> var1, long var2, @NotNull TimeUnit var4);

    @NotNull
    default public TaskImplementation<Void> runDelayed(@NotNull Consumer<TaskImplementation<Void>> consumer, long delay, @NotNull TimeUnit unit) {
        Function<TaskImplementation, Void> wrapperFunction = task -> {
            consumer.accept((TaskImplementation<Void>)task);
            return null;
        };
        return this.runDelayed(wrapperFunction, delay, unit);
    }

    @NotNull
    default public TaskImplementation<Void> runDelayed(@NotNull Runnable runnable2, long delay, @NotNull TimeUnit unit) {
        Function<TaskImplementation, Void> wrapperFunction = task -> {
            runnable2.run();
            return null;
        };
        return this.runDelayed(wrapperFunction, delay, unit);
    }

    @NotNull
    default public <T> TaskImplementation<T> runDelayed(@NotNull Function<TaskImplementation<T>, @Nullable T> function, long ticks) {
        return this.runDelayed(function, ticks * 50L, TimeUnit.MILLISECONDS);
    }

    @NotNull
    default public TaskImplementation<Void> runDelayed(@NotNull Consumer<TaskImplementation<Void>> consumer, long ticks) {
        return this.runDelayed(consumer, ticks * 50L, TimeUnit.MILLISECONDS);
    }

    @NotNull
    default public TaskImplementation<Void> runDelayed(@NotNull Runnable runnable2, long ticks) {
        return this.runDelayed(runnable2, ticks * 50L, TimeUnit.MILLISECONDS);
    }

    @NotNull
    public <T> TaskImplementation<T> runAtFixedRate(@NotNull Function<TaskImplementation<T>, T> var1, long var2, long var4, @NotNull TimeUnit var6);

    @NotNull
    default public TaskImplementation<Void> runAtFixedRate(@NotNull Consumer<TaskImplementation<Void>> consumer, long delay, long period, @NotNull TimeUnit unit) {
        Function<TaskImplementation, Void> wrapperFunction = task -> {
            consumer.accept((TaskImplementation<Void>)task);
            return null;
        };
        return this.runAtFixedRate(wrapperFunction, delay, period, unit);
    }

    @NotNull
    default public TaskImplementation<Void> runAtFixedRate(@NotNull Runnable runnable2, long delay, long period, @NotNull TimeUnit unit) {
        Function<TaskImplementation, Void> wrapperFunction = task -> {
            runnable2.run();
            return null;
        };
        return this.runAtFixedRate(wrapperFunction, delay, period, unit);
    }

    @NotNull
    default public <T> TaskImplementation<T> runAtFixedRate(@NotNull Function<TaskImplementation<T>, @Nullable T> function, long delay, long ticks) {
        return this.runAtFixedRate(function, delay * 50L, ticks * 50L, TimeUnit.MILLISECONDS);
    }

    @NotNull
    default public TaskImplementation<Void> runAtFixedRate(@NotNull Consumer<TaskImplementation<Void>> consumer, long delay, long ticks) {
        return this.runAtFixedRate(consumer, delay * 50L, ticks * 50L, TimeUnit.MILLISECONDS);
    }

    @NotNull
    default public TaskImplementation<Void> runAtFixedRate(@NotNull Runnable runnable2, long delay, long ticks) {
        return this.runAtFixedRate(runnable2, delay * 50L, ticks * 50L, TimeUnit.MILLISECONDS);
    }

    public void cancelTasks();
}

