/*
 * Decompiled with CFR 0.152.
 */
package com.example.chatmoderator.libs.foliascheduler.mappingio.adapter;

import com.example.chatmoderator.libs.foliascheduler.mappingio.MappingVisitor;
import com.example.chatmoderator.libs.foliascheduler.mappingio.adapter.ForwardingMappingVisitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class MappingNsRenamer
extends ForwardingMappingVisitor {
    private final Map<String, String> nameMap;

    public MappingNsRenamer(MappingVisitor next, Map<String, String> nameMap) {
        super(next);
        Objects.requireNonNull(nameMap, "null name map");
        this.nameMap = nameMap;
    }

    @Override
    public void visitNamespaces(String srcNamespace, List<String> dstNamespaces) throws IOException {
        String newSrcNamespace = this.nameMap.getOrDefault(srcNamespace, srcNamespace);
        ArrayList<String> newDstNamespaces = new ArrayList<String>(dstNamespaces.size());
        for (String ns : dstNamespaces) {
            newDstNamespaces.add(this.nameMap.getOrDefault(ns, ns));
        }
        super.visitNamespaces(newSrcNamespace, newDstNamespaces);
    }
}

