/*
 * Decompiled with CFR 0.152.
 */
package com.example.chatmoderator.libs.foliascheduler.mappingio.adapter;

import com.example.chatmoderator.libs.foliascheduler.mappingio.MappedElementKind;
import com.example.chatmoderator.libs.foliascheduler.mappingio.MappingFlag;
import com.example.chatmoderator.libs.foliascheduler.mappingio.MappingUtil;
import com.example.chatmoderator.libs.foliascheduler.mappingio.MappingVisitor;
import com.example.chatmoderator.libs.foliascheduler.mappingio.adapter.ForwardingMappingVisitor;
import java.io.IOException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;

public class OuterClassNamePropagator
extends ForwardingMappingVisitor {
    private static final int collectClassesPass = 1;
    private static final int fixOuterClassesPass = 2;
    private static final int firstEmitPass = 3;
    private final Map<String, String[]> dstNamesBySrcName = new HashMap<String, String[]>();
    private final Set<String> modifiedClasses = new HashSet<String>();
    private int pass = 1;
    private int dstNsCount = -1;
    private String srcName;
    private boolean[] visitedDstName;
    private Map<String, String>[] dstNameBySrcNameByNamespace;

    public OuterClassNamePropagator(MappingVisitor next) {
        super(next);
    }

    @Override
    public Set<MappingFlag> getFlags() {
        EnumSet<MappingFlag> ret = EnumSet.noneOf(MappingFlag.class);
        ret.addAll(this.next.getFlags());
        ret.add(MappingFlag.NEEDS_MULTIPLE_PASSES);
        return ret;
    }

    @Override
    public boolean visitHeader() throws IOException {
        if (this.pass < 3) {
            return true;
        }
        return super.visitHeader();
    }

    @Override
    public void visitNamespaces(String srcNamespace, List<String> dstNamespaces) throws IOException {
        this.dstNsCount = dstNamespaces.size();
        if (this.pass == 1) {
            this.visitedDstName = new boolean[this.dstNsCount];
            this.dstNameBySrcNameByNamespace = new HashMap[this.dstNsCount];
        } else if (this.pass >= 3) {
            super.visitNamespaces(srcNamespace, dstNamespaces);
        }
    }

    @Override
    public void visitMetadata(String key, @Nullable String value) throws IOException {
        if (this.pass < 3) {
            return;
        }
        super.visitMetadata(key, value);
    }

    @Override
    public boolean visitContent() throws IOException {
        if (this.pass < 3) {
            return true;
        }
        return super.visitContent();
    }

    @Override
    public boolean visitClass(String srcName) throws IOException {
        this.srcName = srcName;
        if (this.pass == 1) {
            this.dstNamesBySrcName.putIfAbsent(srcName, new String[this.dstNsCount]);
        } else if (this.pass >= 3) {
            super.visitClass(srcName);
        }
        return true;
    }

    @Override
    public void visitDstName(MappedElementKind targetKind, int namespace, String name) throws IOException {
        if (this.pass == 1) {
            if (targetKind != MappedElementKind.CLASS) {
                return;
            }
            this.dstNamesBySrcName.get((Object)this.srcName)[namespace] = name;
        } else if (this.pass >= 3) {
            if (targetKind == MappedElementKind.CLASS) {
                this.visitedDstName[namespace] = true;
                name = this.dstNamesBySrcName.get(this.srcName)[namespace];
            }
            super.visitDstName(targetKind, namespace, name);
        }
    }

    @Override
    public void visitDstDesc(MappedElementKind targetKind, int namespace, String desc) throws IOException {
        if (this.pass < 3) {
            return;
        }
        if (this.modifiedClasses.contains(this.srcName)) {
            Map nsDstNameBySrcName = this.dstNameBySrcNameByNamespace[namespace];
            if (nsDstNameBySrcName == null) {
                this.dstNameBySrcNameByNamespace[namespace] = nsDstNameBySrcName = (Map)this.dstNamesBySrcName.entrySet().stream().filter(entry -> ((String[])entry.getValue())[namespace] != null).collect(HashMap::new, (map, entry) -> map.put((String)entry.getKey(), ((String[])entry.getValue())[namespace]), HashMap::putAll);
            }
            desc = MappingUtil.mapDesc(desc, nsDstNameBySrcName);
        }
        super.visitDstDesc(targetKind, namespace, desc);
    }

    @Override
    public boolean visitElementContent(MappedElementKind targetKind) throws IOException {
        if (targetKind == MappedElementKind.CLASS && this.pass > 1) {
            String[] dstNames = this.dstNamesBySrcName.get(this.srcName);
            block0: for (int ns = 0; ns < dstNames.length; ++ns) {
                String dstName = dstNames[ns];
                if (this.pass == 2) {
                    if (dstName != null) continue;
                    String[] parts = this.srcName.split(Pattern.quote("$"));
                    for (int pos = parts.length - 2; pos >= 0; --pos) {
                        String outerSrcName = String.join((CharSequence)"$", Arrays.copyOfRange(parts, 0, pos + 1));
                        String outerDstName = this.dstNamesBySrcName.get(outerSrcName)[ns];
                        if (outerDstName == null) continue;
                        dstNames[ns] = dstName = outerDstName + "$" + String.join((CharSequence)"$", Arrays.copyOfRange(parts, pos + 1, parts.length));
                        this.modifiedClasses.add(this.srcName);
                        continue block0;
                    }
                    continue;
                }
                if (this.visitedDstName[ns] || dstName == null) continue;
                super.visitDstName(targetKind, ns, dstName);
            }
        }
        if (this.pass < 3) {
            return false;
        }
        Arrays.fill(this.visitedDstName, false);
        return super.visitElementContent(targetKind);
    }

    @Override
    public boolean visitEnd() throws IOException {
        if (this.pass++ < 3) {
            return false;
        }
        return super.visitEnd();
    }
}

