/*
 * Decompiled with CFR 0.152.
 */
package com.example.chatmoderator.libs.genai;

import com.example.chatmoderator.libs.genai.ApiClient;
import com.example.chatmoderator.libs.genai.JsonSerializable;
import com.example.chatmoderator.libs.genai.Transformers;
import com.example.chatmoderator.libs.genai.types.FunctionCall;
import com.example.chatmoderator.libs.genai.types.GenerateContentConfig;
import com.example.chatmoderator.libs.genai.types.GenerateContentResponse;
import com.example.chatmoderator.libs.genai.types.Part;
import com.example.chatmoderator.libs.genai.types.Tool;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.logging.Logger;

final class AfcUtil {
    private static final Logger logger = Logger.getLogger(AfcUtil.class.getName());
    private static final int DEFAULT_MAX_REMOTE_CALLS_AFC = 10;

    static boolean hasCallableTool(ApiClient apiClient, GenerateContentConfig config) {
        if (config == null) {
            return false;
        }
        if (!config.tools().isPresent() || config.tools().get().isEmpty()) {
            return false;
        }
        for (Tool tool : config.tools().get()) {
            if (!tool.functions().isPresent() || tool.functions().get().isEmpty()) continue;
            return true;
        }
        return false;
    }

    static GenerateContentConfig transformGenerateContentConfig(ApiClient apiClient, GenerateContentConfig config) {
        GenerateContentConfig transformedConfig;
        if (config != null && config.tools().isPresent() && !config.tools().get().isEmpty()) {
            ImmutableList transformedTools = config.tools().get().stream().map(tool -> Transformers.tTool(apiClient, tool)).collect(ImmutableList.toImmutableList());
            ObjectNode configNode = (ObjectNode)JsonSerializable.objectMapper.valueToTree(config);
            configNode.set("tools", (JsonNode)JsonSerializable.objectMapper.valueToTree(transformedTools));
            transformedConfig = JsonSerializable.fromJsonNode(configNode, GenerateContentConfig.class);
        } else {
            transformedConfig = config;
        }
        return transformedConfig;
    }

    static ImmutableMap<String, Method> getFunctionMap(GenerateContentConfig config) {
        ImmutableMap.Builder<String, Method> functionMapBuilder = ImmutableMap.builder();
        if (config != null && config.tools().isPresent() && !config.tools().get().isEmpty()) {
            for (Tool tool : config.tools().get()) {
                if (!tool.functions().isPresent() || tool.functions().get().isEmpty()) continue;
                for (Method method : tool.functions().get()) {
                    functionMapBuilder.put(method.getName(), method);
                }
            }
        }
        return functionMapBuilder.buildOrThrow();
    }

    static ImmutableList<Part> getFunctionResponseParts(GenerateContentResponse response, ImmutableMap<String, Method> functionMap) {
        ImmutableList.Builder functionResponsePartsBuilder = ImmutableList.builder();
        ImmutableList<Part> responseParts = response.parts();
        ImmutableList<FunctionCall> functionCalls = response.functionCalls();
        if (responseParts == null || responseParts.isEmpty() || functionCalls == null || functionCalls.isEmpty()) {
            return functionResponsePartsBuilder.build();
        }
        for (FunctionCall functionCall : functionCalls) {
            String funcName = functionCall.name().get();
            if (funcName == null || !functionMap.containsKey(funcName)) continue;
            Method method = functionMap.get(funcName);
            ImmutableMap<String, Object> args2 = ImmutableMap.copyOf(functionCall.args().get());
            try {
                Object funcResponse = AfcUtil.getFunctionResponse(method, args2);
                if (funcResponse == null) {
                    functionResponsePartsBuilder.add(Part.fromFunctionResponse(funcName, ImmutableMap.of("result", "")));
                    continue;
                }
                functionResponsePartsBuilder.add(Part.fromFunctionResponse(funcName, ImmutableMap.of("result", funcResponse)));
            }
            catch (Exception e) {
                functionResponsePartsBuilder.add(Part.fromFunctionResponse(funcName, ImmutableMap.of("error", e.toString())));
            }
        }
        return functionResponsePartsBuilder.build();
    }

    static boolean shouldDisableAfc(GenerateContentConfig config) {
        if (config == null) {
            return false;
        }
        if (!config.automaticFunctionCalling().isPresent()) {
            return false;
        }
        Optional<Boolean> disable = config.automaticFunctionCalling().get().disable();
        Optional<Integer> maximumRemoteCalls = config.automaticFunctionCalling().get().maximumRemoteCalls();
        if (!disable.isPresent()) {
            return false;
        }
        if (maximumRemoteCalls.isPresent() && maximumRemoteCalls.get() <= 0) {
            logger.warning(String.format("maxRemoteCalls in AfautomaticFunctionCallingConfig %s is less than or equal to 0. Disabling automatic function calling. Please set maximumRemoteCalls to a positive integer.", maximumRemoteCalls.get()));
            return true;
        }
        if (disable.get().booleanValue() && maximumRemoteCalls.isPresent() && maximumRemoteCalls.get() > 0) {
            logger.warning(String.format("`automaticFunctionCalling.disable` is set to `true`. And `automaticFunctionCalling.maximumRemoteCalls` is a positive number %s. Disabling automatic function calling. If you want to enable automatic function calling, please set `automaticFunctionCalling.disable` to `false` or leave it unset.", maximumRemoteCalls.get()));
        }
        return disable.get();
    }

    static int getMaxRemoteCallsAfc(GenerateContentConfig config) {
        if (config == null) {
            return 10;
        }
        if (!config.automaticFunctionCalling().isPresent()) {
            return 10;
        }
        if (!config.automaticFunctionCalling().get().maximumRemoteCalls().isPresent()) {
            return 10;
        }
        return config.automaticFunctionCalling().get().maximumRemoteCalls().orElse(10);
    }

    static boolean shouldAppendAfcHistory(GenerateContentConfig config) {
        if (config == null) {
            return true;
        }
        if (!config.automaticFunctionCalling().isPresent()) {
            return true;
        }
        if (!config.automaticFunctionCalling().get().ignoreCallHistory().isPresent()) {
            return true;
        }
        return config.automaticFunctionCalling().get().ignoreCallHistory().get() == false;
    }

    private static Object getFunctionResponse(Method method, ImmutableMap<String, Object> argsFromModel) throws Exception {
        ArrayList<Object> argsListFromModel = new ArrayList<Object>();
        ImmutableList methodParameterNames = Arrays.stream(method.getParameters()).map(Parameter::getName).collect(ImmutableList.toImmutableList());
        block14: for (String parameterName : methodParameterNames) {
            if (!argsFromModel.containsKey(parameterName)) {
                throw new IllegalArgumentException("The parameter \"" + parameterName + "\" was not found in the function call part from model. Args in function call part from model are: " + argsFromModel);
            }
            Object argValueFromModel = argsFromModel.get(parameterName);
            switch (argValueFromModel.getClass().getName()) {
                case "java.lang.String": {
                    argsListFromModel.add(argValueFromModel);
                    continue block14;
                }
                case "java.lang.Integer": {
                    argsListFromModel.add(Integer.parseInt(argValueFromModel.toString()));
                    continue block14;
                }
                case "java.lang.Double": {
                    argsListFromModel.add(Double.parseDouble(argValueFromModel.toString()));
                    continue block14;
                }
                case "java.lang.Float": {
                    argsListFromModel.add(Float.valueOf(Float.parseFloat(argValueFromModel.toString())));
                    continue block14;
                }
                case "java.lang.Boolean": {
                    argsListFromModel.add(Boolean.parseBoolean(argValueFromModel.toString()));
                    continue block14;
                }
            }
            throw new IllegalArgumentException("The value type of the parameter \"" + parameterName + "\" is not supported. Supported types are String, Integer, Double, Float, and Boolean.");
        }
        return method.invoke(null, argsListFromModel.toArray());
    }

    private AfcUtil() {
    }
}

