/*
 * Decompiled with CFR 0.152.
 */
package com.example.chatmoderator.libs.genai;

import com.example.chatmoderator.libs.genai.ApiClient;
import com.example.chatmoderator.libs.genai.AsyncPager;
import com.example.chatmoderator.libs.genai.BasePager;
import com.example.chatmoderator.libs.genai.Caches;
import com.example.chatmoderator.libs.genai.JsonSerializable;
import com.example.chatmoderator.libs.genai.errors.GenAiIOException;
import com.example.chatmoderator.libs.genai.types.CachedContent;
import com.example.chatmoderator.libs.genai.types.CreateCachedContentConfig;
import com.example.chatmoderator.libs.genai.types.DeleteCachedContentConfig;
import com.example.chatmoderator.libs.genai.types.DeleteCachedContentResponse;
import com.example.chatmoderator.libs.genai.types.GetCachedContentConfig;
import com.example.chatmoderator.libs.genai.types.ListCachedContentsConfig;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public final class AsyncCaches {
    Caches caches;

    public AsyncCaches(ApiClient apiClient) {
        this.caches = new Caches(apiClient);
    }

    public CompletableFuture<CachedContent> create(String model, CreateCachedContentConfig config) {
        return CompletableFuture.supplyAsync(() -> this.caches.create(model, config));
    }

    public CompletableFuture<CachedContent> get(String name, GetCachedContentConfig config) {
        return CompletableFuture.supplyAsync(() -> this.caches.get(name, config));
    }

    public CompletableFuture<DeleteCachedContentResponse> delete(String name, DeleteCachedContentConfig config) {
        return CompletableFuture.supplyAsync(() -> this.caches.delete(name, config));
    }

    public CompletableFuture<AsyncPager<CachedContent>> list(ListCachedContentsConfig config) {
        Function<JsonSerializable, CompletableFuture> request = requestConfig -> {
            if (!(requestConfig instanceof ListCachedContentsConfig)) {
                throw new GenAiIOException("Internal error: Pager expected ListCachedContentsConfig but received " + requestConfig.getClass().getName());
            }
            return CompletableFuture.supplyAsync(() -> JsonSerializable.toJsonNode(this.caches.privateList((ListCachedContentsConfig)requestConfig)));
        };
        return CompletableFuture.supplyAsync(() -> new AsyncPager(BasePager.PagedItem.CACHED_CONTENTS, request, (ObjectNode)JsonSerializable.toJsonNode(config), (CompletableFuture)request.apply(config)));
    }
}

