/*
 * Decompiled with CFR 0.152.
 */
package com.example.chatmoderator.libs.genai;

import com.example.chatmoderator.libs.genai.ApiClient;
import com.example.chatmoderator.libs.genai.AsyncPager;
import com.example.chatmoderator.libs.genai.BasePager;
import com.example.chatmoderator.libs.genai.Files;
import com.example.chatmoderator.libs.genai.JsonSerializable;
import com.example.chatmoderator.libs.genai.errors.GenAiIOException;
import com.example.chatmoderator.libs.genai.types.DeleteFileConfig;
import com.example.chatmoderator.libs.genai.types.DeleteFileResponse;
import com.example.chatmoderator.libs.genai.types.DownloadFileConfig;
import com.example.chatmoderator.libs.genai.types.File;
import com.example.chatmoderator.libs.genai.types.GeneratedVideo;
import com.example.chatmoderator.libs.genai.types.GetFileConfig;
import com.example.chatmoderator.libs.genai.types.ListFilesConfig;
import com.example.chatmoderator.libs.genai.types.UploadFileConfig;
import com.example.chatmoderator.libs.genai.types.Video;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.InputStream;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public final class AsyncFiles {
    Files files;

    public AsyncFiles(ApiClient apiClient) {
        this.files = new Files(apiClient);
    }

    public CompletableFuture<File> get(String name, GetFileConfig config) {
        return CompletableFuture.supplyAsync(() -> this.files.get(name, config));
    }

    public CompletableFuture<DeleteFileResponse> delete(String name, DeleteFileConfig config) {
        return CompletableFuture.supplyAsync(() -> this.files.delete(name, config));
    }

    public CompletableFuture<File> upload(java.io.File file, UploadFileConfig config) {
        return CompletableFuture.supplyAsync(() -> this.files.upload(file, config));
    }

    public CompletableFuture<File> upload(byte[] bytes, UploadFileConfig config) {
        return CompletableFuture.supplyAsync(() -> this.files.upload(bytes, config));
    }

    public CompletableFuture<File> upload(InputStream stream, long size, UploadFileConfig config) {
        return CompletableFuture.supplyAsync(() -> this.files.upload(stream, size, config));
    }

    public CompletableFuture<File> upload(String filePath, UploadFileConfig config) {
        return CompletableFuture.supplyAsync(() -> this.files.upload(filePath, config));
    }

    public CompletableFuture<Void> download(String fileName, String downloadPath, DownloadFileConfig config) {
        return CompletableFuture.runAsync(() -> this.files.download(fileName, downloadPath, config));
    }

    public CompletableFuture<Void> download(Video video, String downloadPath, DownloadFileConfig config) {
        return CompletableFuture.runAsync(() -> this.files.download(video, downloadPath, config));
    }

    public CompletableFuture<Void> download(GeneratedVideo video, String downloadPath, DownloadFileConfig config) {
        return CompletableFuture.runAsync(() -> this.files.download(video, downloadPath, config));
    }

    public CompletableFuture<Void> download(File file, String downloadPath, DownloadFileConfig config) {
        return CompletableFuture.runAsync(() -> this.files.download(file, downloadPath, config));
    }

    public CompletableFuture<AsyncPager<File>> list(ListFilesConfig config) {
        Function<JsonSerializable, CompletableFuture> request = requestConfig -> {
            if (!(requestConfig instanceof ListFilesConfig)) {
                throw new GenAiIOException("Internal error: Pager expected ListFilesConfig but received " + requestConfig.getClass().getName());
            }
            return CompletableFuture.supplyAsync(() -> JsonSerializable.toJsonNode(this.files.privateList((ListFilesConfig)requestConfig)));
        };
        return CompletableFuture.supplyAsync(() -> new AsyncPager(BasePager.PagedItem.FILES, request, (ObjectNode)JsonSerializable.toJsonNode(config), (CompletableFuture)request.apply(config)));
    }
}

