/*
 * Decompiled with CFR 0.152.
 */
package com.example.chatmoderator.libs.genai;

import com.example.chatmoderator.libs.genai.ApiClient;
import com.example.chatmoderator.libs.genai.ApiResponse;
import com.example.chatmoderator.libs.genai.HttpApiResponse;
import com.example.chatmoderator.libs.genai.errors.GenAiIOException;
import com.example.chatmoderator.libs.genai.types.HttpOptions;
import com.example.chatmoderator.libs.googleapi.core.InternalApi;
import com.example.chatmoderator.libs.googleauth.oauth2.GoogleCredentials;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;

@InternalApi
public class HttpApiClient
extends ApiClient {
    HttpApiClient(Optional<String> apiKey, Optional<HttpOptions> httpOptions) {
        super(apiKey, httpOptions);
    }

    HttpApiClient(Optional<String> project, Optional<String> location, Optional<GoogleCredentials> credentials, Optional<HttpOptions> httpOptions) {
        super(project, location, credentials, httpOptions);
    }

    @Override
    public HttpApiResponse request(String httpMethod, String path, String requestJson, Optional<HttpOptions> requestHttpOptions) {
        HttpOptions mergedHttpOptions;
        boolean queryBaseModel;
        boolean bl = queryBaseModel = httpMethod.equalsIgnoreCase("GET") && path.startsWith("publishers/google/models");
        if (this.vertexAI() && !path.startsWith("projects/") && !queryBaseModel) {
            path = String.format("projects/%s/locations/%s/", this.project.get(), this.location.get()) + path;
        }
        String requestUrl = (mergedHttpOptions = this.mergeHttpOptions(requestHttpOptions.orElse(null))).apiVersion().get().isEmpty() ? String.format("%s/%s", mergedHttpOptions.baseUrl().get(), path) : String.format("%s/%s/%s", mergedHttpOptions.baseUrl().get(), mergedHttpOptions.apiVersion().get(), path);
        if (httpMethod.equalsIgnoreCase("POST")) {
            HttpPost httpPost = new HttpPost(requestUrl);
            this.setHeaders(httpPost, mergedHttpOptions);
            httpPost.setEntity(new StringEntity(requestJson, ContentType.APPLICATION_JSON));
            return this.executeRequest(httpPost);
        }
        if (httpMethod.equalsIgnoreCase("GET")) {
            HttpGet httpGet = new HttpGet(requestUrl);
            this.setHeaders(httpGet, mergedHttpOptions);
            return this.executeRequest(httpGet);
        }
        if (httpMethod.equalsIgnoreCase("DELETE")) {
            HttpDelete httpDelete = new HttpDelete(requestUrl);
            this.setHeaders(httpDelete, mergedHttpOptions);
            return this.executeRequest(httpDelete);
        }
        if (httpMethod.equalsIgnoreCase("PATCH")) {
            HttpPatch httpPatch = new HttpPatch(requestUrl);
            this.setHeaders(httpPatch, mergedHttpOptions);
            httpPatch.setEntity(new StringEntity(requestJson, ContentType.APPLICATION_JSON));
            return this.executeRequest(httpPatch);
        }
        throw new IllegalArgumentException("Unsupported HTTP method: " + httpMethod);
    }

    @Override
    public ApiResponse request(String httpMethod, String url, byte[] requestBytes, Optional<HttpOptions> requestHttpOptions) {
        HttpOptions mergedHttpOptions = this.mergeHttpOptions(requestHttpOptions.orElse(null));
        if (httpMethod.equalsIgnoreCase("POST")) {
            HttpPost httpPost = new HttpPost(url);
            this.setHeaders(httpPost, mergedHttpOptions);
            httpPost.setEntity(new ByteArrayEntity(requestBytes));
            return this.executeRequest(httpPost);
        }
        throw new IllegalArgumentException("The request method with bytes is only supported for POST. Unsupported HTTP method: " + httpMethod);
    }

    private void setHeaders(HttpRequestBase request, HttpOptions requestHttpOptions) {
        for (Map.Entry header : ((Map)requestHttpOptions.headers().orElse(ImmutableMap.of())).entrySet()) {
            request.setHeader((String)header.getKey(), (String)header.getValue());
        }
        if (this.apiKey.isPresent()) {
            request.setHeader("x-goog-api-key", (String)this.apiKey.get());
        } else {
            String accessToken;
            GoogleCredentials cred = (GoogleCredentials)this.credentials.orElseThrow(() -> new IllegalStateException("credentials is required"));
            try {
                cred.refreshIfExpired();
            }
            catch (IOException e) {
                throw new GenAiIOException("Failed to refresh credentials.", e);
            }
            try {
                accessToken = cred.getAccessToken().getTokenValue();
            }
            catch (NullPointerException e) {
                if (e.getMessage().contains("because the return value of \"com.google.auth.oauth2.GoogleCredentials.getAccessToken()\" is null")) {
                    accessToken = "";
                }
                throw e;
            }
            request.setHeader("Authorization", "Bearer " + accessToken);
            if (cred.getQuotaProjectId() != null) {
                request.setHeader("x-goog-user-project", cred.getQuotaProjectId());
            }
        }
    }

    private HttpApiResponse executeRequest(HttpRequestBase request) {
        try {
            return new HttpApiResponse(this.httpClient.execute(request));
        }
        catch (IOException e) {
            throw new GenAiIOException("Failed to execute HTTP request.", e);
        }
    }
}

