/*
 * Decompiled with CFR 0.152.
 */
package com.example.chatmoderator.libs.genai.types;

import com.example.chatmoderator.libs.genai.JsonSerializable;
import com.example.chatmoderator.libs.genai.types.ApiKeyConfig;
import com.example.chatmoderator.libs.genai.types.AuthConfigGoogleServiceAccountConfig;
import com.example.chatmoderator.libs.genai.types.AuthConfigHttpBasicAuthConfig;
import com.example.chatmoderator.libs.genai.types.AuthConfigOauthConfig;
import com.example.chatmoderator.libs.genai.types.AuthConfigOidcConfig;
import com.example.chatmoderator.libs.genai.types.AuthType;
import com.example.chatmoderator.libs.genai.types.AutoValue_AuthConfig;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class AuthConfig
extends JsonSerializable {
    @JsonProperty(value="apiKeyConfig")
    public abstract Optional<ApiKeyConfig> apiKeyConfig();

    @JsonProperty(value="authType")
    public abstract Optional<AuthType> authType();

    @JsonProperty(value="googleServiceAccountConfig")
    public abstract Optional<AuthConfigGoogleServiceAccountConfig> googleServiceAccountConfig();

    @JsonProperty(value="httpBasicAuthConfig")
    public abstract Optional<AuthConfigHttpBasicAuthConfig> httpBasicAuthConfig();

    @JsonProperty(value="oauthConfig")
    public abstract Optional<AuthConfigOauthConfig> oauthConfig();

    @JsonProperty(value="oidcConfig")
    public abstract Optional<AuthConfigOidcConfig> oidcConfig();

    public static Builder builder() {
        return new AutoValue_AuthConfig.Builder();
    }

    public abstract Builder toBuilder();

    public static AuthConfig fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, AuthConfig.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_AuthConfig.Builder();
        }

        @JsonProperty(value="apiKeyConfig")
        public abstract Builder apiKeyConfig(ApiKeyConfig var1);

        @JsonProperty(value="authType")
        public abstract Builder authType(AuthType var1);

        @CanIgnoreReturnValue
        public Builder authType(AuthType.Known knownType) {
            return this.authType(new AuthType(knownType));
        }

        @CanIgnoreReturnValue
        public Builder authType(String authType) {
            return this.authType(new AuthType(authType));
        }

        @JsonProperty(value="googleServiceAccountConfig")
        public abstract Builder googleServiceAccountConfig(AuthConfigGoogleServiceAccountConfig var1);

        @JsonProperty(value="httpBasicAuthConfig")
        public abstract Builder httpBasicAuthConfig(AuthConfigHttpBasicAuthConfig var1);

        @JsonProperty(value="oauthConfig")
        public abstract Builder oauthConfig(AuthConfigOauthConfig var1);

        @JsonProperty(value="oidcConfig")
        public abstract Builder oidcConfig(AuthConfigOidcConfig var1);

        public abstract AuthConfig build();
    }
}

