/*
 * Decompiled with CFR 0.152.
 */
package com.example.chatmoderator.libs.genai.types;

import com.example.chatmoderator.libs.genai.JsonSerializable;
import com.example.chatmoderator.libs.genai.types.AutoValue_FunctionDeclaration;
import com.example.chatmoderator.libs.genai.types.Behavior;
import com.example.chatmoderator.libs.genai.types.Schema;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class FunctionDeclaration
extends JsonSerializable {
    @JsonProperty(value="behavior")
    public abstract Optional<Behavior> behavior();

    @JsonProperty(value="description")
    public abstract Optional<String> description();

    @JsonProperty(value="name")
    public abstract Optional<String> name();

    @JsonProperty(value="parameters")
    public abstract Optional<Schema> parameters();

    @JsonProperty(value="response")
    public abstract Optional<Schema> response();

    public static Builder builder() {
        return new AutoValue_FunctionDeclaration.Builder();
    }

    public abstract Builder toBuilder();

    public static FunctionDeclaration fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, FunctionDeclaration.class);
    }

    public static FunctionDeclaration fromMethod(Method method, String ... orderedParameterNames) {
        return FunctionDeclaration.fromMethod("", method, orderedParameterNames);
    }

    public static FunctionDeclaration fromMethod(String functionDescription, Method method, String ... orderedParameterNames) {
        if (!Modifier.isStatic(method.getModifiers())) {
            throw new IllegalArgumentException("Instance methods are not supported. Please use static methods.");
        }
        Schema.Builder parametersBuilder = Schema.builder().type("OBJECT");
        Parameter[] parameters = method.getParameters();
        if (orderedParameterNames.length > 0 && orderedParameterNames.length != parameters.length) {
            throw new IllegalArgumentException("The number of parameter names passed to the orderedParameterNames argument does not match the number of parameters in the method.");
        }
        HashMap<String, Schema> properties = new HashMap<String, Schema>();
        ArrayList<String> required = new ArrayList<String>();
        for (int i = 0; i < parameters.length; ++i) {
            String parameterName;
            if (orderedParameterNames.length == 0) {
                if (!parameters[i].isNamePresent()) {
                    throw new IllegalStateException("Failed to retrieve the parameter name from reflection. Please compile your code with the \"-parameters\" flag or provide parameter names manually.");
                }
                parameterName = parameters[i].getName();
            } else {
                parameterName = orderedParameterNames[i];
            }
            properties.put(parameterName, FunctionDeclaration.buildTypeSchema(parameterName, parameters[i].getType()));
            required.add(parameterName);
        }
        parametersBuilder.properties(properties).required(required);
        return FunctionDeclaration.builder().name(method.getName()).description(functionDescription).parameters(parametersBuilder.build()).build();
    }

    private static Schema buildTypeSchema(String parameterName, Class<?> parameterType) {
        Schema.Builder parameterSchemaBuilder = Schema.builder().title(parameterName);
        switch (parameterType.getName()) {
            case "java.lang.String": {
                parameterSchemaBuilder = parameterSchemaBuilder.type("STRING");
                break;
            }
            case "boolean": 
            case "java.lang.Boolean": {
                parameterSchemaBuilder = parameterSchemaBuilder.type("BOOLEAN");
                break;
            }
            case "int": 
            case "java.lang.Integer": 
            case "java.lang.Long": {
                parameterSchemaBuilder = parameterSchemaBuilder.type("INTEGER");
                break;
            }
            case "double": 
            case "java.lang.Double": 
            case "float": 
            case "java.lang.Float": {
                parameterSchemaBuilder = parameterSchemaBuilder.type("NUMBER");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported parameter type " + parameterType.getName() + " for parameter " + parameterName + ". Currently, supported types are String, boolean, Boolean, int, Integer, Long, double, Double, float, Float.");
            }
        }
        return parameterSchemaBuilder.build();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_FunctionDeclaration.Builder();
        }

        @JsonProperty(value="behavior")
        public abstract Builder behavior(Behavior var1);

        @CanIgnoreReturnValue
        public Builder behavior(Behavior.Known knownType) {
            return this.behavior(new Behavior(knownType));
        }

        @CanIgnoreReturnValue
        public Builder behavior(String behavior) {
            return this.behavior(new Behavior(behavior));
        }

        @JsonProperty(value="description")
        public abstract Builder description(String var1);

        @JsonProperty(value="name")
        public abstract Builder name(String var1);

        @JsonProperty(value="parameters")
        public abstract Builder parameters(Schema var1);

        @JsonProperty(value="response")
        public abstract Builder response(Schema var1);

        public abstract FunctionDeclaration build();
    }
}

