/*
 * Decompiled with CFR 0.152.
 */
package com.example.chatmoderator.libs.genai.types;

import com.example.chatmoderator.libs.genai.JsonSerializable;
import com.example.chatmoderator.libs.genai.types.AutoValue_Model;
import com.example.chatmoderator.libs.genai.types.Checkpoint;
import com.example.chatmoderator.libs.genai.types.Endpoint;
import com.example.chatmoderator.libs.genai.types.TunedModelInfo;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class Model
extends JsonSerializable {
    @JsonProperty(value="name")
    public abstract Optional<String> name();

    @JsonProperty(value="displayName")
    public abstract Optional<String> displayName();

    @JsonProperty(value="description")
    public abstract Optional<String> description();

    @JsonProperty(value="version")
    public abstract Optional<String> version();

    @JsonProperty(value="endpoints")
    public abstract Optional<List<Endpoint>> endpoints();

    @JsonProperty(value="labels")
    public abstract Optional<Map<String, String>> labels();

    @JsonProperty(value="tunedModelInfo")
    public abstract Optional<TunedModelInfo> tunedModelInfo();

    @JsonProperty(value="inputTokenLimit")
    public abstract Optional<Integer> inputTokenLimit();

    @JsonProperty(value="outputTokenLimit")
    public abstract Optional<Integer> outputTokenLimit();

    @JsonProperty(value="supportedActions")
    public abstract Optional<List<String>> supportedActions();

    @JsonProperty(value="defaultCheckpointId")
    public abstract Optional<String> defaultCheckpointId();

    @JsonProperty(value="checkpoints")
    public abstract Optional<List<Checkpoint>> checkpoints();

    public static Builder builder() {
        return new AutoValue_Model.Builder();
    }

    public abstract Builder toBuilder();

    public static Model fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, Model.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_Model.Builder();
        }

        @JsonProperty(value="name")
        public abstract Builder name(String var1);

        @JsonProperty(value="displayName")
        public abstract Builder displayName(String var1);

        @JsonProperty(value="description")
        public abstract Builder description(String var1);

        @JsonProperty(value="version")
        public abstract Builder version(String var1);

        @JsonProperty(value="endpoints")
        public abstract Builder endpoints(List<Endpoint> var1);

        @JsonProperty(value="labels")
        public abstract Builder labels(Map<String, String> var1);

        @JsonProperty(value="tunedModelInfo")
        public abstract Builder tunedModelInfo(TunedModelInfo var1);

        @JsonProperty(value="inputTokenLimit")
        public abstract Builder inputTokenLimit(Integer var1);

        @JsonProperty(value="outputTokenLimit")
        public abstract Builder outputTokenLimit(Integer var1);

        @JsonProperty(value="supportedActions")
        public abstract Builder supportedActions(List<String> var1);

        @JsonProperty(value="defaultCheckpointId")
        public abstract Builder defaultCheckpointId(String var1);

        @JsonProperty(value="checkpoints")
        public abstract Builder checkpoints(List<Checkpoint> var1);

        public abstract Model build();
    }
}

