/*
 * Decompiled with CFR 0.152.
 */
package com.example.chatmoderator.libs.googleapi.client.http;

import com.example.chatmoderator.libs.googleapi.client.http.HttpIOExceptionHandler;
import com.example.chatmoderator.libs.googleapi.client.http.HttpRequest;
import com.example.chatmoderator.libs.googleapi.client.util.BackOff;
import com.example.chatmoderator.libs.googleapi.client.util.BackOffUtils;
import com.example.chatmoderator.libs.googleapi.client.util.Beta;
import com.example.chatmoderator.libs.googleapi.client.util.Preconditions;
import com.example.chatmoderator.libs.googleapi.client.util.Sleeper;
import java.io.IOException;

@Beta
public class HttpBackOffIOExceptionHandler
implements HttpIOExceptionHandler {
    private final BackOff backOff;
    private Sleeper sleeper = Sleeper.DEFAULT;

    public HttpBackOffIOExceptionHandler(BackOff backOff) {
        this.backOff = Preconditions.checkNotNull(backOff);
    }

    public final BackOff getBackOff() {
        return this.backOff;
    }

    public final Sleeper getSleeper() {
        return this.sleeper;
    }

    public HttpBackOffIOExceptionHandler setSleeper(Sleeper sleeper) {
        this.sleeper = Preconditions.checkNotNull(sleeper);
        return this;
    }

    @Override
    public boolean handleIOException(HttpRequest request, boolean supportsRetry) throws IOException {
        if (!supportsRetry) {
            return false;
        }
        try {
            return BackOffUtils.next(this.sleeper, this.backOff);
        }
        catch (InterruptedException exception) {
            Thread.currentThread().interrupt();
            return false;
        }
    }
}

