/*
 * Decompiled with CFR 0.152.
 */
package com.example.chatmoderator.libs.googleapi.client.http.json;

import com.example.chatmoderator.libs.googleapi.client.http.AbstractHttpContent;
import com.example.chatmoderator.libs.googleapi.client.http.HttpMediaType;
import com.example.chatmoderator.libs.googleapi.client.json.JsonFactory;
import com.example.chatmoderator.libs.googleapi.client.json.JsonGenerator;
import com.example.chatmoderator.libs.googleapi.client.util.Preconditions;
import java.io.IOException;
import java.io.OutputStream;

public class JsonHttpContent
extends AbstractHttpContent {
    private final Object data;
    private final JsonFactory jsonFactory;
    private String wrapperKey;

    public JsonHttpContent(JsonFactory jsonFactory, Object data) {
        super("application/json; charset=UTF-8");
        this.jsonFactory = Preconditions.checkNotNull(jsonFactory);
        this.data = Preconditions.checkNotNull(data);
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        JsonGenerator generator = this.jsonFactory.createJsonGenerator(out, this.getCharset());
        if (this.wrapperKey != null) {
            generator.writeStartObject();
            generator.writeFieldName(this.wrapperKey);
        }
        generator.serialize(this.data);
        if (this.wrapperKey != null) {
            generator.writeEndObject();
        }
        generator.flush();
    }

    @Override
    public JsonHttpContent setMediaType(HttpMediaType mediaType) {
        super.setMediaType(mediaType);
        return this;
    }

    public final Object getData() {
        return this.data;
    }

    public final JsonFactory getJsonFactory() {
        return this.jsonFactory;
    }

    public final String getWrapperKey() {
        return this.wrapperKey;
    }

    public JsonHttpContent setWrapperKey(String wrapperKey) {
        this.wrapperKey = wrapperKey;
        return this;
    }
}

