/*
 * Decompiled with CFR 0.152.
 */
package com.example.chatmoderator.libs.googleapi.pathtemplate;

import java.util.Stack;

public class ValidationException
extends IllegalArgumentException {
    private static ThreadLocal<Stack<Supplier<String>>> contextLocal = new ThreadLocal();

    public static void pushCurrentThreadValidationContext(Supplier<String> supplier) {
        Stack<Supplier<String>> stack = contextLocal.get();
        if (stack == null) {
            stack = new Stack();
            contextLocal.set(stack);
        }
        stack.push(supplier);
    }

    public static void pushCurrentThreadValidationContext(final String context) {
        ValidationException.pushCurrentThreadValidationContext(new Supplier<String>(){

            @Override
            public String get() {
                return context;
            }
        });
    }

    public static void popCurrentThreadValidationContext() {
        Stack<Supplier<String>> stack = contextLocal.get();
        if (stack != null) {
            stack.pop();
        }
    }

    public ValidationException(String format, Object ... args2) {
        super(ValidationException.message(contextLocal.get(), format, args2));
    }

    private static String message(Stack<Supplier<String>> context, String format, Object ... args2) {
        if (context == null || context.isEmpty()) {
            return String.format(format, args2);
        }
        StringBuilder result = new StringBuilder();
        for (Supplier supplier : context) {
            result.append((String)supplier.get() + ": ");
        }
        return result.toString() + String.format(format, args2);
    }

    @FunctionalInterface
    public static interface Supplier<T> {
        public T get();
    }
}

