/*
 * Decompiled with CFR 0.152.
 */
package com.example.chatmoderator.libs.googleauth.oauth2;

import com.example.chatmoderator.libs.googleapi.client.http.GenericUrl;
import com.example.chatmoderator.libs.googleapi.client.http.HttpContent;
import com.example.chatmoderator.libs.googleapi.client.http.HttpHeaders;
import com.example.chatmoderator.libs.googleapi.client.http.HttpRequest;
import com.example.chatmoderator.libs.googleapi.client.http.HttpRequestFactory;
import com.example.chatmoderator.libs.googleapi.client.http.HttpResponse;
import com.example.chatmoderator.libs.googleapi.client.json.GenericJson;
import com.example.chatmoderator.libs.googleapi.client.json.JsonParser;
import com.example.chatmoderator.libs.googleauth.http.HttpTransportFactory;
import com.example.chatmoderator.libs.googleauth.oauth2.AwsCredentialSource;
import com.example.chatmoderator.libs.googleauth.oauth2.AwsSecurityCredentials;
import com.example.chatmoderator.libs.googleauth.oauth2.AwsSecurityCredentialsSupplier;
import com.example.chatmoderator.libs.googleauth.oauth2.EnvironmentProvider;
import com.example.chatmoderator.libs.googleauth.oauth2.ExternalAccountSupplierContext;
import com.example.chatmoderator.libs.googleauth.oauth2.OAuth2Utils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

class InternalAwsSecurityCredentialsSupplier
implements AwsSecurityCredentialsSupplier {
    private static final long serialVersionUID = 4438370785261365013L;
    static final String AWS_REGION = "AWS_REGION";
    static final String AWS_DEFAULT_REGION = "AWS_DEFAULT_REGION";
    static final String AWS_ACCESS_KEY_ID = "AWS_ACCESS_KEY_ID";
    static final String AWS_SECRET_ACCESS_KEY = "AWS_SECRET_ACCESS_KEY";
    static final String AWS_SESSION_TOKEN = "AWS_SESSION_TOKEN";
    static final String AWS_IMDSV2_SESSION_TOKEN_HEADER = "x-aws-ec2-metadata-token";
    static final String AWS_IMDSV2_SESSION_TOKEN_TTL_HEADER = "x-aws-ec2-metadata-token-ttl-seconds";
    static final String AWS_IMDSV2_SESSION_TOKEN_TTL = "300";
    private final AwsCredentialSource awsCredentialSource;
    private EnvironmentProvider environmentProvider;
    private transient HttpTransportFactory transportFactory;

    InternalAwsSecurityCredentialsSupplier(AwsCredentialSource awsCredentialSource, EnvironmentProvider environmentProvider, HttpTransportFactory transportFactory) {
        this.environmentProvider = environmentProvider;
        this.awsCredentialSource = awsCredentialSource;
        this.transportFactory = transportFactory;
    }

    @Override
    public AwsSecurityCredentials getCredentials(ExternalAccountSupplierContext context) throws IOException {
        if (this.canRetrieveSecurityCredentialsFromEnvironment()) {
            String accessKeyId = this.environmentProvider.getEnv(AWS_ACCESS_KEY_ID);
            String secretAccessKey = this.environmentProvider.getEnv(AWS_SECRET_ACCESS_KEY);
            String token = this.environmentProvider.getEnv(AWS_SESSION_TOKEN);
            return new AwsSecurityCredentials(accessKeyId, secretAccessKey, token);
        }
        Map<String, Object> metadataRequestHeaders = this.createMetadataRequestHeaders(this.awsCredentialSource);
        if (this.awsCredentialSource.url == null || this.awsCredentialSource.url.isEmpty()) {
            throw new IOException("Unable to determine the AWS IAM role name. The credential source does not contain the url field.");
        }
        String roleName = this.retrieveResource(this.awsCredentialSource.url, "IAM role", metadataRequestHeaders);
        String awsCredentials = this.retrieveResource(this.awsCredentialSource.url + "/" + roleName, "credentials", metadataRequestHeaders);
        JsonParser parser = OAuth2Utils.JSON_FACTORY.createJsonParser(awsCredentials);
        GenericJson genericJson = parser.parseAndClose(GenericJson.class);
        String accessKeyId = (String)genericJson.get("AccessKeyId");
        String secretAccessKey = (String)genericJson.get("SecretAccessKey");
        String token = (String)genericJson.get("Token");
        return new AwsSecurityCredentials(accessKeyId, secretAccessKey, token);
    }

    @Override
    public String getRegion(ExternalAccountSupplierContext context) throws IOException {
        if (this.canRetrieveRegionFromEnvironment()) {
            String region = this.environmentProvider.getEnv(AWS_REGION);
            if (region != null && region.trim().length() > 0) {
                return region;
            }
            return this.environmentProvider.getEnv(AWS_DEFAULT_REGION);
        }
        Map<String, Object> metadataRequestHeaders = this.createMetadataRequestHeaders(this.awsCredentialSource);
        if (this.awsCredentialSource.regionUrl == null || this.awsCredentialSource.regionUrl.isEmpty()) {
            throw new IOException("Unable to determine the AWS region. The credential source does not contain the region URL.");
        }
        String region = this.retrieveResource(this.awsCredentialSource.regionUrl, "region", metadataRequestHeaders);
        return region.substring(0, region.length() - 1);
    }

    private boolean canRetrieveRegionFromEnvironment() {
        ImmutableList<String> keys2 = ImmutableList.of(AWS_REGION, AWS_DEFAULT_REGION);
        for (String env : keys2) {
            String value = this.environmentProvider.getEnv(env);
            if (value == null || value.trim().length() <= 0) continue;
            return true;
        }
        return false;
    }

    private boolean canRetrieveSecurityCredentialsFromEnvironment() {
        ImmutableList<String> keys2 = ImmutableList.of(AWS_ACCESS_KEY_ID, AWS_SECRET_ACCESS_KEY);
        for (String env : keys2) {
            String value = this.environmentProvider.getEnv(env);
            if (value != null && value.trim().length() != 0) continue;
            return false;
        }
        return true;
    }

    @VisibleForTesting
    boolean shouldUseMetadataServer() {
        return !this.canRetrieveRegionFromEnvironment() || !this.canRetrieveSecurityCredentialsFromEnvironment();
    }

    private String retrieveResource(String url, String resourceName, Map<String, Object> headers) throws IOException {
        return this.retrieveResource(url, resourceName, "GET", headers, null);
    }

    private String retrieveResource(String url, String resourceName, String requestMethod, Map<String, Object> headers, @Nullable HttpContent content) throws IOException {
        try {
            HttpRequestFactory requestFactory = this.transportFactory.create().createRequestFactory();
            HttpRequest request = requestFactory.buildRequest(requestMethod, new GenericUrl(url), content);
            HttpHeaders requestHeaders = request.getHeaders();
            for (Map.Entry<String, Object> header : headers.entrySet()) {
                requestHeaders.set(header.getKey(), header.getValue());
            }
            HttpResponse response = request.execute();
            return response.parseAsString();
        }
        catch (IOException e) {
            throw new IOException(String.format("Failed to retrieve AWS %s.", resourceName), e);
        }
    }

    @VisibleForTesting
    Map<String, Object> createMetadataRequestHeaders(AwsCredentialSource awsCredentialSource) throws IOException {
        HashMap<String, Object> metadataRequestHeaders = new HashMap<String, Object>();
        if (awsCredentialSource.imdsv2SessionTokenUrl != null) {
            HashMap<String, Object> tokenRequestHeaders = new HashMap<String, Object>(){
                {
                    this.put(InternalAwsSecurityCredentialsSupplier.AWS_IMDSV2_SESSION_TOKEN_TTL_HEADER, InternalAwsSecurityCredentialsSupplier.AWS_IMDSV2_SESSION_TOKEN_TTL);
                }
            };
            String imdsv2SessionToken = this.retrieveResource(awsCredentialSource.imdsv2SessionTokenUrl, "Session Token", "PUT", (Map<String, Object>)tokenRequestHeaders, null);
            metadataRequestHeaders.put(AWS_IMDSV2_SESSION_TOKEN_HEADER, imdsv2SessionToken);
        }
        return metadataRequestHeaders;
    }
}

