/*
 * Decompiled with CFR 0.152.
 */
package com.example.chatmoderator.libs.googleauth.oauth2;

import com.example.chatmoderator.libs.googleapi.client.http.HttpHeaders;
import com.example.chatmoderator.libs.googleapi.client.http.HttpTransport;
import com.example.chatmoderator.libs.googleapi.client.http.javanet.NetHttpTransport;
import com.example.chatmoderator.libs.googleapi.client.json.GenericJson;
import com.example.chatmoderator.libs.googleapi.client.json.JsonFactory;
import com.example.chatmoderator.libs.googleapi.client.json.JsonObjectParser;
import com.example.chatmoderator.libs.googleapi.client.json.gson.GsonFactory;
import com.example.chatmoderator.libs.googleapi.client.util.PemReader;
import com.example.chatmoderator.libs.googleapi.client.util.SecurityUtils;
import com.example.chatmoderator.libs.googleauth.http.HttpTransportFactory;
import com.google.common.base.Strings;
import com.google.common.io.BaseEncoding;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class OAuth2Utils {
    static final String SIGNATURE_ALGORITHM = "SHA256withRSA";
    static final String TOKEN_TYPE_ACCESS_TOKEN = "urn:ietf:params:oauth:token-type:access_token";
    static final String TOKEN_TYPE_TOKEN_EXCHANGE = "urn:ietf:params:oauth:token-type:token-exchange";
    static final String GRANT_TYPE_JWT_BEARER = "urn:ietf:params:oauth:grant-type:jwt-bearer";
    static final String IAM_ID_TOKEN_ENDPOINT_FORMAT = "https://iamcredentials.%s/v1/projects/-/serviceAccounts/%s:generateIdToken";
    static final String IAM_ACCESS_TOKEN_ENDPOINT_FORMAT = "https://iamcredentials.%s/v1/projects/-/serviceAccounts/%s:generateAccessToken";
    static final String SIGN_BLOB_ENDPOINT_FORMAT = "https://iamcredentials.%s/v1/projects/-/serviceAccounts/%s:signBlob";
    static final URI TOKEN_SERVER_URI = URI.create("https://oauth2.googleapis.com/token");
    static final URI TOKEN_REVOKE_URI = URI.create("https://oauth2.googleapis.com/revoke");
    static final URI USER_AUTH_URI = URI.create("https://accounts.google.com/o/oauth2/auth");
    static final HttpTransport HTTP_TRANSPORT = new NetHttpTransport();
    static final HttpTransportFactory HTTP_TRANSPORT_FACTORY = new DefaultHttpTransportFactory();
    static final JsonFactory JSON_FACTORY = GsonFactory.getDefaultInstance();
    private static String VALUE_NOT_FOUND_MESSAGE = "%sExpected value %s not found.";
    private static String VALUE_WRONG_TYPE_MESSAGE = "%sExpected %s value %s of wrong type.";
    static final String BEARER_PREFIX = "Bearer ";
    static final String TOKEN_RESPONSE_SCOPE = "scope";
    static final int INITIAL_RETRY_INTERVAL_MILLIS = 1000;
    static final double RETRY_RANDOMIZATION_FACTOR = 0.1;
    static final double RETRY_MULTIPLIER = 2.0;
    static final int DEFAULT_NUMBER_OF_RETRIES = 3;
    public static final Set<Integer> TOKEN_ENDPOINT_RETRYABLE_STATUS_CODES = new HashSet<Integer>(Arrays.asList(500, 503, 408, 429));

    static boolean headersContainValue(HttpHeaders headers, String headerName, String value) {
        Object values2 = headers.get(headerName);
        if (values2 instanceof Collection) {
            Collection valuesCollection = (Collection)values2;
            return valuesCollection.contains(value);
        }
        return false;
    }

    static GenericJson parseJson(String json) throws IOException {
        JsonObjectParser parser = new JsonObjectParser(JSON_FACTORY);
        ByteArrayInputStream stateStream = new ByteArrayInputStream(json.getBytes(StandardCharsets.UTF_8));
        GenericJson stateJson = parser.parseAndClose((InputStream)stateStream, StandardCharsets.UTF_8, GenericJson.class);
        return stateJson;
    }

    static String validateString(Map<String, Object> map, String key, String errorPrefix) throws IOException {
        Object value = map.get(key);
        if (value == null) {
            throw new IOException(String.format(VALUE_NOT_FOUND_MESSAGE, errorPrefix, key));
        }
        if (!(value instanceof String)) {
            throw new IOException(String.format(VALUE_WRONG_TYPE_MESSAGE, errorPrefix, "string", key));
        }
        return (String)value;
    }

    static void writeInputStreamToFile(InputStream credentials, String filePath) throws IOException {
        try (FileOutputStream outputStream2 = new FileOutputStream(new File(filePath));){
            ByteStreams.copy(credentials, outputStream2);
        }
    }

    static String validateOptionalString(Map<String, Object> map, String key, String errorPrefix) throws IOException {
        Object value = map.get(key);
        if (value == null) {
            return null;
        }
        if (!(value instanceof String)) {
            throw new IOException(String.format(VALUE_WRONG_TYPE_MESSAGE, errorPrefix, "string", key));
        }
        return (String)value;
    }

    static List<String> validateOptionalListString(Map<String, Object> map, String key, String errorPrefix) throws IOException {
        Object value = map.get(key);
        if (value == null) {
            return null;
        }
        if (!(value instanceof List)) {
            throw new IOException(String.format(VALUE_WRONG_TYPE_MESSAGE, errorPrefix, "List<String>", key));
        }
        return (List)value;
    }

    static int validateInt32(Map<String, Object> map, String key, String errorPrefix) throws IOException {
        Object value = map.get(key);
        if (value == null) {
            throw new IOException(String.format(VALUE_NOT_FOUND_MESSAGE, errorPrefix, key));
        }
        if (value instanceof BigDecimal) {
            BigDecimal bigDecimalValue = (BigDecimal)value;
            return bigDecimalValue.intValueExact();
        }
        if (!(value instanceof Integer)) {
            throw new IOException(String.format(VALUE_WRONG_TYPE_MESSAGE, errorPrefix, "integer", key));
        }
        return (Integer)value;
    }

    static long validateLong(Map<String, Object> map, String key, String errorPrefix) throws IOException {
        Object value = map.get(key);
        if (value == null) {
            throw new IOException(String.format(VALUE_NOT_FOUND_MESSAGE, errorPrefix, key));
        }
        if (value instanceof BigDecimal) {
            BigDecimal bigDecimalValue = (BigDecimal)value;
            return bigDecimalValue.longValueExact();
        }
        if (!(value instanceof Long)) {
            throw new IOException(String.format(VALUE_WRONG_TYPE_MESSAGE, errorPrefix, "long", key));
        }
        return (Long)value;
    }

    static Map<String, Object> validateMap(Map<String, Object> map, String key, String errorPrefix) throws IOException {
        Object value = map.get(key);
        if (value == null) {
            throw new IOException(String.format(VALUE_NOT_FOUND_MESSAGE, errorPrefix, key));
        }
        if (!(value instanceof Map)) {
            throw new IOException(String.format(VALUE_WRONG_TYPE_MESSAGE, errorPrefix, "Map", key));
        }
        return (Map)value;
    }

    static PrivateKey privateKeyFromPkcs8(String privateKeyPkcs8) throws IOException {
        StringReader reader = new StringReader(privateKeyPkcs8);
        PemReader.Section section = PemReader.readFirstSectionAndClose(reader, "PRIVATE KEY");
        if (section == null) {
            throw new IOException("Invalid PKCS#8 data.");
        }
        byte[] bytes = section.getBase64DecodedBytes();
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(bytes);
        try {
            KeyFactory keyFactory = SecurityUtils.getRsaKeyFactory();
            return keyFactory.generatePrivate(keySpec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException exception) {
            GeneralSecurityException unexpectedException = exception;
            throw new IOException("Unexpected exception reading PKCS#8 data", unexpectedException);
        }
    }

    static String generateBasicAuthHeader(String username, String password) {
        if (Strings.isNullOrEmpty(username) || Strings.isNullOrEmpty(password)) {
            throw new IllegalArgumentException("Username and password cannot be null or empty.");
        }
        String credentials = username + ":" + password;
        String encodedCredentials = BaseEncoding.base64().encode(credentials.getBytes());
        return "Basic " + encodedCredentials;
    }

    private OAuth2Utils() {
    }

    static class DefaultHttpTransportFactory
    implements HttpTransportFactory {
        DefaultHttpTransportFactory() {
        }

        @Override
        public HttpTransport create() {
            return HTTP_TRANSPORT;
        }
    }
}

