/*
 * Decompiled with CFR 0.152.
 */
package com.example.chatmoderator.libs.googleauth.oauth2;

import com.example.chatmoderator.libs.googleauth.http.HttpTransportFactory;
import com.example.chatmoderator.libs.googleauth.oauth2.AccessToken;
import com.example.chatmoderator.libs.googleauth.oauth2.EnvironmentProvider;
import com.example.chatmoderator.libs.googleauth.oauth2.ExecutableHandler;
import com.example.chatmoderator.libs.googleauth.oauth2.ExternalAccountCredentials;
import com.example.chatmoderator.libs.googleauth.oauth2.PluggableAuthCredentialSource;
import com.example.chatmoderator.libs.googleauth.oauth2.PluggableAuthHandler;
import com.example.chatmoderator.libs.googleauth.oauth2.StsTokenExchangeRequest;
import com.google.common.annotations.VisibleForTesting;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public class PluggableAuthCredentials
extends ExternalAccountCredentials {
    static final String PLUGGABLE_AUTH_METRICS_HEADER_VALUE = "executable";
    private final PluggableAuthCredentialSource config;
    private final ExecutableHandler handler;

    PluggableAuthCredentials(Builder builder) {
        super(builder);
        this.config = (PluggableAuthCredentialSource)builder.credentialSource;
        this.handler = builder.handler != null ? builder.handler : new PluggableAuthHandler(this.getEnvironmentProvider());
    }

    @Override
    public AccessToken refreshAccessToken() throws IOException {
        String credential = this.retrieveSubjectToken();
        StsTokenExchangeRequest.Builder stsTokenExchangeRequest = StsTokenExchangeRequest.newBuilder(credential, this.getSubjectTokenType()).setAudience(this.getAudience());
        Collection<String> scopes = this.getScopes();
        if (scopes != null && !scopes.isEmpty()) {
            stsTokenExchangeRequest.setScopes(new ArrayList<String>(scopes));
        }
        return this.exchangeExternalCredentialForAccessToken(stsTokenExchangeRequest.build());
    }

    @Override
    public String retrieveSubjectToken() throws IOException {
        final String executableCommand = this.config.getCommand();
        final String outputFilePath = this.config.getOutputFilePath();
        final int executableTimeoutMs = this.config.getTimeoutMs();
        final HashMap<String, String> envMap = new HashMap<String, String>();
        envMap.put("GOOGLE_EXTERNAL_ACCOUNT_AUDIENCE", this.getAudience());
        envMap.put("GOOGLE_EXTERNAL_ACCOUNT_TOKEN_TYPE", this.getSubjectTokenType());
        envMap.put("GOOGLE_EXTERNAL_ACCOUNT_INTERACTIVE", "0");
        if (this.getServiceAccountEmail() != null) {
            envMap.put("GOOGLE_EXTERNAL_ACCOUNT_IMPERSONATED_EMAIL", this.getServiceAccountEmail());
        }
        if (outputFilePath != null && !outputFilePath.isEmpty()) {
            envMap.put("GOOGLE_EXTERNAL_ACCOUNT_OUTPUT_FILE", outputFilePath);
        }
        ExecutableHandler.ExecutableOptions options = new ExecutableHandler.ExecutableOptions(){

            @Override
            public String getExecutableCommand() {
                return executableCommand;
            }

            @Override
            public Map<String, String> getEnvironmentMap() {
                return envMap;
            }

            @Override
            public int getExecutableTimeoutMs() {
                return executableTimeoutMs;
            }

            @Override
            @Nullable
            public String getOutputFilePath() {
                return outputFilePath;
            }
        };
        return this.handler.retrieveTokenFromExecutable(options);
    }

    @Override
    public PluggableAuthCredentials createScoped(Collection<String> newScopes) {
        return new PluggableAuthCredentials((Builder)PluggableAuthCredentials.newBuilder(this).setScopes((Collection)newScopes));
    }

    @Override
    String getCredentialSourceType() {
        return PLUGGABLE_AUTH_METRICS_HEADER_VALUE;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(PluggableAuthCredentials pluggableAuthCredentials) {
        return new Builder(pluggableAuthCredentials);
    }

    @Nullable
    @VisibleForTesting
    ExecutableHandler getExecutableHandler() {
        return this.handler;
    }

    public static class Builder
    extends ExternalAccountCredentials.Builder {
        private ExecutableHandler handler;

        Builder() {
        }

        Builder(PluggableAuthCredentials credentials) {
            super(credentials);
            this.handler = credentials.handler;
        }

        @CanIgnoreReturnValue
        public Builder setExecutableHandler(ExecutableHandler handler) {
            this.handler = handler;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder setHttpTransportFactory(HttpTransportFactory transportFactory) {
            super.setHttpTransportFactory(transportFactory);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder setAudience(String audience) {
            super.setAudience(audience);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder setSubjectTokenType(String subjectTokenType) {
            super.setSubjectTokenType(subjectTokenType);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder setSubjectTokenType(ExternalAccountCredentials.SubjectTokenTypes subjectTokenType) {
            super.setSubjectTokenType(subjectTokenType);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder setTokenUrl(String tokenUrl) {
            super.setTokenUrl(tokenUrl);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setCredentialSource(PluggableAuthCredentialSource credentialSource) {
            super.setCredentialSource(credentialSource);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder setServiceAccountImpersonationUrl(String serviceAccountImpersonationUrl) {
            super.setServiceAccountImpersonationUrl(serviceAccountImpersonationUrl);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder setTokenInfoUrl(String tokenInfoUrl) {
            super.setTokenInfoUrl(tokenInfoUrl);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder setQuotaProjectId(String quotaProjectId) {
            super.setQuotaProjectId(quotaProjectId);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder setClientId(String clientId) {
            super.setClientId(clientId);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder setClientSecret(String clientSecret) {
            super.setClientSecret(clientSecret);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder setScopes(Collection<String> scopes) {
            super.setScopes(scopes);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder setWorkforcePoolUserProject(String workforcePoolUserProject) {
            super.setWorkforcePoolUserProject(workforcePoolUserProject);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder setServiceAccountImpersonationOptions(Map<String, Object> optionsMap) {
            super.setServiceAccountImpersonationOptions(optionsMap);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder setUniverseDomain(String universeDomain) {
            super.setUniverseDomain(universeDomain);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        Builder setEnvironmentProvider(EnvironmentProvider environmentProvider) {
            super.setEnvironmentProvider(environmentProvider);
            return this;
        }

        @Override
        public PluggableAuthCredentials build() {
            return new PluggableAuthCredentials(this);
        }
    }
}

