/*
 * Decompiled with CFR 0.152.
 */
package com.example.chatmoderator.libs.grpc;

import com.example.chatmoderator.libs.grpc.CallbackMetricInstrument;
import com.example.chatmoderator.libs.grpc.DoubleCounterMetricInstrument;
import com.example.chatmoderator.libs.grpc.DoubleHistogramMetricInstrument;
import com.example.chatmoderator.libs.grpc.Internal;
import com.example.chatmoderator.libs.grpc.LongCounterMetricInstrument;
import com.example.chatmoderator.libs.grpc.LongGaugeMetricInstrument;
import com.example.chatmoderator.libs.grpc.LongHistogramMetricInstrument;
import com.google.common.base.Preconditions;
import java.util.List;

@Internal
public interface MetricRecorder {
    default public void addDoubleCounter(DoubleCounterMetricInstrument metricInstrument, double value, List<String> requiredLabelValues, List<String> optionalLabelValues) {
        Preconditions.checkArgument(requiredLabelValues != null && requiredLabelValues.size() == metricInstrument.getRequiredLabelKeys().size(), "Incorrect number of required labels provided. Expected: %s", metricInstrument.getRequiredLabelKeys().size());
        Preconditions.checkArgument(optionalLabelValues != null && optionalLabelValues.size() == metricInstrument.getOptionalLabelKeys().size(), "Incorrect number of optional labels provided. Expected: %s", metricInstrument.getOptionalLabelKeys().size());
    }

    default public void addLongCounter(LongCounterMetricInstrument metricInstrument, long value, List<String> requiredLabelValues, List<String> optionalLabelValues) {
        Preconditions.checkArgument(requiredLabelValues != null && requiredLabelValues.size() == metricInstrument.getRequiredLabelKeys().size(), "Incorrect number of required labels provided. Expected: %s", metricInstrument.getRequiredLabelKeys().size());
        Preconditions.checkArgument(optionalLabelValues != null && optionalLabelValues.size() == metricInstrument.getOptionalLabelKeys().size(), "Incorrect number of optional labels provided. Expected: %s", metricInstrument.getOptionalLabelKeys().size());
    }

    default public void recordDoubleHistogram(DoubleHistogramMetricInstrument metricInstrument, double value, List<String> requiredLabelValues, List<String> optionalLabelValues) {
        Preconditions.checkArgument(requiredLabelValues != null && requiredLabelValues.size() == metricInstrument.getRequiredLabelKeys().size(), "Incorrect number of required labels provided. Expected: %s", metricInstrument.getRequiredLabelKeys().size());
        Preconditions.checkArgument(optionalLabelValues != null && optionalLabelValues.size() == metricInstrument.getOptionalLabelKeys().size(), "Incorrect number of optional labels provided. Expected: %s", metricInstrument.getOptionalLabelKeys().size());
    }

    default public void recordLongHistogram(LongHistogramMetricInstrument metricInstrument, long value, List<String> requiredLabelValues, List<String> optionalLabelValues) {
        Preconditions.checkArgument(requiredLabelValues != null && requiredLabelValues.size() == metricInstrument.getRequiredLabelKeys().size(), "Incorrect number of required labels provided. Expected: %s", metricInstrument.getRequiredLabelKeys().size());
        Preconditions.checkArgument(optionalLabelValues != null && optionalLabelValues.size() == metricInstrument.getOptionalLabelKeys().size(), "Incorrect number of optional labels provided. Expected: %s", metricInstrument.getOptionalLabelKeys().size());
    }

    default public Registration registerBatchCallback(BatchCallback callback, CallbackMetricInstrument ... metricInstruments) {
        return () -> {};
    }

    public static interface Registration
    extends AutoCloseable {
        @Override
        public void close();
    }

    public static interface BatchRecorder {
        default public void recordLongGauge(LongGaugeMetricInstrument metricInstrument, long value, List<String> requiredLabelValues, List<String> optionalLabelValues) {
            Preconditions.checkArgument(requiredLabelValues != null && requiredLabelValues.size() == metricInstrument.getRequiredLabelKeys().size(), "Incorrect number of required labels provided. Expected: %s", metricInstrument.getRequiredLabelKeys().size());
            Preconditions.checkArgument(optionalLabelValues != null && optionalLabelValues.size() == metricInstrument.getOptionalLabelKeys().size(), "Incorrect number of optional labels provided. Expected: %s", metricInstrument.getOptionalLabelKeys().size());
        }
    }

    public static interface BatchCallback {
        public void accept(BatchRecorder var1);
    }
}

