/*
 * Decompiled with CFR 0.152.
 */
package com.example.chatmoderator.listeners;

import com.example.chatmoderator.ChatModeratorPlugin;
import com.example.chatmoderator.config.ConfigManager;
import com.example.chatmoderator.services.ModerationService;
import com.example.chatmoderator.utils.SchedulerUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;

public class ChatListener
implements Listener {
    private final ChatModeratorPlugin plugin;
    private final ConfigManager configManager;
    private final ModerationService moderationService;
    private final Map<Player, Long> mutedPlayers = new ConcurrentHashMap<Player, Long>();

    public ChatListener(ChatModeratorPlugin plugin) {
        this.plugin = plugin;
        this.configManager = plugin.getConfigManager();
        this.moderationService = plugin.getModerationService();
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onChat(AsyncPlayerChatEvent event) {
        if (this.configManager.isDebugEnabled() && this.configManager.shouldLogAllMessages()) {
            Bukkit.getLogger().info("[DEBUG] Chat message from " + event.getPlayer().getName() + ": " + event.getMessage());
        }
        if (event.isCancelled() && this.configManager.isDebugEnabled()) {
            Bukkit.getLogger().info("[DEBUG] Chat message from " + event.getPlayer().getName() + " was blocked.");
        }
        if (this.isMuted(event.getPlayer()) && this.configManager.isDebugEnabled()) {
            Bukkit.getLogger().info("[DEBUG] Muted player " + event.getPlayer().getName() + " attempted to send a message.");
        }
        if (this.configManager.isDebugEnabled()) {
            Bukkit.getLogger().info("[DEBUG] Current muted players: " + String.valueOf(this.mutedPlayers.keySet()));
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        String message = event.getMessage();
        if (this.isMuted(player)) {
            event.setCancelled(true);
            player.sendMessage(String.valueOf(ChatColor.RED) + "You are temporarily muted!");
            return;
        }
        if (this.configManager.isWordFilterEnabled()) {
            for (String word : this.configManager.getBlockedWords()) {
                if (!message.toLowerCase().contains(word.toLowerCase())) continue;
                event.setCancelled(true);
                this.blockMessageAndBroadcast(player, message, "Contains blocked word: " + word);
                return;
            }
        }
        if (player.hasPermission("chatmoderator.bypass")) {
            event.setCancelled(false);
            return;
        }
        if (this.configManager.isAIModerationEnabled()) {
            this.moderationService.checkAIModerationAsync(message).thenAccept(moderationResult -> {
                if (moderationResult.isBlocked()) {
                    SchedulerUtil.runGlobal(() -> {
                        event.setCancelled(true);
                        this.blockMessageAndBroadcast(player, message, moderationResult.getReason());
                    });
                }
            });
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerCommand(PlayerCommandPreprocessEvent event) {
        Player player = event.getPlayer();
        if (!this.isMuted(player)) {
            return;
        }
        String msg = event.getMessage().toLowerCase();
        if (msg.startsWith("/msg ") || msg.startsWith("/tell ") || msg.startsWith("/w ") || msg.startsWith("/whisper ") || msg.startsWith("/pm ")) {
            event.setCancelled(true);
            player.sendMessage(String.valueOf(ChatColor.RED) + "You are muted and cannot send private messages.");
        }
    }

    private void blockMessageAndBroadcast(Player player, String message, String reason) {
        String broadcastMsg = String.valueOf(ChatColor.RED) + "[MODERATION] " + player.getName() + " has been muted for: " + reason + "\n" + String.valueOf(ChatColor.YELLOW) + "Blocked message: " + message;
        for (Player p : Bukkit.getOnlinePlayers()) {
            p.sendMessage(broadcastMsg);
        }
        int muteDurationSeconds = this.configManager.getMuteDurationSeconds();
        this.mutedPlayers.put(player, System.currentTimeMillis() + (long)muteDurationSeconds * 1000L);
        if (this.configManager.shouldWarnPlayer()) {
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.configManager.getViolationWarning()));
        }
        if (this.configManager.shouldLogViolations()) {
            this.plugin.getLogger().warning("Chat violation by " + player.getName() + " | Reason: " + reason + " | Message: " + message);
        }
    }

    public boolean isMuted(Player player) {
        if (!this.mutedPlayers.containsKey(player)) {
            return false;
        }
        long unmuteTime = this.mutedPlayers.get(player);
        if (System.currentTimeMillis() >= unmuteTime) {
            this.mutedPlayers.remove(player);
            return false;
        }
        return true;
    }

    public void unmutePlayer(Player player) {
        if (this.mutedPlayers.containsKey(player)) {
            this.mutedPlayers.remove(player);
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "You have been unmuted by an admin.");
        } else {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You were not muted.");
        }
    }

    public Map<Player, Long> getMutedPlayers() {
        return this.mutedPlayers;
    }
}

