/*
 * Decompiled with CFR 0.152.
 */
package com.example.chatmoderator.services;

import com.example.chatmoderator.ChatModeratorPlugin;
import com.example.chatmoderator.config.ConfigManager;
import com.example.chatmoderator.libs.genai.Client;
import com.example.chatmoderator.libs.genai.types.GenerateContentResponse;
import com.example.chatmoderator.utils.ModerationResult;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;

public class ModerationService {
    private final ChatModeratorPlugin plugin;
    private final ConfigManager configManager;
    private final Client geminiClient;

    public ModerationService(ChatModeratorPlugin plugin, ConfigManager configManager) {
        String apiKey;
        this.plugin = plugin;
        this.configManager = configManager;
        this.geminiClient = "gemini".equalsIgnoreCase(configManager.getPreferredAIProvider()) ? ((apiKey = configManager.getGeminiApiKey()) != null && !apiKey.equals("your-gemini-api-key-here") ? new Client() : null) : null;
    }

    public CompletableFuture<ModerationResult> checkAIModerationAsync(String message) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                if (this.geminiClient != null) {
                    String prompt = "Classify this chat message for moderation.\n\nMessage: \"" + message + "\"\n\nRespond with only ONE label: SAFE, HATE, SEXUAL, VIOLENCE, SELF_HARM.";
                    GenerateContentResponse response = this.geminiClient.models.generateContent(this.configManager.getGeminiModel(), prompt, null);
                    if (response != null && response.text() != null) {
                        String result;
                        switch (result = response.text().trim().toUpperCase(Locale.ROOT)) {
                            case "SAFE": {
                                return ModerationResult.safe();
                            }
                            case "HATE": 
                            case "SEXUAL": 
                            case "VIOLENCE": 
                            case "SELF_HARM": {
                                return ModerationResult.block("AI flagged: " + result);
                            }
                        }
                    }
                }
                return this.checkAIRules(message);
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.SEVERE, "AI moderation failed", e);
                return this.checkAIRules(message);
            }
        });
    }

    private ModerationResult checkAIRules(String message) {
        String lower = message.toLowerCase(Locale.ROOT);
        if (lower.contains("hate") || lower.contains("kys") || lower.contains("nigger") || lower.contains("faggot") || lower.contains("negro") || lower.equalsIgnoreCase("Kill yourself") || lower.contains("gfys") || lower.contains("nga") || lower.contains("nigga") || lower.contains("ngr") || lower.contains("retard") || lower.contains("fag") || lower.contains("sped")) {
            return ModerationResult.block("Rule: violence/self-harm/hate-speech keyword/keyphrase detected");
        }
        if (lower.contains("sex") || lower.contains("rape") || lower.equalsIgnoreCase("I'm horny") || lower.contains("horny") || lower.contains("nude") || lower.contains("naked") || lower.equalsIgnoreCase("I'm gonna rape you") || lower.equalsIgnoreCase("I'm going to goon") || lower.contains("goon") || lower.contains("blowjob") || lower.equalsIgnoreCase("I'm gonna blow you") || lower.contains("cum") || lower.equalsIgnoreCase("I'm cumming") || lower.equalsIgnoreCase("fuck me in the ass") || lower.equalsIgnoreCase("goon me") || lower.equalsIgnoreCase("fiddle with me") || lower.equalsIgnoreCase("twirl my pubes") || lower.contains("pubes") || lower.equalsIgnoreCase("blow me")) {
            return ModerationResult.block("Rule: sexual content keyword/keyphrase detected");
        }
        return ModerationResult.safe();
    }
}

