/*
 * Decompiled with CFR 0.152.
 */
package com.google.auto.value.processor;

import com.google.auto.value.processor.TypeMirrorSet;
import java.util.List;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.IntersectionType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.SimpleTypeVisitor8;

final class MissingTypes {
    private static final MissingTypeVisitor MISSING_TYPE_VISITOR = new MissingTypeVisitor();

    private MissingTypes() {
    }

    static void deferIfMissingTypesIn(ExecutableElement method) {
        MISSING_TYPE_VISITOR.check(method.getReturnType());
        for (VariableElement variableElement : method.getParameters()) {
            MISSING_TYPE_VISITOR.check(variableElement.asType());
        }
    }

    private static class MissingTypeVisitor
    extends SimpleTypeVisitor8<Void, TypeMirrorSet> {
        private MissingTypeVisitor() {
        }

        void check(TypeMirror type) {
            type.accept(this, new TypeMirrorSet());
        }

        @Override
        public Void visitError(ErrorType t2, TypeMirrorSet visiting) {
            throw new MissingTypeException(t2);
        }

        @Override
        public Void visitArray(ArrayType t2, TypeMirrorSet visiting) {
            return t2.getComponentType().accept(this, visiting);
        }

        @Override
        public Void visitDeclared(DeclaredType t2, TypeMirrorSet visiting) {
            if (visiting.add(t2)) {
                this.visitAll(t2.getTypeArguments(), visiting);
            }
            return null;
        }

        @Override
        public Void visitTypeVariable(TypeVariable t2, TypeMirrorSet visiting) {
            if (visiting.add(t2)) {
                t2.getLowerBound().accept(this, visiting);
                t2.getUpperBound().accept(this, visiting);
            }
            return null;
        }

        @Override
        public Void visitWildcard(WildcardType t2, TypeMirrorSet visiting) {
            if (t2.getSuperBound() != null) {
                t2.getSuperBound().accept(this, visiting);
            }
            if (t2.getExtendsBound() != null) {
                t2.getExtendsBound().accept(this, visiting);
            }
            return null;
        }

        @Override
        public Void visitIntersection(IntersectionType t2, TypeMirrorSet visiting) {
            return this.visitAll(t2.getBounds(), visiting);
        }

        private Void visitAll(List<? extends TypeMirror> types, TypeMirrorSet visiting) {
            for (TypeMirror typeMirror : types) {
                typeMirror.accept(this, visiting);
            }
            return null;
        }
    }

    static class MissingTypeException
    extends RuntimeException {
        MissingTypeException(ErrorType missingType) {
            super(missingType == null ? "" : missingType.toString());
        }
    }
}

