/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.internal;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public final class Utils {
    private Utils() {
    }

    public static void checkArgument(boolean isValid, @Nullable Object errorMessage) {
        if (!isValid) {
            throw new IllegalArgumentException(String.valueOf(errorMessage));
        }
    }

    public static void checkArgument(boolean expression, String errorMessageTemplate, Object ... errorMessageArgs) {
        if (!expression) {
            throw new IllegalArgumentException(Utils.format(errorMessageTemplate, errorMessageArgs));
        }
    }

    public static void checkState(boolean isValid, @Nullable Object errorMessage) {
        if (!isValid) {
            throw new IllegalStateException(String.valueOf(errorMessage));
        }
    }

    public static void checkIndex(int index, int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Negative size: " + size);
        }
        if (index < 0 || index >= size) {
            throw new IndexOutOfBoundsException("Index out of bounds: size=" + size + ", index=" + index);
        }
    }

    public static <T> T checkNotNull(T arg, @Nullable Object errorMessage) {
        if (arg == null) {
            throw new NullPointerException(String.valueOf(errorMessage));
        }
        return arg;
    }

    public static <T> void checkListElementNotNull(List<T> list, @Nullable Object errorMessage) {
        for (T element : list) {
            if (element != null) continue;
            throw new NullPointerException(String.valueOf(errorMessage));
        }
    }

    public static <K, V> void checkMapElementNotNull(Map<K, V> map, @Nullable Object errorMessage) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (entry.getKey() != null && entry.getValue() != null) continue;
            throw new NullPointerException(String.valueOf(errorMessage));
        }
    }

    public static boolean equalsObjects(@Nullable Object x, @Nullable Object y) {
        return x == null ? y == null : x.equals(y);
    }

    private static String format(String template, Object ... args2) {
        int placeholderStart;
        if (args2 == null) {
            return template;
        }
        StringBuilder builder = new StringBuilder(template.length() + 16 * args2.length);
        int templateStart = 0;
        int i = 0;
        while (i < args2.length && (placeholderStart = template.indexOf("%s", templateStart)) != -1) {
            builder.append(template, templateStart, placeholderStart);
            builder.append(args2[i++]);
            templateStart = placeholderStart + 2;
        }
        builder.append(template, templateStart, template.length());
        if (i < args2.length) {
            builder.append(" [");
            builder.append(args2[i++]);
            while (i < args2.length) {
                builder.append(", ");
                builder.append(args2[i++]);
            }
            builder.append(']');
        }
        return builder.toString();
    }
}

