/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.tags.unsafe;

import com.example.chatmoderator.libs.grpc.Context;
import io.opencensus.internal.Utils;
import io.opencensus.tags.Tag;
import io.opencensus.tags.TagContext;
import java.util.Collections;
import java.util.Iterator;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

public final class ContextUtils {
    private static final TagContext EMPTY_TAG_CONTEXT = new EmptyTagContext();
    private static final Context.Key<TagContext> TAG_CONTEXT_KEY = Context.keyWithDefault("opencensus-tag-context-key", EMPTY_TAG_CONTEXT);

    private ContextUtils() {
    }

    public static Context withValue(Context context, @Nullable TagContext tagContext) {
        return Utils.checkNotNull(context, "context").withValue(TAG_CONTEXT_KEY, tagContext);
    }

    public static TagContext getValue(Context context) {
        TagContext tags = TAG_CONTEXT_KEY.get(context);
        return tags == null ? EMPTY_TAG_CONTEXT : tags;
    }

    @Immutable
    private static final class EmptyTagContext
    extends TagContext {
        private EmptyTagContext() {
        }

        @Override
        protected Iterator<Tag> getIterator() {
            return Collections.emptySet().iterator();
        }
    }
}

