/*
 * Decompiled with CFR 0.152.
 */
package com.example.chatmoderator;

import com.example.chatmoderator.commands.ChatModCommand;
import com.example.chatmoderator.config.ConfigManager;
import com.example.chatmoderator.libs.foliascheduler.FoliaCompatibility;
import com.example.chatmoderator.libs.foliascheduler.ServerImplementation;
import com.example.chatmoderator.listeners.ChatListener;
import com.example.chatmoderator.services.ModerationService;
import com.example.chatmoderator.utils.SchedulerUtil;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ChatModeratorPlugin
extends JavaPlugin {
    private ConfigManager configManager;
    private ModerationService moderationService;
    private SchedulerUtil schedulerUtil;
    private ChatListener chatListener;
    public static ChatModeratorPlugin plugin;
    public static ServerImplementation scheduler;
    public static Logger log;

    public void onEnable() {
        plugin = this;
        log = this.getLogger();
        scheduler = new FoliaCompatibility((Plugin)this).getServerImplementation();
        this.schedulerUtil = new SchedulerUtil((Plugin)this);
        this.configManager = new ConfigManager(this);
        this.configManager.loadConfig();
        this.moderationService = new ModerationService(this);
        this.chatListener = new ChatListener(this);
        this.getServer().getPluginManager().registerEvents((Listener)this.chatListener, (Plugin)this);
        ChatModCommand chatModCommand = new ChatModCommand(this, this.chatListener);
        this.getCommand("chatmod").setExecutor((CommandExecutor)chatModCommand);
        this.getCommand("chatmod").setTabCompleter((TabCompleter)chatModCommand);
        log.info("ChatModerator plugin has been enabled!");
        String apiKey = this.configManager.getOpenAIApiKey();
        if (apiKey == null || apiKey.equals("your-openai-api-key-here")) {
            log.warning("OpenAI API key not configured! Please set it in config.yml");
            log.warning("AI moderation will be disabled until API key is provided.");
        }
    }

    public void onDisable() {
        log.info("ChatModerator plugin has been disabled!");
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public ModerationService getModerationService() {
        return this.moderationService;
    }

    public SchedulerUtil getSchedulerUtil() {
        return this.schedulerUtil;
    }

    public void reloadPluginConfig() {
        this.configManager.reloadConfig();
        this.moderationService.updateConfiguration();
        Bukkit.getLogger().info("ChatModerator reloaded!");
    }

    public ChatListener getChatListener() {
        return this.chatListener;
    }
}

