/*
 * Decompiled with CFR 0.152.
 */
package com.example.chatmoderator.config;

import com.example.chatmoderator.ChatModeratorPlugin;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.configuration.file.FileConfiguration;

public class ConfigManager {
    private final ChatModeratorPlugin plugin;
    private FileConfiguration config;

    public ConfigManager(ChatModeratorPlugin plugin) {
        this.plugin = plugin;
    }

    public void loadConfig() {
        this.plugin.saveDefaultConfig();
        this.config = this.plugin.getConfig();
    }

    public void reloadConfig() {
        this.plugin.reloadConfig();
        this.config = this.plugin.getConfig();
    }

    public String getOpenAIApiKey() {
        return this.config.getString("openai.api-key", "");
    }

    public String getOpenAIModel() {
        return this.config.getString("openai.model", "text-moderation-latest");
    }

    public boolean isModerationEnabled() {
        return this.config.getBoolean("moderation.enabled", true);
    }

    public boolean isAIModerationEnabled() {
        return this.config.getBoolean("moderation.use-ai-moderation", true);
    }

    public boolean isWordFilterEnabled() {
        return this.config.getBoolean("moderation.use-word-filter", true);
    }

    public List<String> getBlockedWords() {
        return this.config.getStringList("moderation.blocked-words");
    }

    public Map<String, Double> getModerationThresholds() {
        HashMap<String, Double> thresholds = new HashMap<String, Double>();
        if (this.config.isConfigurationSection("moderation.thresholds")) {
            for (String key : this.config.getConfigurationSection("moderation.thresholds").getKeys(false)) {
                thresholds.put(key, this.config.getDouble("moderation.thresholds." + key));
            }
        }
        return thresholds;
    }

    public boolean shouldBlockMessage() {
        return this.config.getBoolean("actions.block-message", true);
    }

    public boolean shouldWarnPlayer() {
        return this.config.getBoolean("actions.warn-player", true);
    }

    public boolean shouldNotifyAdmins() {
        return this.config.getBoolean("actions.notify-admins", true);
    }

    public boolean shouldLogViolations() {
        return this.config.getBoolean("actions.log-violations", true);
    }

    public String getMessageBlocked() {
        return this.config.getString("messages.message-blocked", "&cYour message was blocked by the chat filter.");
    }

    public String getViolationWarning() {
        return this.config.getString("messages.violation-warning", "&eYour message contains inappropriate content. Please keep chat respectful.");
    }

    public String getAdminNotification() {
        return this.config.getString("messages.admin-notification", "&6[ChatMod] &c{player} &7tried to send: &f{message}");
    }

    public String getPluginReloaded() {
        return this.config.getString("messages.plugin-reloaded", "&aChat Moderator configuration reloaded!");
    }

    public String getPluginEnabled() {
        return this.config.getString("messages.plugin-enabled", "&aChat moderation enabled!");
    }

    public String getPluginDisabled() {
        return this.config.getString("messages.plugin-disabled", "&cChat moderation disabled!");
    }

    public boolean isDebugEnabled() {
        return this.config.getBoolean("debug.enabled", false);
    }

    public boolean shouldLogAllMessages() {
        return this.config.getBoolean("debug.log-all-messages", false);
    }

    public int getMuteDurationSeconds() {
        return this.config.getInt("moderation.mute-duration-seconds", 600);
    }
}

