/*
 * Decompiled with CFR 0.152.
 */
package com.example.chatmoderator.libs.foliascheduler.bukkit;

import com.example.chatmoderator.libs.foliascheduler.RegionSchedulerImplementation;
import com.example.chatmoderator.libs.foliascheduler.TaskImplementation;
import com.example.chatmoderator.libs.foliascheduler.bukkit.BukkitTask;
import java.util.function.Function;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;

public class BukkitRegionScheduler
implements RegionSchedulerImplementation {
    @NotNull
    private final Plugin plugin;

    public BukkitRegionScheduler(@NotNull Plugin plugin) {
        this.plugin = plugin;
    }

    @NotNull
    private <T> BukkitRunnable buildBukkitRunnable(final @NotNull Function<TaskImplementation<T>, T> function, final @NotNull BukkitTask<T> taskImplementation) {
        return new BukkitRunnable(){

            public void run() {
                taskImplementation.setCallback(function.apply(taskImplementation));
                taskImplementation.asFuture().complete(taskImplementation);
            }
        };
    }

    @Override
    public void execute(final @NotNull Runnable run) {
        new BukkitRunnable(){

            public void run() {
                run.run();
            }
        }.runTask(this.plugin);
    }

    @Override
    @NotNull
    public <T> TaskImplementation<T> run(@NotNull Function<TaskImplementation<T>, T> function) {
        BukkitTask taskImplementation = new BukkitTask(this.plugin, false);
        BukkitRunnable runnable2 = this.buildBukkitRunnable(function, taskImplementation);
        taskImplementation.setScheduledTask(runnable2.runTask(this.plugin));
        return taskImplementation;
    }

    @Override
    @NotNull
    public <T> TaskImplementation<T> runDelayed(@NotNull Function<TaskImplementation<T>, T> function, long delay) {
        BukkitTask taskImplementation = new BukkitTask(this.plugin, false);
        BukkitRunnable runnable2 = this.buildBukkitRunnable(function, taskImplementation);
        taskImplementation.setScheduledTask(runnable2.runTaskLater(this.plugin, delay));
        return taskImplementation;
    }

    @Override
    @NotNull
    public <T> TaskImplementation<T> runAtFixedRate(@NotNull Function<TaskImplementation<T>, T> function, long delay, long period) {
        BukkitTask taskImplementation = new BukkitTask(this.plugin, true);
        BukkitRunnable runnable2 = this.buildBukkitRunnable(function, taskImplementation);
        taskImplementation.setScheduledTask(runnable2.runTaskTimer(this.plugin, delay, period));
        return taskImplementation;
    }
}

