/*
 * Decompiled with CFR 0.152.
 */
package com.example.chatmoderator.libs.foliascheduler.mappingio.format;

import com.example.chatmoderator.libs.foliascheduler.mappingio.format.FeatureSetUtil;

public interface FeatureSet {
    public boolean hasNamespaces();

    public MetadataSupport fileMetadata();

    public MetadataSupport elementMetadata();

    public NameSupport packages();

    public ClassSupport classes();

    public MemberSupport fields();

    public MemberSupport methods();

    public LocalSupport args();

    public LocalSupport vars();

    public ElementCommentSupport elementComments();

    public boolean hasFileComments();

    default public boolean supportsPackages() {
        return this.packages().srcNames() != FeaturePresence.ABSENT || this.packages().dstNames() != FeaturePresence.ABSENT;
    }

    default public boolean supportsClasses() {
        return this.classes().srcNames() != FeaturePresence.ABSENT || this.classes().dstNames() != FeaturePresence.ABSENT;
    }

    default public boolean supportsFields() {
        return FeatureSetUtil.isSupported(this.fields());
    }

    default public boolean supportsMethods() {
        return FeatureSetUtil.isSupported(this.methods());
    }

    default public boolean supportsArgs() {
        return FeatureSetUtil.isSupported(this.args());
    }

    default public boolean supportsVars() {
        return FeatureSetUtil.isSupported(this.vars());
    }

    public static interface NameSupport {
        public FeaturePresence srcNames();

        public FeaturePresence dstNames();
    }

    public static enum FeaturePresence {
        REQUIRED,
        OPTIONAL,
        ABSENT;

    }

    public static interface ClassSupport
    extends NameSupport {
        public boolean hasRepackaging();
    }

    public static interface MemberSupport
    extends NameSupport,
    DescSupport {
    }

    public static interface LocalSupport
    extends NameSupport,
    DescSupport {
        public FeaturePresence positions();

        public FeaturePresence lvIndices();

        public FeaturePresence lvtRowIndices();

        public FeaturePresence startOpIndices();

        public FeaturePresence endOpIndices();
    }

    public static enum ElementCommentSupport {
        NAMESPACED,
        SHARED,
        NONE;

    }

    public static interface DescSupport {
        public FeaturePresence srcDescs();

        public FeaturePresence dstDescs();
    }

    public static enum MetadataSupport {
        NONE,
        FIXED,
        ARBITRARY;

    }
}

