/*
 * Decompiled with CFR 0.152.
 */
package com.example.chatmoderator.listeners;

import com.example.chatmoderator.ChatModeratorPlugin;
import com.example.chatmoderator.config.ConfigManager;
import com.example.chatmoderator.services.ModerationService;
import com.example.chatmoderator.utils.SchedulerUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;

public class ChatListener
implements Listener {
    private final ChatModeratorPlugin plugin;
    private final ConfigManager configManager;
    private final ModerationService moderationService;
    private final Map<Player, Long> mutedPlayers = new ConcurrentHashMap<Player, Long>();

    public ChatListener(ChatModeratorPlugin plugin) {
        this.plugin = plugin;
        this.configManager = plugin.getConfigManager();
        this.moderationService = plugin.getModerationService();
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        String message = event.getMessage();
        if (this.isMuted(player)) {
            event.setCancelled(true);
            player.sendMessage(String.valueOf(ChatColor.RED) + "You are temporarily muted!");
            return;
        }
        if (this.configManager.isWordFilterEnabled()) {
            for (String word : this.configManager.getBlockedWords()) {
                if (!message.toLowerCase().contains(word.toLowerCase())) continue;
                event.setCancelled(true);
                this.blockMessage(player, message, "Contains blocked word: " + word);
                return;
            }
        }
        if (player.hasPermission("chatmoderator.bypass")) {
            return;
        }
        if (this.configManager.isAIModerationEnabled()) {
            this.moderationService.moderateAfterSend(player, message);
        }
    }

    private void blockMessage(Player player, String message, String reason) {
        SchedulerUtil.runGlobal(() -> {
            for (Player p : Bukkit.getOnlinePlayers()) {
                if (!p.isOp() && !p.hasPermission("chatmoderator.bypass")) continue;
                p.sendMessage(String.valueOf(ChatColor.RED) + "[MODERATION] " + player.getName() + " tried to send: " + message + " | Reason: " + reason);
            }
        });
        int muteDurationSeconds = this.configManager.getMuteDurationSeconds();
        this.mutedPlayers.put(player, System.currentTimeMillis() + (long)muteDurationSeconds * 1000L);
        if (this.configManager.shouldWarnPlayer()) {
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.configManager.getViolationWarning()));
        }
        if (this.configManager.shouldLogViolations()) {
            this.plugin.getLogger().warning("Chat violation by " + player.getName() + " | Reason: " + reason + " | Message: " + message);
        }
    }

    public boolean isMuted(Player player) {
        if (!this.mutedPlayers.containsKey(player)) {
            return false;
        }
        long unmuteTime = this.mutedPlayers.get(player);
        if (System.currentTimeMillis() >= unmuteTime) {
            this.mutedPlayers.remove(player);
            return false;
        }
        return true;
    }

    public void unmutePlayer(Player player) {
        if (this.mutedPlayers.containsKey(player)) {
            this.mutedPlayers.remove(player);
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "You have been unmuted by an admin.");
        } else {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You were not muted.");
        }
    }

    public Map<Player, Long> getMutedPlayers() {
        return this.mutedPlayers;
    }
}

