/*
 * Decompiled with CFR 0.152.
 */
package com.example.chatmoderator.utils;

import com.example.chatmoderator.ChatModeratorPlugin;
import com.example.chatmoderator.libs.foliascheduler.folia.FoliaTask;
import com.example.chatmoderator.libs.foliascheduler.util.ServerVersions;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;

public class SchedulerUtil {
    private static AtomicBoolean SHUTTING_DOWN = new AtomicBoolean(false);

    public SchedulerUtil(Plugin plugin) {
    }

    public static void ensureEntity(@NotNull Entity entity, @NotNull Runnable runnable2) {
        if (entity instanceof Player && !((Player)entity).isOnline()) {
            return;
        }
        if (ServerVersions.isFolia()) {
            if (ChatModeratorPlugin.scheduler.isOwnedByCurrentRegion(entity) || SHUTTING_DOWN.get()) {
                SchedulerUtil.runCatch(runnable2, "Error in ensureEntity task on shutdown");
                return;
            }
            ChatModeratorPlugin.scheduler.entity(entity).execute(runnable2, null, 1L);
        } else {
            if (Bukkit.isPrimaryThread()) {
                SchedulerUtil.runCatch(runnable2, "Error in ensureEntity task");
                return;
            }
            Bukkit.getScheduler().runTask((Plugin)ChatModeratorPlugin.plugin, runnable2);
        }
    }

    public static Object ensureEntityLater(@NotNull Entity entity, @NotNull Runnable runnable2, long delay) {
        if (entity instanceof Player && !((Player)entity).isOnline()) {
            return null;
        }
        delay = Math.max(1L, delay);
        if (ServerVersions.isFolia()) {
            return ChatModeratorPlugin.scheduler.entity(entity).execute(runnable2, null, delay);
        }
        return Bukkit.getScheduler().runTaskLater((Plugin)ChatModeratorPlugin.plugin, runnable2, delay);
    }

    public static Object ensureEntityTimer(@NotNull Entity entity, @NotNull Runnable runnable2, long delay, long repeat) {
        if (entity instanceof Player && !((Player)entity).isOnline()) {
            return null;
        }
        delay = Math.max(1L, delay);
        repeat = Math.max(1L, repeat);
        if (ServerVersions.isFolia()) {
            return ChatModeratorPlugin.scheduler.entity(entity).runAtFixedRate(task -> {
                if (!SchedulerUtil.runCatch(runnable2, "Error in ensureEntityTimer task")) {
                    task.cancel();
                }
            }, null, delay, repeat);
        }
        return Bukkit.getScheduler().runTaskTimer((Plugin)ChatModeratorPlugin.plugin, runnable2, delay, repeat);
    }

    public static void ensureLocation(@NotNull Location location, @NotNull Runnable runnable2) {
        if (ServerVersions.isFolia()) {
            if (ChatModeratorPlugin.scheduler.isOwnedByCurrentRegion(location) || SHUTTING_DOWN.get()) {
                SchedulerUtil.runCatch(runnable2, "Error in ensureLocation task on shutdown");
                return;
            }
            ChatModeratorPlugin.scheduler.region(location).execute(runnable2);
        } else {
            if (Bukkit.isPrimaryThread()) {
                SchedulerUtil.runCatch(runnable2, "Error in ensureLocation task on shutdown");
                return;
            }
            Bukkit.getScheduler().runTask((Plugin)ChatModeratorPlugin.plugin, runnable2);
        }
    }

    @NotNull
    public static Object ensureLocationLater(@NotNull Location location, @NotNull Runnable runnable2, long delay) {
        delay = Math.max(1L, delay);
        if (ServerVersions.isFolia()) {
            return ChatModeratorPlugin.scheduler.region(location).runDelayed(task -> {
                if (!SchedulerUtil.runCatch(runnable2, "Error in ensureLocationLater")) {
                    task.cancel();
                }
            }, delay);
        }
        return Bukkit.getScheduler().runTaskLater((Plugin)ChatModeratorPlugin.plugin, runnable2, delay);
    }

    @NotNull
    public static Object ensureLocationTimer(@NotNull Location location, @NotNull Runnable runnable2, long delay, long repeat) {
        delay = Math.max(1L, delay);
        repeat = Math.max(1L, repeat);
        if (ServerVersions.isFolia()) {
            return ChatModeratorPlugin.scheduler.region(location).runAtFixedRate(task -> {
                if (!SchedulerUtil.runCatch(runnable2, "Error in ensureLocationTimer task")) {
                    task.cancel();
                }
            }, delay, repeat);
        }
        return Bukkit.getScheduler().runTaskTimer((Plugin)ChatModeratorPlugin.plugin, runnable2, delay, repeat);
    }

    public static void runAsync(@NotNull Runnable runnable2) {
        if (ServerVersions.isFolia()) {
            if (SHUTTING_DOWN.get()) {
                SchedulerUtil.runCatch(runnable2, "Error in runAsync task on shutdown");
                return;
            }
            ChatModeratorPlugin.scheduler.async().runNow(task -> {
                if (!SchedulerUtil.runCatch(runnable2, "Error in runAsync task")) {
                    task.cancel();
                }
            });
        } else {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)ChatModeratorPlugin.plugin, runnable2);
        }
    }

    @NotNull
    public static Object runAsyncLater(@NotNull Runnable runnable2, long delay) {
        delay = Math.max(1L, delay);
        if (ServerVersions.isFolia()) {
            return ChatModeratorPlugin.scheduler.async().runDelayed(task -> {
                if (!SchedulerUtil.runCatch(runnable2, "Error in runAsyncLater task")) {
                    task.cancel();
                }
            }, delay * 50L, TimeUnit.MILLISECONDS);
        }
        return Bukkit.getScheduler().runTaskLater((Plugin)ChatModeratorPlugin.plugin, runnable2, delay);
    }

    @NotNull
    public static Object runAsyncTimer(@NotNull Runnable runnable2, long delay, long repeat) {
        delay = Math.max(1L, delay);
        if (ServerVersions.isFolia()) {
            return ChatModeratorPlugin.scheduler.async().runAtFixedRate(task -> runnable2.run(), delay * 50L, repeat * 50L, TimeUnit.MILLISECONDS);
        }
        return Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)ChatModeratorPlugin.plugin, runnable2, delay, repeat);
    }

    public static void runGlobal(@NotNull Runnable runnable2) {
        if (ServerVersions.isFolia()) {
            if (SHUTTING_DOWN.get()) {
                SchedulerUtil.runCatch(runnable2, "Error in runGlobal task on shutdown");
                return;
            }
            ChatModeratorPlugin.scheduler.global().run(task -> {
                if (!SchedulerUtil.runCatch(runnable2, "Error in runGlobal task")) {
                    task.cancel();
                }
            });
        } else {
            Bukkit.getScheduler().runTask((Plugin)ChatModeratorPlugin.plugin, runnable2);
        }
    }

    @NotNull
    public static Object runGlobalLater(@NotNull Runnable runnable2, long delay) {
        delay = Math.max(1L, delay);
        if (ServerVersions.isFolia()) {
            return ChatModeratorPlugin.scheduler.global().runDelayed(task -> {
                if (!SchedulerUtil.runCatch(runnable2, "Error in runGlobalLater task")) {
                    task.cancel();
                }
            }, delay);
        }
        return Bukkit.getScheduler().runTaskLater((Plugin)ChatModeratorPlugin.plugin, runnable2, delay);
    }

    @NotNull
    public static Object runGlobalTimer(@NotNull Runnable runnable2, long delay, long repeat) {
        delay = Math.max(1L, delay);
        if (ServerVersions.isFolia()) {
            return ChatModeratorPlugin.scheduler.global().runAtFixedRate(task -> {
                if (!SchedulerUtil.runCatch(runnable2, "Error in runGlobalTimer task")) {
                    task.cancel();
                }
            }, delay, repeat);
        }
        return Bukkit.getScheduler().runTaskTimer((Plugin)ChatModeratorPlugin.plugin, runnable2, delay, repeat);
    }

    public static boolean cancelTask(Object task) {
        if (task == null) {
            return false;
        }
        if (ServerVersions.isFolia()) {
            if (task instanceof FoliaTask) {
                ((FoliaTask)task).cancel();
                return true;
            }
        } else if (task instanceof BukkitTask) {
            ((BukkitTask)task).cancel();
            return true;
        }
        return false;
    }

    public static boolean isTaskCancelled(Object task) {
        if (task == null) {
            return true;
        }
        if (ServerVersions.isFolia()) {
            if (task instanceof FoliaTask) {
                return ((FoliaTask)task).isCancelled();
            }
        } else if (task instanceof BukkitTask) {
            return ((BukkitTask)task).isCancelled();
        }
        return false;
    }

    private static boolean runCatch(Runnable runnable2, String error) {
        try {
            runnable2.run();
            return true;
        }
        catch (Exception e) {
            ChatModeratorPlugin.log.log(Level.WARNING, error, e);
            return false;
        }
    }

    public static void shutdown() {
        SHUTTING_DOWN.set(true);
    }
}

