/*
 * Decompiled with CFR 0.152.
 */
package autovalue.shaded.com.google.auto.common;

import autovalue.shaded.com.google.auto.common.AnnotationOutput;
import autovalue.shaded.com.google.auto.common.AnnotationValues;
import autovalue.shaded.com.google.auto.common.MoreElements;
import autovalue.shaded.com.google.auto.common.MoreStreams;
import autovalue.shaded.com.google.auto.common.MoreTypes;
import autovalue.shaded.com.google.common.base.Equivalence;
import autovalue.shaded.com.google.common.base.Preconditions;
import autovalue.shaded.com.google.common.collect.ImmutableMap;
import autovalue.shaded.com.google.common.collect.ImmutableSet;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.ElementFilter;

public final class AnnotationMirrors {
    private static final Equivalence<AnnotationMirror> ANNOTATION_MIRROR_EQUIVALENCE = new Equivalence<AnnotationMirror>(){

        @Override
        protected boolean doEquivalent(AnnotationMirror left, AnnotationMirror right) {
            return MoreTypes.equivalence().equivalent(left.getAnnotationType(), right.getAnnotationType()) && AnnotationValues.equivalence().pairwise().equivalent(AnnotationMirrors.getAnnotationValuesWithDefaults(left).values(), AnnotationMirrors.getAnnotationValuesWithDefaults(right).values());
        }

        @Override
        protected int doHash(AnnotationMirror annotation) {
            DeclaredType type = annotation.getAnnotationType();
            Collection annotationValues = AnnotationMirrors.getAnnotationValuesWithDefaults(annotation).values();
            return Arrays.hashCode(new int[]{MoreTypes.equivalence().hash(type), AnnotationValues.equivalence().pairwise().hash(annotationValues)});
        }

        public String toString() {
            return "AnnotationMirrors.equivalence()";
        }
    };

    public static Equivalence<AnnotationMirror> equivalence() {
        return ANNOTATION_MIRROR_EQUIVALENCE;
    }

    public static ImmutableMap<ExecutableElement, AnnotationValue> getAnnotationValuesWithDefaults(AnnotationMirror annotation) {
        ImmutableMap.Builder<ExecutableElement, AnnotationValue> values2 = ImmutableMap.builder();
        Map<? extends ExecutableElement, ? extends AnnotationValue> declaredValues = Collections.unmodifiableMap(annotation.getElementValues());
        for (ExecutableElement method : ElementFilter.methodsIn(annotation.getAnnotationType().asElement().getEnclosedElements())) {
            if (declaredValues.containsKey(method)) {
                values2.put(method, declaredValues.get(method));
                continue;
            }
            if (method.getDefaultValue() != null) {
                values2.put(method, method.getDefaultValue());
                continue;
            }
            throw new IllegalStateException("Unset annotation value without default should never happen: " + MoreElements.asType(method.getEnclosingElement()).getQualifiedName() + '.' + method.getSimpleName() + "()");
        }
        return values2.build();
    }

    public static AnnotationValue getAnnotationValue(AnnotationMirror annotationMirror, String elementName) {
        return AnnotationMirrors.getAnnotationElementAndValue(annotationMirror, elementName).getValue();
    }

    public static Map.Entry<ExecutableElement, AnnotationValue> getAnnotationElementAndValue(AnnotationMirror annotationMirror, String elementName) {
        Preconditions.checkNotNull(annotationMirror);
        Preconditions.checkNotNull(elementName);
        for (Map.Entry entry : AnnotationMirrors.getAnnotationValuesWithDefaults(annotationMirror).entrySet()) {
            if (!((ExecutableElement)entry.getKey()).getSimpleName().contentEquals(elementName)) continue;
            return entry;
        }
        throw new IllegalArgumentException(String.format("@%s does not define an element %s()", MoreElements.asType(annotationMirror.getAnnotationType().asElement()).getQualifiedName(), elementName));
    }

    public static ImmutableSet<? extends AnnotationMirror> getAnnotatedAnnotations(Element element, Class<? extends Annotation> annotationClass) {
        String name = annotationClass.getCanonicalName();
        if (name == null) {
            return ImmutableSet.of();
        }
        return AnnotationMirrors.getAnnotatedAnnotations(element, name);
    }

    public static ImmutableSet<? extends AnnotationMirror> getAnnotatedAnnotations(Element element, TypeElement annotation) {
        return element.getAnnotationMirrors().stream().filter(input -> MoreElements.isAnnotationPresent(input.getAnnotationType().asElement(), annotation)).collect(MoreStreams.toImmutableSet());
    }

    public static ImmutableSet<? extends AnnotationMirror> getAnnotatedAnnotations(Element element, String annotationName) {
        return element.getAnnotationMirrors().stream().filter(input -> MoreElements.isAnnotationPresent(input.getAnnotationType().asElement(), annotationName)).collect(MoreStreams.toImmutableSet());
    }

    public static String toString(AnnotationMirror annotationMirror) {
        return AnnotationOutput.toString(annotationMirror);
    }

    private AnnotationMirrors() {
    }
}

