/*
 * Decompiled with CFR 0.152.
 */
package com.example.chatmoderator.commands;

import com.example.chatmoderator.ChatModeratorPlugin;
import com.example.chatmoderator.config.ConfigManager;
import com.example.chatmoderator.listeners.ChatListener;
import com.example.chatmoderator.services.ModerationService;
import com.example.chatmoderator.utils.SchedulerUtil;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class ChatModCommand
implements CommandExecutor,
TabCompleter {
    private final ChatModeratorPlugin plugin;
    private final ConfigManager configManager;
    private final ChatListener chatListener;
    private final ModerationService moderationService;

    public ChatModCommand(ChatModeratorPlugin plugin, ChatListener chatListener) {
        this.plugin = plugin;
        this.configManager = plugin.getConfigManager();
        this.chatListener = chatListener;
        this.moderationService = plugin.getModerationService();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args2) {
        if (args2.length == 0) {
            this.sendHelpMessage(sender);
            return true;
        }
        switch (args2[0].toLowerCase()) {
            case "reload": 
            case "status": 
            case "toggle": 
            case "add-word": 
            case "remove-word": {
                if (sender.hasPermission("chatmoderator.admin")) break;
                sender.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
                return true;
            }
        }
        switch (args2[0].toLowerCase()) {
            case "reload": {
                this.handleReload(sender);
                break;
            }
            case "status": {
                this.handleStatus(sender);
                break;
            }
            case "toggle": {
                this.handleToggle(sender);
                break;
            }
            case "add-word": {
                if (args2.length < 2) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /chatmod add-word <word>");
                    return true;
                }
                this.handleAddWord(sender, args2[1]);
                break;
            }
            case "remove-word": {
                if (args2.length < 2) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /chatmod remove-word <word>");
                    return true;
                }
                this.handleRemoveWord(sender, args2[1]);
                break;
            }
            case "unmute": {
                if (!sender.hasPermission("chatmoderator.admin") && !sender.hasPermission("chatmoderator.command.unmute")) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
                    return true;
                }
                if (args2.length < 2) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /chatmod unmute <player>");
                    return true;
                }
                this.handleUnmute(sender, args2[1]);
                break;
            }
            case "aitest": {
                if (!sender.hasPermission("chatmoderator.admin")) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
                    return true;
                }
                if (args2.length < 2) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /chatmod aitest <message>");
                    return true;
                }
                this.handleAITest(sender, String.join((CharSequence)" ", args2).replaceFirst("aitest ", ""));
                break;
            }
            default: {
                this.sendHelpMessage(sender);
            }
        }
        return true;
    }

    private void sendHelpMessage(CommandSender sender) {
        sender.sendMessage(String.valueOf(ChatColor.GOLD) + "=== Chat Moderator Commands ===");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/chatmod reload " + String.valueOf(ChatColor.WHITE) + "- Reload configuration");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/chatmod status " + String.valueOf(ChatColor.WHITE) + "- Show plugin status");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/chatmod toggle " + String.valueOf(ChatColor.WHITE) + "- Toggle moderation on/off");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/chatmod add-word <word> " + String.valueOf(ChatColor.WHITE) + "- Add blocked word");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/chatmod remove-word <word> " + String.valueOf(ChatColor.WHITE) + "- Remove blocked word");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/chatmod unmute <player> " + String.valueOf(ChatColor.WHITE) + "- Unmute a muted player");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/chatmod aitest <message> " + String.valueOf(ChatColor.WHITE) + "- Test AI moderation");
    }

    private void handleReload(CommandSender sender) {
        try {
            this.plugin.reloadPluginConfig();
            String message = ChatColor.translateAlternateColorCodes((char)'&', (String)this.configManager.getPluginReloaded());
            sender.sendMessage(message);
        }
        catch (Exception e) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Error reloading configuration: " + e.getMessage());
        }
    }

    private void handleStatus(CommandSender sender) {
        sender.sendMessage(String.valueOf(ChatColor.GOLD) + "=== Chat Moderator Status ===");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Moderation Enabled: " + (this.configManager.isModerationEnabled() ? String.valueOf(ChatColor.GREEN) + "Yes" : String.valueOf(ChatColor.RED) + "No"));
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "AI Moderation: " + (this.configManager.isAIModerationEnabled() ? String.valueOf(ChatColor.GREEN) + "Enabled" : String.valueOf(ChatColor.RED) + "Disabled"));
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Word Filter: " + (this.configManager.isWordFilterEnabled() ? String.valueOf(ChatColor.GREEN) + "Enabled" : String.valueOf(ChatColor.RED) + "Disabled"));
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Blocked Words: " + String.valueOf(ChatColor.WHITE) + this.configManager.getBlockedWords().size());
        boolean openaiConfigured = this.configManager.getOpenAIApiKey() != null && !this.configManager.getOpenAIApiKey().equals("your-openai-api-key-here");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "OpenAI API: " + (openaiConfigured ? String.valueOf(ChatColor.GREEN) + "Configured" : String.valueOf(ChatColor.RED) + "Not Configured"));
        boolean geminiConfigured = this.configManager.getGeminiApiKey() != null && !this.configManager.getGeminiApiKey().equals("your-gemini-api-key-here");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Gemini API: " + (geminiConfigured ? String.valueOf(ChatColor.GREEN) + "Configured" : String.valueOf(ChatColor.RED) + "Not Configured"));
        String preferredProvider = this.configManager.getPreferredAIProvider();
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Preferred AI Provider: " + (preferredProvider != null ? String.valueOf(ChatColor.GREEN) + preferredProvider : String.valueOf(ChatColor.RED) + "Not Configured"));
    }

    private void handleToggle(CommandSender sender) {
        FileConfiguration config = this.plugin.getConfig();
        boolean newState = !this.configManager.isModerationEnabled();
        config.set("moderation.enabled", (Object)newState);
        this.plugin.saveConfig();
        this.configManager.reloadConfig();
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(newState ? this.configManager.getPluginEnabled() : this.configManager.getPluginDisabled())));
    }

    private void handleAddWord(CommandSender sender, String word) {
        FileConfiguration config = this.plugin.getConfig();
        ArrayList<String> blockedWords = new ArrayList<String>(config.getStringList("moderation.blocked-words"));
        if (blockedWords.contains(word.toLowerCase())) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Word '" + word + "' is already in the blocked list.");
            return;
        }
        blockedWords.add(word.toLowerCase());
        config.set("moderation.blocked-words", blockedWords);
        this.plugin.saveConfig();
        this.configManager.reloadConfig();
        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Added '" + word + "' to blocked words list.");
    }

    private void handleRemoveWord(CommandSender sender, String word) {
        FileConfiguration config = this.plugin.getConfig();
        ArrayList blockedWords = new ArrayList(config.getStringList("moderation.blocked-words"));
        if (!blockedWords.contains(word.toLowerCase())) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Word '" + word + "' is not in the blocked list.");
            return;
        }
        blockedWords.remove(word.toLowerCase());
        config.set("moderation.blocked-words", blockedWords);
        this.plugin.saveConfig();
        this.configManager.reloadConfig();
        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Removed '" + word + "' from blocked words list.");
    }

    private void handleUnmute(CommandSender sender, String targetName) {
        Player target = Bukkit.getPlayerExact((String)targetName);
        if (target == null) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Player not found.");
            return;
        }
        if (this.chatListener.isMuted(target)) {
            this.chatListener.unmutePlayer(target);
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Player " + target.getName() + " has been unmuted.");
        } else {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Player " + target.getName() + " is not muted.");
        }
    }

    private void handleAITest(CommandSender sender, String message) {
        sender.sendMessage(String.valueOf(ChatColor.GOLD) + "Running AI moderation test...");
        this.moderationService.checkAIModerationAsync(message).thenAccept(result -> SchedulerUtil.runGlobal(() -> {
            sender.sendMessage(String.valueOf(ChatColor.GOLD) + "=== AI Moderation Test Result ===");
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Blocked: " + (result.isBlocked() ? String.valueOf(ChatColor.RED) + "Yes" : String.valueOf(ChatColor.GREEN) + "No"));
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Reason: " + result.getReason());
        }));
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args2) {
        ArrayList<String> completions;
        block4: {
            block5: {
                block3: {
                    String[] subcommands;
                    completions = new ArrayList<String>();
                    if (args2.length != 1) break block3;
                    for (String sub : subcommands = new String[]{"reload", "status", "toggle", "add-word", "remove-word", "unmute", "aitest"}) {
                        if (!sub.startsWith(args2[0].toLowerCase())) continue;
                        completions.add(sub);
                    }
                    break block4;
                }
                if (args2.length != 2) break block4;
                if (!args2[0].equalsIgnoreCase("remove-word")) break block5;
                for (String word : this.configManager.getBlockedWords()) {
                    if (!word.startsWith(args2[1].toLowerCase())) continue;
                    completions.add(word);
                }
                break block4;
            }
            if (!args2[0].equalsIgnoreCase("unmute")) break block4;
            for (Player p : Bukkit.getOnlinePlayers()) {
                if (!this.chatListener.isMuted(p) || !p.getName().toLowerCase().startsWith(args2[1].toLowerCase())) continue;
                completions.add(p.getName());
            }
        }
        return completions;
    }
}

