/*
 * Decompiled with CFR 0.152.
 */
package com.example.chatmoderator.config;

import com.example.chatmoderator.ChatModeratorPlugin;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.configuration.file.FileConfiguration;

public class ConfigManager {
    private final ChatModeratorPlugin plugin;
    private FileConfiguration config;

    public ConfigManager(ChatModeratorPlugin plugin) {
        this.plugin = plugin;
    }

    public void loadConfig() {
        this.plugin.saveDefaultConfig();
        this.config = this.plugin.getConfig();
        this.applyNewConfigOptions();
    }

    public void reloadConfig() {
        this.plugin.reloadConfig();
        this.config = this.plugin.getConfig();
        this.applyNewConfigOptions();
    }

    public void applyNewConfigOptions() {
        if (!this.config.contains("ai.preferred-provider")) {
            this.config.set("ai.preferred-provider", (Object)"openai");
        }
        if (!this.config.contains("moderation.use-ai-moderation")) {
            this.config.set("moderation.use-ai-moderation", (Object)true);
        }
        if (!this.config.contains("moderation.use-word-filter")) {
            this.config.set("moderation.use-word-filter", (Object)true);
        }
        if (!this.config.contains("actions.block-message")) {
            this.config.set("actions.block-message", (Object)true);
        }
        if (!this.config.contains("actions.warn-player")) {
            this.config.set("actions.warn-player", (Object)true);
        }
        if (!this.config.contains("actions.notify-admins")) {
            this.config.set("actions.notify-admins", (Object)true);
        }
        if (!this.config.contains("actions.log-violations")) {
            this.config.set("actions.log-violations", (Object)true);
        }
        if (!this.config.contains("debug.enabled")) {
            this.config.set("debug.enabled", (Object)false);
        }
        if (!this.config.contains("debug.log-all-messages")) {
            this.config.set("debug.log-all-messages", (Object)false);
        }
        if (!this.config.contains("moderation.mute-duration-seconds")) {
            this.config.set("moderation.mute-duration-seconds", (Object)600);
        }
        if (!this.config.contains("messages.message-blocked")) {
            this.config.set("messages.message-blocked", (Object)"&cYour message was blocked by the chat filter.");
        }
        if (!this.config.contains("messages.violation-warning")) {
            this.config.set("messages.violation-warning", (Object)"&eYour message contains inappropriate content. You have been muted, ask an admin for an unmute.");
        }
        if (!this.config.contains("messages.admin-notification")) {
            this.config.set("messages.admin-notification", (Object)"&6[ChatMod] &c{player} &7tried to send: &f{message}");
        }
        if (!this.config.contains("messages.plugin-reloaded")) {
            this.config.set("messages.plugin-reloaded", (Object)"&aChat Moderator configuration reloaded!");
        }
        if (!this.config.contains("messages.plugin-enabled")) {
            this.config.set("messages.plugin-enabled", (Object)"&aChat moderation enabled!");
        }
        if (!this.config.contains("messages.plugin-disabled")) {
            this.config.set("messages.plugin-disabled", (Object)"&cChat moderation disabled!");
        }
        this.plugin.saveConfig();
    }

    public String getOpenAIApiKey() {
        return this.config.getString("openai.api-key", "");
    }

    public String getOpenAIModel() {
        return this.config.getString("openai.model", "text-moderation-latest");
    }

    public String getGeminiApiKey() {
        return this.config.getString("gemini.api-key", "");
    }

    public String getGeminiModel() {
        return this.config.getString("gemini.model", "gemini-1.5-flash");
    }

    public String getPreferredAIProvider() {
        return this.config.getString("ai.preferred-provider", "openai");
    }

    public boolean isModerationEnabled() {
        return this.config.getBoolean("moderation.enabled", true);
    }

    public boolean isAIModerationEnabled() {
        return this.config.getBoolean("moderation.use-ai-moderation", true);
    }

    public boolean isWordFilterEnabled() {
        return this.config.getBoolean("moderation.use-word-filter", true);
    }

    public List<String> getBlockedWords() {
        return this.config.getStringList("moderation.blocked-words");
    }

    public Map<String, Double> getModerationThresholds() {
        HashMap<String, Double> thresholds = new HashMap<String, Double>();
        if (this.config.isConfigurationSection("moderation.thresholds")) {
            for (String key : this.config.getConfigurationSection("moderation.thresholds").getKeys(false)) {
                thresholds.put(key, this.config.getDouble("moderation.thresholds." + key));
            }
        }
        return thresholds;
    }

    public boolean shouldBlockMessage() {
        return this.config.getBoolean("actions.block-message", true);
    }

    public boolean shouldWarnPlayer() {
        return this.config.getBoolean("actions.warn-player", true);
    }

    public boolean shouldNotifyAdmins() {
        return this.config.getBoolean("actions.notify-admins", true);
    }

    public boolean shouldLogViolations() {
        return this.config.getBoolean("actions.log-violations", true);
    }

    public String getMessageBlocked() {
        return this.config.getString("messages.message-blocked", "&cYour message was blocked by the chat filter.");
    }

    public String getViolationWarning() {
        return this.config.getString("messages.violation-warning", "&eYour message contains inappropriate content. You have been muted, ask an admin for an unmute.");
    }

    public String getAdminNotification() {
        return this.config.getString("messages.admin-notification", "&6[ChatMod] &c{player} &7tried to send: &f{message}");
    }

    public String getPluginReloaded() {
        return this.config.getString("messages.plugin-reloaded", "&aChat Moderator configuration reloaded!");
    }

    public String getPluginEnabled() {
        return this.config.getString("messages.plugin-enabled", "&aChat moderation enabled!");
    }

    public String getPluginDisabled() {
        return this.config.getString("messages.plugin-disabled", "&cChat moderation disabled!");
    }

    public boolean isDebugEnabled() {
        return this.config.getBoolean("debug.enabled", false);
    }

    public boolean shouldLogAllMessages() {
        return this.config.getBoolean("debug.log-all-messages", false);
    }

    public int getMuteDurationSeconds() {
        return this.config.getInt("moderation.mute-duration-seconds", 600);
    }
}

