/*
 * Decompiled with CFR 0.152.
 */
package com.example.chatmoderator.utils;

public class ModerationResult {
    private final boolean blocked;
    private final String reason;
    private final ViolationType violationType;

    private ModerationResult(boolean blocked, String reason, ViolationType violationType) {
        this.blocked = blocked;
        this.reason = reason;
        this.violationType = violationType;
    }

    public static ModerationResult safe() {
        return new ModerationResult(false, "Safe", ViolationType.NONE);
    }

    public static ModerationResult block(String reason) {
        return new ModerationResult(true, reason, ViolationType.WORD_FILTER);
    }

    public static ModerationResult block(String reason, ViolationType type) {
        return new ModerationResult(true, reason, type);
    }

    public static ModerationResult error(String reason) {
        return new ModerationResult(true, reason, ViolationType.ERROR);
    }

    public boolean isBlocked() {
        return this.blocked;
    }

    public boolean isSafe() {
        return !this.blocked;
    }

    public String getReason() {
        return this.reason;
    }

    public ViolationType getViolationType() {
        return this.violationType;
    }

    public String toString() {
        return "ModerationResult{blocked=" + this.blocked + ", reason='" + this.reason + "', violationType=" + String.valueOf((Object)this.violationType) + "}";
    }

    public static enum ViolationType {
        NONE,
        WORD_FILTER,
        HATE_SPEECH,
        SEXUAL,
        VIOLENCE,
        SELF_HARM,
        SPAM,
        HARASSMENT,
        ERROR;

    }
}

